
/* spy.c - routines for delaing with spy reports etc. */

/*
 * $Log:	spy.c,v $
 * Revision 1.8  89/02/25  04:07:53  muir
 * Removed goto
 * 
 * Revision 1.7  89/02/22  20:03:51  muir
 * indent and lint processed
 * 
 * Revision 1.6  88/11/21  19:07:47  muir
 * after rynes patch 01
 * (cargo command)
 *
 * Revision 1.5  88/08/15  19:18:38  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/spy.c,v 1.8 89/02/25 04:07:53 muir Exp $";
#endif

# include	"ve.h"

/*
 * spy - Read and process spy reports.
 */
spy(fp)
	FILE   *fp;
{
	register int x, y;
	register int nx, ny;
	Sector *mp;
	Value  *vp;
	register int i;
	char    buf[BUFSIZ];

	while (fgets(buf, sizeof buf, fp) != NULL) {
		if (buf[3] != ',')
			continue;
		x = atoi(buf);
		y = atoi(&buf[4]);
		nx = xoffset(x);
		ny = yoffset(y);
		maxxy(nx, ny);
		mp = map[nx][ny];
		if (mp == NULL)
			map[nx][ny] = mp = newmap();
		if (mp->vp == NULL)
			mp->vp = newval();
		vp = mp->vp;
		mp->own = 2;
		vp->val[COU] = atoi(&buf[12]);
		if (buf[14] != 'N') {
			vp->val[DES] = merge(buf[9], nx, ny, TRUE);
			vp->val[EFF] = atoi(&buf[16]);
			sscanf(&buf[21], "%hd%hd%hd%hd%hd%hd%hd",
			       &vp->val[CIV], &vp->val[MIL], &vp->val[SH],
			       &vp->val[GUN], &vp->val[IRON], &vp->val[PET],
			       &vp->val[FOOD]);
		}
		vp->val[CHKPT] = ' ';
		for (i = 0; i < DELSIZE; i++)
			vp->del[i] = '.';
		for (i = 0; i < DISTSIZE; i++)
			vp->dist[i] = '.';
	}
}
