
/* misc.c - miscellaneous routines */

/*
 * $Log:	misc.c,v $
 * Revision 1.5  89/02/25  04:44:26  muir
 * Added uprintf in place of bogus code.
 * 
 * Revision 1.4  89/02/22  20:02:44  muir
 * indent and lint processed
 * 
 * Revision 1.3  88/08/15  19:18:22  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/misc.c,v 1.5 89/02/25 04:44:26 muir Exp $";
#endif

# include "ve.h"
#ifdef hpux
# include <sys/types.h>
#endif
# include <sys/file.h>

skipword(fp)
	FILE   *fp;
{
	register int c;

	for (;;) {
		c = getc(fp);
		if (c == '\n' || c == ' ' || c == '\t')
			return (1);
		if (c == EOF)
			return (0);
	}
}


pitchline(fp)
	FILE   *fp;
{
	register int c;

	while ((c = getc(fp)) != '\n')
		if (c == EOF)
			break;

}
/*
 * findchar - Find next non-blank character.
 */
char   *
findchar(addr)
	char   *addr;
{
	while ((*addr != 0) && (*addr == ' '))
		addr++;
	return (addr);
}
/*
 * findblank - Find next blank character.
 */
char   *
findblank(addr)
	register char *addr;
{
	while ((*addr != 0) && (*addr != ' '))
		addr++;
	return (addr);
}					    /* findblank */

char   *
strdup(s)
	char   *s;
{
	extern char *malloc();
	extern char *strcpy();
	auto char *p;

	if ((p = malloc((unsigned) strlen(s) + 1)) == (char *) 0)
		error(1, "Out of memmory in strdup <%d bytes needed>");
	return strcpy(p, s);
}

void printAtBot(str)
     char *str;
{
	move(LINES - 1, 0);
	addstr(str);
	clrtoeol();
}

extern char *invo_name;
/*VARARGS2*/
void
error(va_alist)
	va_dcl
{
	va_list ap;
	char *fmt, buf[ 1024 ];
	int type;

	extern int errno;
	extern int sys_nerr;
	extern char *sys_errlist[];

	va_start(ap);
	type = va_arg(ap, int);
	fmt = va_arg(ap, char *);
	(void)uprintf(buf, fmt, &ap);
	va_end(ap);
	if (incurses) {
		printAtBot(buf);
		if (type)
			exit(type);
		return;
	}
	fprintf(stderr, "%s: %s", invo_name, buf);
	if (errno > 0 && errno < sys_nerr)
		fprintf(stderr, "[%s]\n", sys_errlist[errno]);
	else
		putc('\n', stderr);
	if (type)
		exit(type);
}
