

/* dump.c - dump all ve knows about world routines */

/*
 * $Header: /usr6/postgres/muir/empire/client/ve/RCS/dump.c,v 1.10 89/02/25 06:04:44 muir Exp $
 *
 * $Log:	dump.c,v $
 * Revision 1.10  89/02/25  06:04:44  muir
 * Update to work with new census format (again)
 * 
 * Revision 1.9  89/02/25  04:44:11  muir
 * Added uprintf in place of bogus code
 * 
 * Revision 1.8  89/02/22  20:00:59  muir
 * indent and lint processed
 * modified so .cen file could be read back in.
 * 
 * Revision 1.7  88/11/21  19:07:24  muir
 * after rynes patch 01
 * (cargo command)
 *
 * Revision 1.6  88/08/15  19:18:08  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/dump.c,v 1.10 89/02/25 06:04:44 muir Exp $";
#endif

# include	"ve.h"
# include	<sys/types.h>

void    prdate();
void    revert();
char   *splur();
/*
 *	dump - will dump out all the information about the known world
 *	into three files .com, .cen, .map. These files should look as
 *	much like empire report files as possible
 */

FILE   *oldfp;
FILE   *curfp = stdout;

dump()
{
	extern void dump_status();

	if (divert(censusfile)) {
		dump_status("Dumping census to %s...", censusfile);
		cens();
		revert();
	}
	if (divert(commodityfile)) {
		dump_status("Dumping commodities to %s...", commodityfile);
		comm();
		revert();
	}
	if (divert(mapfile)) {
		dump_status("Dumping map to %s...", mapfile);
		do_map();
		revert();
	}
	dump_status("...done");
}

/*VARARGS1*/
void
dump_status(va_alist)
	va_dcl
{
	va_list ap;
	char *fmt, buf[ 1024 ];

	va_start(ap);
	fmt = va_arg(ap, char *);
	(void)uprintf(buf, fmt, &ap);
	va_end(ap);
	printAtBot(buf);
	refresh();
}

int
divert(name)
	char   *name;
{
	FILE   *fopen();

	oldfp = curfp;

	if ((curfp = fopen(name, "w")) == NULL) {
		putline("Cannot open %s", name);
		revert();
		return (FALSE);
	}
	return (TRUE);
}

void
revert()
{
	(void) fclose(curfp);
	curfp = oldfp;
}
map_rel(x)
	int     x;
{
	return (x - (MAPSIZE / 2));
}
cens()
{

	Sector *this_sector;
	Value  *sector_values;
	short  *theitems;
	int     i, j;
	int     nsect;

	fprintf(curfp, "cen according to ve\n");

	prdate();

	nsect = 0;
	for (i = 0; i < MAPSIZE; i++)
		for (j = 0; j < MAPSIZE; j++) {
			if ((this_sector = map[j][i]) == NULL)
				/*
				 * we know nothing about
				 * sector
				 */
				continue;
			sector_values = this_sector->vp;
			if (sector_values == NULL)
				continue;
			if (nsect++ == 0) {
				fprintf(curfp, "CENSUS              del dst\n");
				fprintf(curfp, "  sect      eff mob uf uf *  civ  mil   uw food min gold fert oil uran work ter\n");
	  }
			theitems = sector_values->val;
			fprintf(curfp, "%3d,%-3d", map_rel(j), map_rel(i));
			fprintf(curfp, " %c", this_sector->des);
			if (this_sector->own != 1) {
				if (sector_values->val[COU] >= 0 &&
				    sector_values->val[COU] < 26)
					fprintf(curfp, "%c", sector_values->val[COU] + 'A');
				else
					fprintf(curfp, "A");
			} else
				fprintf(curfp, "%c", this_sector->sdes);
			fprintf(curfp, "%4d%%", theitems[EFF]);
			fprintf(curfp, "%4d", theitems[MOB]);
			fprintf(curfp, " %c", sector_values->del[UW]);
			fprintf(curfp, "%c", sector_values->del[FOOD]);
			fprintf(curfp, " %c", sector_values->dist[UW]);
			fprintf(curfp, "%c ", sector_values->dist[FOOD]);
			fprintf(curfp, "%c", theitems[CHKPT]);
			fprintf(curfp, "%5d", theitems[CIV]);
			fprintf(curfp, "%5d", theitems[MIL]);
			fprintf(curfp, "%5d", theitems[UW]);
			fprintf(curfp, "%5d", theitems[FOOD]);
			fprintf(curfp, "%4d", theitems[MIN]);
			fprintf(curfp, "%5d", theitems[GOLD]);
			fprintf(curfp, "%5d", theitems[FERT]);
			fprintf(curfp, "%4d", theitems[OIL]);
			fprintf(curfp, "%5d", theitems[URAN]);
			fprintf(curfp, "%4d%%", theitems[WORK]);
			fprintf(curfp, "%4d%\n", theitems[TERR]);
		}
	fprintf(curfp, "    %d sector%s\n", nsect, splur(nsect));
	return;
}
comm()
{
	Sector *this_sector;
	Value  *sector_values;
	short  *theitems;
	char   *dels;
	char   *dists;
	int     i, j;
	int     nsect;

	fprintf(curfp, "%s\n", "com according to ve");

	prdate();

	nsect = 0;
	for (i = 0; i < MAPSIZE; i++)
		for (j = 0; j < MAPSIZE; j++) {
			if ((this_sector = map[j][i]) == NULL)
				/*
				 * we know nothing about
				 * this sector
				 */
				continue;
			sector_values = this_sector->vp;
			if (sector_values == NULL)
				continue;
			if (nsect++ == 0) {
				fprintf(curfp, "COMMODITIES deliver-- distribute\n");
				fprintf(curfp, " sect     sgpidbclhr sgpidbclhr  sh  gun  pet iron dust  bar  cru  lcm  hcm rad\n");
			}
			theitems = sector_values->val;
			dels = sector_values->del;
			dists = sector_values->dist;
			fprintf(curfp, "%3d,%-3d", map_rel(j), map_rel(i));
			fprintf(curfp, " %c", this_sector->des);
			fprintf(curfp, " %c", dels[SH]);
			fprintf(curfp, "%c", dels[GUN]);
			fprintf(curfp, "%c", dels[PET]);
			fprintf(curfp, "%c", dels[IRON]);
			fprintf(curfp, "%c", dels[DUST]);
			fprintf(curfp, "%c", dels[BAR]);
			fprintf(curfp, "%c", dels[CRU]);
			fprintf(curfp, "%c", dels[LCM]);
			fprintf(curfp, "%c", dels[HCM]);
			fprintf(curfp, "%c", dels[RAD]);
			fprintf(curfp, " %c", dists[SH]);
			fprintf(curfp, "%c", dists[GUN]);
			fprintf(curfp, "%c", dists[PET]);
			fprintf(curfp, "%c", dists[IRON]);
			fprintf(curfp, "%c", dists[DUST]);
			fprintf(curfp, "%c", dists[BAR]);
			fprintf(curfp, "%c", dists[CRU]);
			fprintf(curfp, "%c", dists[LCM]);
			fprintf(curfp, "%c", dists[HCM]);
			fprintf(curfp, "%c", dists[RAD]);
			fprintf(curfp, "%4d", theitems[SH]);
			fprintf(curfp, "%5d", theitems[GUN]);
			fprintf(curfp, "%5d", theitems[PET]);
			fprintf(curfp, "%5d", theitems[IRON]);
			fprintf(curfp, "%5d", theitems[DUST]);
			fprintf(curfp, "%5d", theitems[BAR]);
			fprintf(curfp, "%5d", theitems[CRU]);
			fprintf(curfp, "%5d", theitems[LCM]);
			fprintf(curfp, "%5d", theitems[HCM]);
			fprintf(curfp, "%4d", theitems[RAD]);
			putc('\n', curfp);
		}
	fprintf(curfp, "    %d sector%s\n", nsect, splur(nsect));
	return;
}
do_map()
{
	int     cur_x, cur_y, x;
	Sector *this_sector;
	char    des;

	fprintf(curfp, "%s\n", "map according to ve");

	border(map_rel(min_x), map_rel(max_x) + 1, 1, "    ", "");

	for (cur_y = min_y; cur_y <= max_y; cur_y++) {
		fprintf(curfp, "%3d ", map_rel(cur_y));
		if (cur_y % 2) {
			if (min_x % 2)
				x = min_x;
			else {
				x = min_x + 1;
				putc(' ', curfp);
			}
		} else {
			if (min_x % 2) {
				x = min_x + 1;
				putc(' ', curfp);
			} else
				x = min_x;
		}

		for (cur_x = x; cur_x <= max_x; cur_x += 2) {
			if ((this_sector = map[cur_x][cur_y]) == NULL)
				des = ' ';
			else
				des = this_sector->des;
			fprintf(curfp, "%c ", des);
		}
		if (((cur_y % 2) && !(max_x % 2)) || (!(cur_y % 2) && (max_x % 2)))
			fprintf(curfp, " ");
		fprintf(curfp, "%-3d\n", map_rel(cur_y));
	}
	border(map_rel(min_x), map_rel(max_x) + 1, 1, "    ", "");

}
border(xmin, xmax, inc, indent, sep)
	int     xmin;
	int     xmax;
	int     inc;
	char   *indent;
	char   *sep;
{
	register int r11;
	register int r10;

	if (xmin < -99 || xmin > 99 || xmax < -99 || xmax > 99) {
		/*
		 * hundreds
		 */
		fprintf(curfp, "%s", indent);
		for (r11 = xmin; r11 != xmax; r11 += inc) {
			fprintf(curfp, "%s", sep);
			if (r11 < 0 && r11 > -100) {
				putc('-', curfp);
				continue;
			}
			r10 = (r11 < 0 ? -r11 : r11) / 100;
			fprintf(curfp, "%d", r10 % 10);
		}
		putc('\n', curfp);
	}
	/*
	 * tens
	 */
	fprintf(curfp, "%s", indent);
	for (r11 = xmin; r11 != xmax; r11 += inc) {
		fprintf(curfp, "%s", sep);
		if (r11 < 0 && r11 > -10) {
			putc('-', curfp);
			continue;
		}
		r10 = (r11 < 0 ? -r11 : r11) / 10;
		fprintf(curfp, "%d", r10 % 10);
	}
	putc('\n', curfp);
	fprintf(curfp, "%s", indent);
	for (r11 = xmin; r11 != xmax; r11 += inc) {
		r10 = (r11 < 0 ? -r11 : r11);
		fprintf(curfp, "%s%d", sep, r10 % 10);
	}
	putc('\n', curfp);
}



char   *
splur(n)
	int     n;
{
	return (n == 1 ? "" : "s");
}

void
prdate()
{
	long    now, time();
	extern char *ctime();

	(void) time(&now);
	fprintf(curfp, "%s", ctime(&now));
}
