
/* commodity.c - commodity parsing etc. */

/*
 * $Log:	commodity.c,v $
 * Revision 1.6  89/02/22  20:00:48  muir
 * indent and lint processed
 * 
 * Revision 1.5  88/11/21  19:07:18  muir
 * after rynes patch 01
 * (cargo command)
 *
 * Revision 1.4  88/08/15  19:18:03  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/commodity.c,v 1.6 89/02/22 20:00:48 muir Exp $";
#endif

# include	"ve.h"

/*
 * commodities - Read and process commodities file.
 */
commodities(fp)
	FILE   *fp;
{
	register int x, y;
	register char *p;
	Sector *mp;
	Value  *vp;
	char    buf[BUFSIZ];

	while (fgets(buf, sizeof buf, fp) != NULL) {
		if (buf[3] != ',') {
			/*
			 * Look for census lines of the
			 * form: 'xxxxx yyy zzz in x,y'
			 * (reports of products produced)
			 */
			if (p = rindex(buf, ',')) {
				if (*++p == '-')
					p++;
				if (noise && *p >= '0' && *p <= '9') {
					fputs(buf, stdout);
					(void) fflush(stdout);
				}
			}
			continue;
		}
		x = xoffset(atoi(buf));
		y = yoffset(atoi(&buf[4]));
		maxxy(x, y);
		mp = map[x][y];
		if (mp == NULL)
			map[x][y] = mp = newmap();
		if (mp->vp == NULL)
			mp->vp = newval();
		vp = mp->vp;
		if (mp->own == 0)
			mp->own = 1;
		vp->val[DES] = merge(buf[8], x, y, TRUE);
		sscanf(&buf[10], "%c%c%c%c%c%c%c%c%c%c",
		       &vp->del[SH], &vp->del[GUN], &vp->del[PET],
		       &vp->del[IRON], &vp->del[DUST], &vp->del[BAR],
		       &vp->del[CRU], &vp->del[LCM], &vp->del[HCM],
		       &vp->del[RAD]);
		sscanf(&buf[21], "%c%c%c%c%c%c%c%c%c%c",
		       &vp->dist[SH], &vp->dist[GUN], &vp->dist[PET],
		       &vp->dist[IRON], &vp->dist[DUST], &vp->dist[BAR],
		       &vp->dist[CRU], &vp->dist[LCM], &vp->dist[HCM],
		       &vp->dist[RAD]);
		sscanf(&buf[32], "%hd%hd%hd%hd%hd%hd%hd%hd%hd%hd",
		       &vp->val[SH], &vp->val[GUN], &vp->val[PET],
		       &vp->val[IRON], &vp->val[DUST], &vp->val[BAR],
		       &vp->val[CRU], &vp->val[LCM], &vp->val[HCM],
		       &vp->val[RAD]);
	}
}
