
# 
# this awk script will print out flight paths to all of the locations
# listed ("x y") given some data on an init line ("'init' plane x y path")
#

BEGIN {
	FS = ","
    }

$1=="init"	{
	pln = $2
	whrx = $3
	whry = $4
	path = $5
	next
}

{
	x = $1
	y = $2
	print "fly " pln " air " whrx "," whry " " path
	curx = 0
	cury = 0
	i = 0
	while (curx != x || cury != y) {
		i++
		if (curx < x && cury == y) {
			curx += 2
			printf "j"
		}
		if (curx <= x && cury < y) {
			curx += 1
			cury += 1
			printf "n"
		}
		if (curx > x && cury < y) {
			curx -= 1
			cury += 1
			printf "b"
		}
		if (curx > x && cury == y) {
			curx -= 2
			printf "g"
		}
		if (curx > x && cury > y) {
			curx -= 1
			cury -= 1
			printf "y"
		}
		if (curx <= x && cury > y) {
			curx += 1
			cury -= 1
			printf "u"
		}
		if (i > 10) {
			i = 0
			print ""
		}
	}
	print "h"
}



