#ifndef lint
static char	rcsid[] = "$Header: var.c,v 1.2 88/08/23 18:34:17 muir Exp $";
#endif lint

#include <sys/types.h>
#include <curses.h>
#include <ctype.h>
#include "sect.h"
#include "var.h"
#include "nsc.h"
#include "item.h"
#include "menu.h"
#include "wio.h"

#define VAR_STRLEN	80

u_char		*var_vtype;
short		*var_vamt;
int		*var_nv;

extern struct castr		ca[];

extern int	sect_save();

static char			unknown[] = "????";
static char			empty[] = "empty";
static char			delivery[] = "delivery";
static char			distribute[] = "distribute";
static struct menu		*var_menu;
static struct menu_control	var_control = {
	0,	0,	0,	sect_save
};

var_display(wp, index, junk)
	WINDOW		*wp;
	int		index;
	char		*junk;
{
	char		*deldis, *var_deldis();

	if ((deldis = var_deldis((int)var_vtype[index])) == NULL)
		wprintw(wp, "%-4d", (int)var_vamt[index]);
	else
		wprintw(wp, "%-4d (%s)", (int)var_vamt[index], deldis);
}

/*
 * Yanked from empfix.c ... modified a little ...
 *
 * Why the hell arent V_MINE, V_CHKPT, et. al. in some structure somewhere?
 * It is a very uncool to have to switch on them explicitly ...
 */
char   *
var_ttos(var_num)
	int     var_num;
{
	extern	char *copy();
	extern	struct ichrstr ichr[];
	static	char buf[32];
	char	*bp;
	int	n;

	if (var_num <= 0 || var_num > 255)
		return (unknown);

	if (iscond(var_num)) {
		switch (var_num) {
		case V_MINE:
			return ("mine");
		case V_CHKPT:
			return ("checkpoint");
		case V_PSTAGE:
			return ("plague stage");
		case V_PTIME:
			return ("plague time");
		case V_RAD:
			return ("radiation");
		case V_FALL:
			return ("fallout");
		default:
			return (unknown);
		}
	}

	return (ichr[var_num & ~VT_TYPE].i_name);
}

char	*
var_deldis(var_num)
	int	var_num;
{

	if (isdel(var_num))
		return (delivery);
	else if (isdist(var_num))
		return (distribute);

	return ((char *)0);
}

var_match(sp)
	char	*sp;
{
	extern struct ichrstr	ichr[];
	extern int		maxitem;
	int			i;

	for (i = 0; i < maxitem; i++)
		if (*sp == ichr[i & ~VT_TYPE].i_mnem)
			return (i);

	return (-1);
}

var_edit(wp, index, junk)
	WINDOW		*wp;
	int		index;
	char		*junk;
{
	char		*answer, *menu_query();
	int		ntype;

	answer = menu_query("New type/amount: ");

	if (isdigit(*answer)) {
		var_vamt[index] = atoi(answer);
		if (var_vamt[index] == 0) {
			var_vtype[index] = 0;
			var_sort();
			var_makemenu(var_vtype, var_vamt, var_nv);
		}
	} else {
		if ((ntype = var_match(answer)) < 0)
			return;
		var_vtype[index] = ntype;
		var_sort();
		var_makemenu(var_vtype, var_vamt, var_nv);
	}
}

var_makemenu(vtype, vamt, n)
	u_char		*vtype;
	short		*vamt;
	int		*n;
{
	int		i;

	for (i = 0; i < *var_nv; i++) {
		if (vtype[i])
			var_menu[i].menu_field = var_ttos(var_vtype[i]);
		else
			var_menu[i].menu_field = empty;
		var_menu[i].menu_display = var_display;
		var_menu[i].menu_edit = var_edit;
		var_menu[i].menu_exec = 0;
		var_menu[i].menu_dargs[0] = (char *)i;
	}
}

vfix_var(vtype, vamt, n)
	u_char		*vtype;
	short		*vamt;
	int		*n;
{

	var_vtype = vtype;
	var_vamt = vamt;
	var_nv = n;

	if ((var_menu = (struct menu *)malloc(sizeof(struct menu) * *n))
	    == NULL)
		panic("malloc(%d): %m\n", sizeof(struct menu) * *n);
	bzero(var_menu, sizeof(struct menu) * *n);

	var_makemenu(vtype, vamt, n);

	menu(&var_control, var_menu, *n);

	free (var_menu);
}

struct varsort {
	u_char	vs_type;
	short	vs_amt;
};

var_compar(ap, bp)
	struct varsort	*ap;
	struct varsort	*bp;
{
	if (ap->vs_type == 0)
		return (1);
	if (bp->vs_type == 0)
		return (-1);

	return (ap->vs_type - bp->vs_type);
}

var_sort()
{
	int		i;
	int		nv;
	struct varsort	vs[MAXSCTV];
	
	for (nv = i = 0; i < MAXSCTV; i++) {
		vs[i].vs_type = var_vtype[i];		
		vs[i].vs_amt = var_vamt[i];		
		nv++;
	}

	qsort(vs, MAXSCTV, sizeof(struct varsort), var_compar);

	bzero(var_vtype, sizeof(u_char) * MAXSCTV);
	bzero(var_vamt, sizeof(short) * MAXSCTV);

	for (i = 0; i < MAXSCTV; i++) {
		var_vtype[i] = vs[i].vs_type;
		var_vamt[i] = vs[i].vs_amt;
	}

	*var_nv = nv;
}
