#ifndef lint
static char	rcsid[] = "$Header: sect.c,v 1.1 88/12/16 19:57:22 muir Locked $";
#endif lint

#include <sys/types.h>
#include "var.h"
#include "sect.h"
#include "menu.h"
#include "wio.h"
#include "swio.h"

extern int			vfix_var();
extern int			sect_save(), sect_goto();

static int			nv = MAXSCTV;
static int			sect_n;
static struct sctstr		sect;
static struct menu_control	sect_control = {
	sect_goto,	0,	0,	sect_save
};
static struct menu		sect_menu[] = {
	{ "Location",	  wio_pci2, 0,	     0, &sect.sct_x, &sect.sct_y },
	{ "Owner",	  swio_pown,  wio_sci, 0,	&sect.sct_own },
	{ "Old Owner",	  wio_pci,  wio_sci, 0,	&sect.sct_oldown },
	{ "Type",	  swio_psecttype,  wio_sci, 0,	&sect.sct_type },
	{ "Efficiency",	  wio_pci,  wio_sci, 0,	&sect.sct_effic },
	{ "Mobility",	  wio_pci,  wio_sci, 0,	&sect.sct_mobil },
	{ "Work",	  wio_pci,  wio_sci, 0,	&sect.sct_work },
	{ "Loyalty",	  wio_pci,  wio_sci, 0,	&sect.sct_loyal },
	{ "Distribution", wio_pli,  wio_sli, 0,	(char *)&sect.sct_distpath },
	{ "Mineral Ore",  wio_pci,  wio_sci, 0,	&sect.sct_min },
	{ "Gold Ore",	  wio_pci,  wio_sci, 0,	&sect.sct_gmin },
	{ "Fertility",	  wio_pci,  wio_sci, 0,	&sect.sct_fertil },
	{ "Oil Content",  wio_pci,  wio_sci, 0,	&sect.sct_oil },
	{ "Uranium",	  wio_pci,  wio_sci, 0,	&sect.sct_uran },
	{ "Contents",	  0,0,vfix_var,0,0,(char *)sect.sct_vtype,
			  (char *)sect.sct_vamt, (char *)&nv }
};

vfix_sect(x, y)
	int	x, y;
{

	sect_n = sect_xy2n(x, y);

	sect_load();

	menu(&sect_control, sect_menu, sizeof(sect_menu) / sizeof(struct menu));
}

sect_goto()
{
	char	*answer, *menu_query();
	int	new_x, new_y, new_n;

	answer = menu_query("Go to which sector? ");

	if (sscanf(answer, "%d,%d", &new_x, &new_y) == 2) {
		new_n = sect_xy2n(new_x, new_y);
		if (new_n < 0) {
			free (answer);
			return;
		}
		sect_n = new_n;
		sect_load(sect_n);
	}

	free (answer);
}

sect_save()
{

	fio_sectput(sect_n, &sect);
}

static
sect_load()
{
	
	if (fio_sectget(sect_n, &sect) == 0)
		bzero(&sect, sizeof(sect));
}

sect_xy2n(x, y)
	int	x;
	int	y;
{
	extern int	w_xsize, w_ysize;


	while (y < 0)
		y += w_ysize;
	while (y >= w_ysize)
		y -= w_ysize;

	while (x < 0)
		x += w_xsize;
	while (x >= w_xsize)
		x -= w_xsize;

	if (((x + y) % 1) != 0)
		return -1;

	return ((y * (w_xsize / 2)) + (x / 2));
}
