#ifndef lint
static char	rcsid[] = "$Header: nuke.c,v 1.1 88/12/16 19:57:16 muir Locked $";
#endif lint

#include "nuke.h"
#include "menu.h"
#include "wio.h"
#include "swio.h"

extern int			nuke_next(), nuke_prev(), nuke_save();

static int			nuke_n = 0;
static struct nukstr		nuke;
static struct menu_control	nuke_control = {
	0,	nuke_next,	nuke_prev,	nuke_save
};
static struct menu		nuke_menu[] = {
	{ "Index",	wio_pii,0,0,	  	(char *)&nuke_n },
	{ "Location",	wio_pci2,wio_sci2,0,	&nuke.nuk_x, &nuke.nuk_y },
	{ "Owner",	swio_pown,wio_sci,0,	&nuke.nuk_own },
	{ "N",		wio_pci,wio_sci,0,	&nuke.nuk_n },
	{ "Id",		wio_psi,wio_ssi,0,	(char *)&nuke.nuk_uid },
	{ "Fscode",	wio_psi,wio_ssi,0,	(char *)&nuke.nuk_fscode },
	{ "Ship",	wio_psi,wio_ssi,0,	(char *)&nuke.nuk_ship },
	{ "Type [0]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[0] },
	{ "Type [1]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[1] },
	{ "Type [2]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[2] },
	{ "Type [3]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[3] },
	{ "Type [4]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[4] },
	{ "Type [5]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[5] },
	{ "Type [6]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[6] },
	{ "Type [7]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[7] },
	{ "Type [8]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[8] },
	{ "Type [9]",	swio_pnt,wio_sci,0,	&nuke.nuk_types[9] },
};

vfix_nuke()
{

	nuke_load(nuke_n);

	menu(&nuke_control, nuke_menu, sizeof(nuke_menu) / sizeof(struct menu));
}

nuke_load(n)
	int	n;
{
	
	if (fio_nukeget(n, &nuke) == 0)
		bzero(&nuke, sizeof(nuke));
}

nuke_next()
{

	nuke_n += 1;
	nuke_load(nuke_n);
}

nuke_prev()
{

	nuke_n -= 1;
	if (nuke_n < 0)
		nuke_n = 0;
	nuke_load(nuke_n);
}

nuke_save()
{

	fio_nukeput(nuke_n, &nuke);
}
