#ifndef lint
static char	rcsid[] = "$Header: nat.c,v 1.1 88/12/16 19:57:13 muir Locked $";
#endif lint

#include <ctype.h>
#include "misc.h"
#include "nat.h"
#include "menu.h"
#include "wio.h"

#ifndef NULL
#define NULL	0
#endif NULL

extern int	maxcno, maxnoc;
extern int	nat_goto(), nat_next(), nat_prev(), nat_save();

static int			nat_n = 0;
static struct natstr		nat;
static struct menu_control	nat_control = {
	nat_goto,	nat_next,	nat_prev,	nat_save
};
static struct menu		nat_menu[] = {
	{ "Number",	wio_pii, 0,	  0, (char *)&nat_n },
	{ "Name",	wio_pstr,wio_sstr,0, nat.nat_cnam },
	{ "Passwd",	wio_pstr,wio_sstr,0, nat.nat_pnam },
	{ "BTU",	wio_psi, wio_ssi, 0, (char *)&nat.nat_btu },
	{ "Reserves",	wio_pli, wio_sli, 0, (char *)&nat.nat_reserve },
	{ "Logged In",	wio_pci, wio_sci, 0, &nat.nat_login },
	{ "Telegrams ",	wio_pci, wio_sci, 0, (char *)&nat.nat_tgms },
	{ "Capital",	wio_pci2,wio_sci2,0, &nat.nat_xcap,&nat.nat_ycap },
	{ "Origin",	wio_pci2,wio_sci2,0, &nat.nat_xorg,&nat.nat_yorg },
	{ "Status",	wio_pci, wio_sci, 0, &nat.nat_stat },
	{ "Day Number",	wio_pci, wio_sci, 0, &nat.nat_dayno },
	{ "Minutes",	wio_psi, wio_ssi, 0, (char *)&nat.nat_minused },
	{ "Loggoff",	wio_pli, wio_sli, 0, (char *)&nat.nat_date },
	{ "Money",	wio_pli, wio_sli, 0, (char *)&nat.nat_money },
	{ "Tech Level",	wio_pff, wio_sff, 0, (char *)&nat.nat_level[NAT_TLEV] },
	{ "Research",	wio_pff, wio_sff, 0, (char *)&nat.nat_level[NAT_RLEV] },
	{ "Education",	wio_pff, wio_sff, 0, (char *)&nat.nat_level[NAT_ELEV] },
	{ "Happiness",	wio_pff, wio_sff, 0, (char *)&nat.nat_level[NAT_HLEV] },
	{ "News",	wio_pli, wio_sli, 0, (char *)&nat.nat_newstim },
};

vfix_nat()
{

	nat_load(nat_n);

	menu(&nat_control, nat_menu, sizeof(nat_menu) / sizeof(struct menu));
}

nat_goto()
{
	char	*answer, *menu_query();
	int	new_n;

	answer = menu_query("Go to which entry? ");

	if (isdigit(*answer)) {
		new_n = atoi(answer);
		if (new_n < 0 || new_n > maxcno) {
			free (answer);
			return;
		}
	} else if ((new_n = nat_match(answer)) < 0) {
		free (answer);
		return;
	}

	nat_n = new_n;
	nat_load(nat_n);

	free (answer);
}

nat_next()
{

	nat_n += 1;
	if (nat_n > maxcno)
		nat_n = maxcno;
	nat_load(nat_n);
}

nat_prev()
{

	nat_n -= 1;
	if (nat_n < 0)
		nat_n = 0;
	nat_load(nat_n);
}

nat_save()
{

	fio_natput(nat_n, &nat);
}

static
nat_load(n)
	int	n;
{
	
	if (fio_natget(n, &nat) == 0)
		bzero(&nat, sizeof(nat));
}

nat_match(sp)
	char		*sp;
{
	struct natstr	*np;
	int		size, i;

	size = sizeof(struct natstr) * maxnoc;

	if ((np = (struct natstr *)malloc(size)) == NULL)
		panic("malloc(%d): %m\n", size);

	fio_natgetall(np, size);

	for (i = 0; i < maxcno; i++)
		if (strcmp(sp, np[i].nat_cnam) == 0) {
			free (np);
			return (i);
		}

	free (np);
	return (-1);
}
