#ifndef lint
static char	rcsid[] = "$Header: menu.c,v 1.1 88/12/16 19:57:11 muir Locked $";
#endif lint

#include "menu.h"
#include <curses.h>

#define MENU_OFFSET		8		/* menu offset (a tab) */
#define MENU_DIST		16		/* between field && data */

extern WINDOW	*w_main;

menu(mcp, mp, n)
	struct menu_control	*mcp;
	struct menu		*mp;
	int			n;
{
	int		curr_y;			/* current curr_y position */
	int		begin_y;		/* beginning curr_y of menu */
	int		end_y;			/* end curr_y of menu */
	int		data_x;			/* beginning col of data */
	int		i, len;
	int		mc;			/* current menu command */

	if (n < LINES) {
		begin_y = (LINES - n) / 2;
		end_y = begin_y + n - 1;
	} else
		panic("menu(0x%x, %d): LINES(%d) too small for menu.\n",
		    mp, n, LINES);

	for (i = 0, data_x = 0; i < n; i++)
		if ((len = strlen(mp[i].menu_field)) > data_x)
			data_x = len;
	data_x += MENU_DIST;

	curr_y = begin_y;
	wclear(w_main);
	wmove(w_main, begin_y, data_x);
	menu_display(mp, n, begin_y, data_x);
	wrefresh(w_main);

	for (;;) {
		mc = curr_y - begin_y;
		switch (getchar()) {
		case 'd':			/* down */
		case 'j':
		case 'J':
			if (curr_y == end_y)
				curr_y = begin_y;
			else
				curr_y++;
			break;
		case 'u':			/* up */
		case 'k':
		case 'K':
			if (curr_y == begin_y)
				curr_y = end_y;
			else
				curr_y--;
			break;
		case 'L':
			curr_y = end_y;
			break;
		case 'H':
			curr_y = begin_y;
			break;
		case 'M':
			curr_y = begin_y + ((end_y - begin_y) / 2);
			break;
		case 'q':			/* quite w/o writing */
		case 'Q':
		case '\033':
			return;
			break;
			break;
		case 'Z':			/* write and quit */
			if (mcp->mc_save)
				mcp->mc_save();
			return;
			break;
		case '\r':			/* execute the command */
			/*
			 * Note that we pass the args using explicit index
			 * numbers, and are thus not using MENU_MAXEARGS.
			 * This is a lose and should be fixed!
			 * XXXX
			 */
			if (mp[mc].menu_exec) {
				(mp[mc].menu_exec)(mp[mc].menu_eargs[0],
				    mp[mc].menu_eargs[1], mp[mc].menu_eargs[2]);
				wclear(w_main);
				menu_display(mp, n, begin_y, data_x);
			}
			break;
		case 'e':			/* edit */
			if (mp[mc].menu_edit) {
				menu_edit(mp, mc);
				menu_display(mp, n, begin_y, data_x);
			}
			break;
		case 'w':			/* write */
		case 'W':
			if (mcp->mc_save)
				mcp->mc_save();
			break;
		case '+':
			if (mcp->mc_next)
				(mcp->mc_next)();
			menu_display(mp, n, begin_y, data_x);
			break;
		case '-':
			if (mcp->mc_prev)
				(mcp->mc_prev)();
			menu_display(mp, n, begin_y, data_x);
			break;
		case 'G':
			if (mcp->mc_goto)
				(mcp->mc_goto)();
			menu_display(mp, n, begin_y, data_x);
			break;
		case CTRL(L):
		case CTRL(R):
			wrefresh(curscr);
			break;
		default:				/* "wrong!" */
			putc('\007', stdout);
			break;
		}

		wmove(w_main, curr_y, data_x);
		wrefresh(w_main);
	}
}

menu_edit(mp, mc)
	struct menu		*mp;
	int			mc;
{
	echo();
	nocrmode();
	nl();

	(mp[mc].menu_edit)(w_main, mp[mc].menu_dargs[0], mp[mc].menu_dargs[1]);

	noecho();
	crmode();
	nonl();
}
	
menu_display(mp, n, begin_y, data_x)
	struct menu	*mp;
	int		n;
	int		begin_y;
	int		data_x;
{
	int		sav_x, sav_y;
	int		i;

	getyx(w_main, sav_y, sav_x);

	wmove(w_main, begin_y, 0);

	for (i = 0; i < n; i++) {
		wprintw(w_main, "\t%s\n", mp[i].menu_field);
		if (mp[i].menu_display) {
			wmove(w_main, begin_y + i, data_x);
			(mp[i].menu_display)(w_main, mp[i].menu_dargs[0],
			    mp[i].menu_dargs[1]);
			wprintw(w_main, "\n");
		}
	}

	wmove(w_main, sav_y, sav_x);
}

char	*
menu_query(sp)
	char	*sp;
{
	int	sav_x, sav_y;
	char	*answer;

	getyx(w_main, sav_y, sav_x);

	wmove(w_main, LINES - 2, (COLS / 2) - strlen(sp));

	wprintw(w_main, sp);

	wrefresh(w_main);

	if ((answer = (char *)malloc(MENU_STRLEN)) == NULL)
		panic("malloc(%d): %m\n", MENU_STRLEN);

	echo();
	nocrmode();
	nl();

	wscanw(w_main, "%s", answer);

	noecho();
	crmode();
	nonl();

	wmove(w_main, LINES - 2, 0);

	wclrtoeol(w_main);

	wmove(w_main, sav_y, sav_x);

	wrefresh(w_main);

	return (answer);
}
