#ifndef lint
static char	rcsid[] = "$Header: curses.c,v 1.1 88/08/09 12:47:40 muir Exp $";
#endif lint

#include <curses.h>
#include <signal.h>

extern WINDOW	*w_main;
extern WINDOW	*w_map;
extern WINDOW	*w_status;
extern int	(*_panicfunc)();

curses_cleanup() 
{
	wclear(curscr);
	wrefresh(curscr);
	nocrmode();
	echo();
	nl();
	endwin();
}

curses_niceexit()
{

	curses_cleanup();
	exit(0);
}

curses_init() 
{

	initscr();
	crmode();
	noecho();
	nonl();

	w_main = newwin(0, 0, 0, 0);

	_panicfunc = curses_niceexit;

	signal(SIGHUP, curses_niceexit);
	signal(SIGINT, curses_niceexit);
}
