static char *RCSid = "$Header: empchk.c,v 1.6 89/04/30 01:18:22 muir Locked $";

/*
 * empchk.c
 *
 * check the newly created world for goodies
 *
 * from PSL Empire, 1985
 */

#include "../gamesdef.h"
#include <stdio.h>
#include "misc.h"
#include "var.h"
#include "sect.h"

struct	sctstr sects[WORLD_Y*WORLD_X/2];
char    s[WORLD_X][WORLD_Y];

main(argc, argp)
	int     argc;
	char  **argp;
{
	extern	char *sectfil;
	extern	int w_xsize, w_ysize;
	extern	struct sctstr sect;
	extern	int diroff[][2];
	register struct sctstr *sp;
	register int y;
	register int x;
	int     sectf;
	int     sectors;
	int     gold[13];
	int     iron[13];
	int     fertil[13];
	int     oil[13];
	int     uran[13];
	double  total_iron;
	double  total_gold;
	double  total_fertil;
	double  total_oil;
	double  total_uran;

	if (argc > 1 && argp[1][0] == '-' && argp[1][1] == 's')
		sectfil = argp[1] + 3;
	for (x = 12; x >= 0; x--)
		gold[x] = iron[x] = fertil[x] = oil[x] = 0;
	sectf = open(sectfil, 0);
	if (sectf < 0) {
		perror(sectfil);
		exit(1);
	}
	sectors = 0;
	total_iron = total_gold = total_fertil = total_oil = total_uran = 0.;
	read(sectf, sects, sizeof(sects));
	sp = sects;
	for (y = 0; y < w_ysize; y++) {
		for (x = 0; x < w_xsize; x++) {
			if (((x ^ y) & 1))
				continue;
			if (sp->sct_type == SCT_WATER) {
				s[x / 2][y] = 2;
			} else if (sp->sct_type == SCT_MOUNT) {
				s[x / 2][y] = 4;
			} else {
				s[x / 2][y] = 8;
				sectors++;
				iron[sp->sct_min / 10]++;
				total_iron += (double) sp->sct_min;
				gold[sp->sct_gmin / 10]++;
				total_gold += (double) sp->sct_gmin;
				fertil[sp->sct_fertil / 10]++;
				total_fertil += (double) sp->sct_fertil;
				oil[sp->sct_oil / 10]++;
				total_oil += (double) sp->sct_oil;
				uran[sp->sct_uran / 10]++;
				total_uran += (double) sp->sct_uran;
			}
			sp++;
		}
	}
	close(sectf);
	printf("    NATURAL RESOURCES\n\n");
	for (x = 12; x >= 0; x--) {
		if (gold[x] != 0)
			printf("%4d with gold mineral assay %2d0 - %2d9\n",
				gold[x], x, x);
	}
	printf("Average gold assay is %.2f\n\n", total_gold / (double) sectors);
	for (x = 12; x >= 0; x--) {
		if (oil[x] != 0)
			printf("%4d with oil content %2d0 - %2d9\n",
				oil[x], x, x);
	}
	printf("Average oil content is %.2f\n\n", total_oil / (double) sectors);
	for (x = 12; x >= 0; x--) {
		if (iron[x] != 0)
			printf("%4d with iron mineral assay %2d0%% - %2d9%%\n",
				iron[x], x, x);
	}
	printf("Average mineral assay is %.2f\n\n",
		total_iron / (double) sectors);
	for (x = 12; x >= 0; x--) {
		if (uran[x] != 0)
			printf("%4d with uranium mineral assay %2d0%% - %2d9%%\n",
				uran[x], x, x);
	}
	printf("Average uranium assay is %.2f\n\n",
		total_uran / (double) sectors);
	for (x = 12; x >= 0; x--) {
		if (fertil[x] != 0)
			printf("%4d with fertility %2d0 - %2d9\n",
				fertil[x], x, x);
	}
	printf("Average fertility is %.2f\n\n",
		total_fertil / (double) sectors);
	printf("    CONNECTEDNESS\n");
	printf("Counting only rural...\n");
	scnt(8);
	printf("Counting rural & mount...\n");
	scnt(12);
}

scnt(flag)
	int     flag;
{
	register int count;
	register int y;
	register int x;
	int     masses[128];

	x = 128;
	while (--x >= 0) {
		masses[x] = 0;
	}
	y = w_ysize;
	while (--y >= 0) {
		x = w_xsize;
		while (--x >= 0) {
			if (((x ^ y) & 1) == 0)
				s[x / 2][y] |= 1;
		}
	}
	y = w_ysize;
	while (--y >= 0) {
		x = w_xsize;
		while (--x >= 0) {
			if (((x ^ y) & 1) == 0 && (s[x / 2][y] & 0x1) != 0 &&
			    (s[x / 2][y] & flag) != 0) {
				count = neighbors(x, y, flag);
				if (count < 128)
					masses[count]++;
				else
					printf("One with %4d sectors\n", count);
			}
		}
	}
	x = 128;
	while (--x >= 0) {
		if (masses[x] == 1)
			printf("One with %4d sector(s)\n", x);
		else if (masses[x] > 1)
			printf("%3d with %4d sector(s)\n", masses[x], x);
	}
}

int
neighbors(this_x, this_y, flag)
	int     this_x;
	int     this_y;
	int     flag;
{
	register int count;
	register int y;
	register int x;
	register int direction;

	s[this_x / 2][this_y] &= ~1;
	count = 1;
	for (direction = 1; direction <= 6; direction++) {
		x = (diroff[direction][0] + this_x + w_xsize) % w_xsize;
		y = (diroff[direction][1] + this_y + w_ysize) % w_ysize;
		if ((s[x / 2][y] & 0x1) != 0 && (s[x / 2][y] & flag) != 0)
			count += neighbors(x, y, flag);
	}
	return count;
}
