#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/tend.c,v 1.6 89/07/12 01:55:34 jeffw Exp $";
#endif

/*
 * tend.c
 *
 * transfer from one ship to another
 * Hacked to provide a bulk-rate tend ability.
 * which doesn't prompt for each commodity transferred to
 * each ship.
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "file.h"
#include "ship.h"
#include "item.h"
#include "nsc.h"
#include "nat.h"


static	expose_ship();

int
tend()
{
	extern	char *argp[];
	struct	nstr_item	targets;
	struct	nstr_item	tenders;
	struct	shpstr	tender;
	struct	shpstr	target;
	struct	ichrstr	*ip;
	struct	mchrstr	*vbase;
	int     amt;
	int     ontender;
	int     ontarget;
	int     maxtender;
	int     maxtarget;
	int     transfer;
	int     total;
	char	*p;

	if (!snxtitem(&tenders, EF_SHIP, getstarg(argp[1], "Tender(s)? ")))
		return RET_SYN;
	while (nxtitem(&tenders, (char *)&tender)) {
		if (!owner)
			continue;
		if ((ip = whatitem(argp[2], "Transfer what item? ")) == 0)
			break;
		if ((p = getstarg(argp[3], "Amount to transfer? ")) == 0)
			break;
		if ((amt = atoi(p)) == 0)
			break;
		ontender = getvar(ip->i_vtype, (char *)&tender, EF_SHIP);
		if (ontender == 0 && amt > 0) {
			pr(fmt("No %s on ship #%d\n", ip->i_name, tenders.cur));
			return RET_FAIL;
		}
		vbase = &mchr[tender.shp_type];
		maxtender = vl_find(ip->i_vtype, vbase->m_vtype,
			vbase->m_vamt, (int)vbase->m_nv);
		if (maxtender == 0) {
			pr(fmt("A %s cannot hold any %s\n",
			       mchr[tender.shp_type].m_name,
			       ip->i_name));
			break;
		}
		if (!snxtitem(&targets, EF_SHIP,
		    getstarg(argp[4], "Ships to be tended? ")))
			break;
		total = 0;
		while (nxtitem(&targets, (char *)&target)) {
			if (!owner)
				continue;
			if (target.shp_uid == tender.shp_uid)
				continue;
			if (tender.shp_x != target.shp_x ||
			    tender.shp_y != target.shp_y)
				continue;
			ontarget = getvar(ip->i_vtype,
				(char *)&target, EF_SHIP);
			if (ontarget == 0 && amt < 0) {
				pr(fmt("No %s on ship %d\n",
					ip->i_name, target.shp_uid));
				continue;
			}
			vbase = &mchr[target.shp_type];
			maxtarget = vl_find(ip->i_vtype, vbase->m_vtype,
				vbase->m_vamt, (int)vbase->m_nv);
			if (amt < 0) {
				/* take from target and give to tender */
				transfer = min(ontarget, -amt);
				transfer = min(maxtender - ontender, transfer);
				if (transfer == 0)
					continue;
				putvar(ip->i_vtype, ontarget - transfer,
					(char *)&target, EF_SHIP);
				ontender += transfer;
				total += transfer;
			} else {
				/* give to target from tender */
				transfer = min(ontender, amt);
				transfer = min(transfer, maxtarget - ontarget);
				if (transfer == 0)
					continue;
				putvar(ip->i_vtype, ontarget + transfer,
					(char *)&target, EF_SHIP);
				ontender -= transfer;
				total += transfer;
			}
			expose_ship(&tender, &target);
			putship(targets.cur, &target);
			if (amt > 0 && ontender == 0) {
				pr(fmt("%s #%d out of %s\n",
				       mchr[tender.shp_type].m_name,
				       tenders.cur, ip->i_name));
				break;
			}
		}
		pr(fmt("%d total %s transferred %s ship %d\n",
			total, ip->i_name, (amt > 0) ? "off of" : "to",
			tenders.cur));
		putvar(ip->i_vtype, ontender, (char *)&tender, EF_SHIP);
		putship(tender.shp_uid, &tender);
	}
	return RET_OK;
}

static
expose_ship(s1, s2)
	struct	shpstr *s1;
	struct	shpstr *s2;
{
	if (getvar(V_PSTAGE, (char *)s1, EF_SHIP) == PLG_INFECT &&
	    getvar(V_PSTAGE, (char *)s2, EF_SHIP) == PLG_HEALTHY)
		putvar(V_PSTAGE, PLG_EXPOSED, (char *)s2, EF_SHIP);
	if (getvar(V_PSTAGE, (char *)s2, EF_SHIP) == PLG_INFECT &&
	    getvar(V_PSTAGE, (char *)s1, EF_SHIP) == PLG_HEALTHY)
		putvar(V_PSTAGE, PLG_EXPOSED, (char *)s1, EF_SHIP);
}
