#ifndef lint
static char *RCSid = "$Header: diss.c,v 1.10 90/03/19 10:58:57 mr-frog Exp $";
#endif /* not lint */

/*
 * diss.c
 *
 * perhaps the least-used command in empire!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "loan.h"
#include "treaty.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "tel.h"
#include "nuke.h"
#include "trade.h"

diss()
{
	extern	char *argp[];
	struct	sctstr sect;
	struct	shpstr ship;
	struct	plnstr plane;
	struct	trtstr treaty;
	struct	trdstr trade;
	struct	lonstr loan;
	struct	nstr_item ni;
	struct	nstr_sect ns;
	int	sctnum;
	int	damage;
	int	annoyed;
	int	n;
	char	*p;
	natid	cn;
	float	dummy;
	int	val;

	p = getstarg(argp[1], "Are you SURE you want to do this? (n) ");
	if (p == 0 || *p != 'y')
		return RET_SYN;
	NAT_SET(nat_stat, cnum, VIS);
	snxtsct_all(&ns);
	sctnum = 0;
	while (nxtsct(&ns, &sect)) {
		if (!owner)
			continue;
		annoyed = 75 - (random() % (sect.sct_loyal+40));
		if (annoyed <= 0 || sect.sct_oldown != sect.sct_own) {
			pr(fmt("Populace celebrates in %s\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			if (sect.sct_oldown != sect.sct_own) {
				sect.sct_own = sect.sct_oldown;
				wu(0, sect.sct_own,
					fmt("%s reverts back to you!\n",
					xyas(sect.sct_x, sect.sct_y,
					sect.sct_own)));
			}
		} else if (annoyed < 25) {
			pr(fmt("Populace unmoved in %s\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			sect.sct_own = 0;
			sect.sct_oldown = 0;
		} else {
			pr(fmt("Rioting breaks out in %s\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			sectdamage(&sect, annoyed);
			sctnum++;
			sect.sct_own = 0;
			sect.sct_oldown = 0;
		}
		putsect(&sect);
	}
	snxtitem_all(&ni, EF_SHIP);
	while (nxtitem(&ni, (char *)&ship)) {
		if (!owner)
			continue;
		pr(fmt("%s #%d ", mchr[ship.shp_type].m_name, 
			ship.shp_uid));
		switch (random() % 3) {
		case 0:
			pr("scuttled!\n");
			ship.shp_effic = 0;
			break;
		case 1:
			pr("abandoned!\n");
			putvar(V_MILIT, 0, (char *)&ship, EF_SHIP);
			putvar(V_CIVIL, 0, (char *)&ship, EF_SHIP);
			putvar(V_UW, 0, (char *)&ship, EF_SHIP);
			break;
		case 2:
		default:
			damage = (random() % 80) + 10;
			pr(fmt("crew has rioted! (%d%% damage)\n", damage));
			shipdamage(&ship, damage);
			sctnum++;
			break;
		}
		putship(ship.shp_uid, &ship);
	}
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (char *)&plane)) {
		if (!owner)
			continue;
		pr(fmt("%s #%d ", plchr[plane.pln_type].pl_name,
			plane.pln_uid));
		switch (random() % 2) {
		case 0:
			pr("blown up!\n");
			plane.pln_effic = 0;
			break;
		case 1:
		default:
			damage = (random() % 80) + 10;
			pr(fmt("crew has rioted! (%d%% damage)\n", damage));
			planedamage(&plane, damage);
			sctnum++;
			break;
		}
		putplane(plane.pln_uid, &plane);
	}
	snxtitem_all(&ni, EF_TREATY);
	while (nxtitem(&ni, (char *)&treaty)) {
		if (treaty.trt_status == TS_FREE)
			continue;
		if (treaty.trt_cna != cnum && treaty.trt_cnb != cnum)
			continue;
		cn = treaty.trt_cna == cnum ? treaty.trt_cnb : treaty.trt_cna;
		pr(fmt("No more treaty with %s\n", cname(cn)));
		wu(0, cn, fmt("Treaty #%d with %s voided",
			ni.cur, cname(cnum)));
		treaty.trt_status = TS_FREE;
		puttre(ni.cur, &treaty);
	}
	snxtitem_all(&ni, EF_LOAN);
	while (nxtitem(&ni, (char *)&loan)) {
		if (loan.l_status == LS_FREE)
			continue;
		if (loan.l_loner != cnum && loan.l_lonee != cnum)
			continue;
		if (loan.l_loner == cnum) {
			pr(fmt("Loan #%d to %s will never be repaid\n",
				ni.cur, cname(loan.l_lonee)));
			wu(0, loan.l_lonee,
				fmt("Loan #%d from %s has been voided\n",
					ni.cur, cname(cnum)));
		} else {
			pr(fmt("Loan #%d from %s will never be repaid\n",
				ni.cur, cname(loan.l_lonee)));
			wu(0, loan.l_loner,
				fmt("Loan #%d to %s has been voided\n",
				ni.cur, cname(cnum)));
		}
		loan.l_status = LS_FREE;
		putloan(ni.cur, &loan);
	}
	/* clean up commodity and trade for this nation. */
	commlock();
	commread();
	for (n=1; n<I_MAX+1; n++) {
		val = commamt(cnum, n, &dummy);
		commset(cnum, n, -val);
	}
	commwrite();
	communlock();
	snxtitem_all(&ni, EF_TRADE);
	while (nxtitem(&ni, (char *)&trade)) {
		if (trade.trd_unitid >= 0 && trade.trd_owner == cnum) {
			trade.trd_unitid = -1;
			(void) puttrade(ni.cur, &trade);
		}
	}
	while (sctnum > 0) {
		n = sctnum > 127 ? 127 : sctnum;
		nreport(cnum, N_RIOT, 0, n);
		sctnum -= n;
	}
	filetruncate(mailbox(cnum));
	NAT_SET(nat_stat, cnum, STAT_INUSE);
	NAT_SET(nat_btu, cnum, 0);
	nstat = VIS;
	wu(0, 0, fmt("Country #%d (%s) has dissolved\n",
		cnum, cname(cnum)));
	nreport(cnum, N_DISS_GOV, 0, 1);
	return RET_OK;
}
