#ifndef lint
static char *RCSid = "$Header: capi.c,v 1.6 90/03/19 11:01:18 mr-frog Exp $";
#endif /* not lint */

/*
 * capi.c
 *
 * move your capital
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "item.h"
#include "file.h"

capi()
{
	extern	char *argp[];
	struct	sctstr sect;
	struct	natstr *np;
	struct	nstr_sect nstr;
	int	found;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	np = getnatp(cnum);
	found = 0;
	while (!found && nxtsct(&nstr, &sect)) {
		if (owner && sect.sct_type == SCT_CAPIT)
			found++;
	}
	if (!found)
		return RET_FAIL;
	if (sect.sct_x == np->nat_xcap && sect.sct_y == np->nat_ycap) {
		pr(fmt("%s is already your capital.\n",
			xyas(sect.sct_x, sect.sct_y, cnum)));
		return RET_FAIL;
	}
	nstat |= CAP;
	NAT_SET(nat_xcap, cnum, sect.sct_x);
	NAT_SET(nat_ycap, cnum, sect.sct_y);
	pr(fmt("Capital now at %s.\n", xyas(sect.sct_x, sect.sct_y, cnum)));
	return 0;
}
