#ifndef lint
static char *RCSid = "$Header: add.c,v 1.8 89/10/16 20:24:48 mr-frog Exp $";
#endif /* not lint */

/*
 * add.c
 *
 * add a new country to the game.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "tel.h"

add()
{
	extern	char *argp[];
	struct	natstr *natp;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	register int i;
	char	cntryname[21];
	char	pname[21];
	natid	coun;
	natid	freecn;
	char	*prompt;
	char	*p;
	char	loopflag;
	int	stat;

	for (freecn=0; natp = getnatp(freecn); freecn++) {
		if ((natp->nat_stat & STAT_INUSE) == 0)
			break;
	}
	if (freecn < MAXNOC)
		prompt = fmt("New country number? (%d is unused) ", freecn);
	else
		prompt = "New country number? (they all seem to be used) ";
	while ((p = getstarg(argp[1], prompt)) && *p) {
		coun = atoi(p);
		if (coun < MAXNOC)
			break;
		pr(fmt("Max # countries is %d\n", MAXNOC));
		argp[1] = 0;
	}
	if (p == 0 || *p == 0)
		return RET_FAIL;
	natp = getnatp(coun);
	while ((p = getstarg(argp[2], "Country Name? ")) && *p) {
		if (strlen(p) < 20) {
			(void) strcpy(cntryname, p);
			break;
		}
		pr("Too long.\n");
		argp[2] = 0;
	}
	if (p == 0 || *p == 0)
		return RET_OK;
	while ((p = getstarg(argp[3], "Representative? ")) && *p) {
		if (strlen(p) < 20) {
			(void) strcpy(pname, p);
			break;
		}
		pr("Too long.\n");
		argp[3] = 0;
	}
	if (p == 0 || *p == 0)
		return RET_OK;
	loopflag = 1;
	stat = natp->nat_stat;
	prompt = "Status? (visitor, new, active, god, delete) ";
	while (loopflag && (p = getstarg(argp[4], prompt))) {
		loopflag = 0;
		switch (*p) {
		case 'v':
			stat = STAT_INUSE;
			break;
		case 'n':
			stat = STAT_NEW|STAT_INUSE;  
			break;
		case 'a':
			stat = STAT_NORM|STAT_INUSE;
			break;
		case 'g':
			stat = STAT_GOD|STAT_NORM|STAT_INUSE;
			break;
		case 'd':
			stat &= (~STAT_INUSE);
			break;
		default:
			pr("Illegal selection\n");
			loopflag = 1;
			break;
		}
		argp[4] = 0;
	}
	if (p == 0)
		return RET_OK;
	p = getstarg(argp[5],
		"Check, wipe, or ignore existing sectors (c|w|i) ");
	if (p == 0)
		return RET_OK;
	NAT_SET(nat_stat, coun, stat);
	NAT_SET(nat_cnam[0], coun, cntryname);
	NAT_SET(nat_pnam[0], coun, pname);
	if (*p != 'w' && *p != 'c') {
		pr("Any existing sectors ignored\n");
	} else {
		pr("Checking sectors...\n");
		snxtsct_all(&nstr);
		while (nxtsct(&nstr, &sect)) {
			if (sect.sct_own != coun)
				continue;
			pr(fmt("%s ", xyas(nstr.x, nstr.y, cnum)));
			if (*p == 'w') {
				sect.sct_mobil = 0;
				sect.sct_effic = 0;
				sect.sct_own = 0;
				sect.sct_oldown = 0;
				if (sect.sct_type != SCT_MOUNT) {
					sect.sct_type = SCT_RURAL;
					sect.sct_newtype = SCT_RURAL;
				}
				sect.sct_distpath = 0;
				sect.sct_nv = 0;
				putsect(&sect);
				pr("wiped\n");
			} else {
				pr("\n");
			}
		}
	}
	if ((natp->nat_stat & (STAT_INUSE|STAT_NORM|STAT_GOD)) == STAT_INUSE) {
		NAT_SET(nat_btu, coun, 0);
		NAT_SET(nat_login, coun, 0);
		NAT_SET(nat_reserve, coun, 0);
		NAT_SET(nat_tgms, coun, 0);
		NAT_SET(nat_ycap, coun, 0);
		NAT_SET(nat_xcap, coun, 0);
		NAT_SET(nat_yorg, coun, 0);
		NAT_SET(nat_xorg, coun, 0);
		NAT_SET(nat_dayno, coun, 0);
		NAT_SET(nat_minused, coun, 0);
		bzero((char *)natp->nat_b, sizeof (natp->nat_b));
		for (i=0; i < MAXNOR; i++)
			NAT_SETARY(nat_b[0], coun, i, natp->nat_b);
		(void) time(&natp->nat_date);
		NAT_SET(nat_date, coun, natp->nat_date);
		NAT_SET(nat_money, coun, 0);
		for (i=0; i<MAXNOC/8; i++)
			NAT_SETARY(nat_relate[0], coun, i, 0);
		for (i=0; i<4; i++)
			NAT_SETARY(nat_level[0], coun, i, 0.0);
		NAT_SET(nat_newstim, coun, 0);
		(void) creat(mailbox(coun), 0660);
	} else
		pr("No special initializations done...\n");
	return 0;
}
