/*
 * ship.h
 *
 * things having to do with ships
 *
 * from PSL Empire, 1985
 * $Revision: 1.5 $ $Date: 89/06/01 14:18:56 $
 */

#define MAXSHPV	12

struct	shpstr {
	coord	shp_x;		/* x location in abs coords */
	coord	shp_y;		/* y location in abs coords */
	natid    shp_own;	/* owner's country num */
	char    shp_type;	/* ship type */
	char    shp_effic;	/* 0% to 100% */
	char    shp_mobil;	/* mobility units */
	short	shp_sell;	/* pointer to trade file */
	short	shp_tech;	/* tech level ship was built at */
	short	shp_uid;	/* unit id (ship #) */
	char    shp_fleet;	/* group membership */
	char    shp_nplane;	/* number of planes on board (max 8) */
	char	shp_spare;	/* extra space */
	char    shp_nv;		/* current number of variables */
	u_char	shp_vtype[MAXSHPV];
	u_short	shp_vamt[MAXSHPV];
};

#define	MAXMCHV 8

struct	mchrstr {
	int	m_lcm;		/* units of lcm to build */
	int	m_hcm;		/* units of hcm to build */
	int	m_armor;	/* how well armored it is */
	int	m_speed;	/* how fast it can go */
	int	m_visib;	/* how well it can be seen */
	int	m_vrnge;	/* how well it can see */
	int	m_frnge;	/* how far it can fire */
	int	m_glim;		/* how many guns it can fire */
	char	*m_name;	/* full name of type of ship */
	int	m_tech;		/* tech required to build */
	int	m_cost;		/* how much it costs to build */
	int	m_flags;	/* what special things can this ship do */
	u_char	m_nv;		/* number of variables it can hold */
	u_char	m_vtype[MAXMCHV];
	u_short	m_vamt[MAXMCHV];
};

#define M_FOOD		bit(0)	/* catch that fish! */
#define M_TORP		bit(1)	/* fire torpedoes */
#define M_DCH		bit(2)	/* drop depth charges on subs */
#define M_FLY		bit(3)	/* launch and recover planes */
#define M_MSL		bit(4)	/* launch missiles */
#define M_OIL		bit(5)	/* drill for oil */
#define M_SONAR		bit(6)	/* locate submarines */
#define M_MINE		bit(7)	/* drop mines */
#define M_SWEEP		bit(8)	/* clean up the mines */
#define M_SUB		bit(9)	/* a submarine */
#define M_SPY		bit(10)	/* gather intelligence info */
#define M_LAND		bit(11)	/* allows full landing ability */


#define getship(n, p) \
	ef_nbread(EF_SHIP, n, (caddr_t)p)
#define putship(n, p) \
	ef_nbwrite(EF_SHIP, n, (caddr_t)p)
#define getshipp(n) \
	(struct shpstr *) ef_ptr(EF_SHIP, n)

extern	double seagun();

extern  struct mchrstr mchr[];
extern	int shp_maxno;
