/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/plane/RCS/set.c,v 5.1 93/03/14 16:51:21 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:21 $
    $Author: etienne $
    $Id: set.c,v 5.1 93/03/14 16:51:21 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	set.c,v $
 * Revision 5.1  93/03/14  16:51:21  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"

bool SetPlane (plane, soldat)
Plane plane;
int * soldat;
{
	char * ans;
	int price;
	double mult;

	price = planetypes [pl_type (plane)]. cost * pl_eff (plane) / 100;

	ans = InputAtMessage (
	       Fmt ("Set at what price [cost you $%d]: ", price),
	       7, "*.0-9");
	
	if (ans == (char *) 0 || interrupt)

	{
		Message ("Set cancelled");
		return False;
	}


	if (* ans == '*')
	{
		if (sscanf (ans + 1, "%lf", & mult) != 1)
		{
			Message ("Illegal entry, usage: '* mult'");
			Bell ();
			return False;
		}

		price = (int) (price * mult);
	}
	else if (*ans == '\0')
	  ; /* price is set to default already */

	else
		price = atoi (ans);
		

	FeedCommand (Fmt ("set plane %d %d", pl_nr (plane), price), PRINT);
		if (soldat != (int *) 0)
			* soldat = price;
	if (price == 0)
	{
		Message (Fmt ("%s #%d removed from trading",
			PlaneName (plane), pl_nr (plane)));
		clr_pl_sell (plane);
	}
	else
	{
		Message (Fmt ("%s #%d set at $%d",
				PlaneName (plane), pl_nr (plane), price));
		set_pl_sell (plane);
	}

	return True;
}

void SetWing (wing)
char wing;
{
	char * ans;
	double mult;
	int price;
	int soldat;
	Plane ptr;
	int total, n;

	for (ptr = s_fplane (cursct); ptr != (Plane) 0 && pl_wing (ptr) != wing;
				ptr = pl_nxtsct (ptr)) ;

	if (ptr == (Plane) 0)
	{
		Message ("No planes in this wing");
		Bell ();
		return;
	}

	price = planetypes [pl_type (ptr)]. cost * pl_eff (ptr) / 100;

	ans = InputAtMessage (Fmt ("Set at what price [#%d cost you %d]: ",
				pl_nr (ptr), price), 7, ".*0-9");

	if (ans == (char *) 0 || interrupt)
	{
		Message ("Set wing cancelled");
		interrupt = False;
		return;
	}

	if (* ans == '\0')
	{
		mult = 0.0;
		price = -1;
	}
	else if (* ans == '*')
	{
		if (sscanf (ans + 1, "%lf", & mult) != 1)
		{
			Message ("Illegal entry, usage: '* mult'");
			Bell ();
			return;
		}
		price = 0;
	}
	else
	{
		mult = 0.0;
		price = atoi (ans);
		if (price < 0)
		{
			Message ("Set wing cancelled");
			Bell ();
			return;
		}
	}

	total = 0;
	n = 0;
	for (ptr = s_fplane (cursct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) == wing)
		{

			if (mult != 0.0)
			{
				n ++;
				price = planetypes [pl_type (ptr)]. cost *
						pl_eff (ptr) / 100;
				price = (int) (mult * price);
				total += price;
				Message (Fmt ("%s #%d set at $%d -- more",
					PlaneName (ptr), pl_nr (ptr), price));
				FeedCommand (Fmt ("set plane %d %d",
					pl_nr (ptr), price), PRINT);
				set_pl_sell (ptr);
				Pause ();

				if (interrupt)
				{
					interrupt = False;
					break;
				}
			}
			else if (price < 0)
			{
				if (SetPlane (ptr, & soldat))
				{
					n ++;
					total += soldat;
				}
			}
			else
			{
				n ++;
				FeedCommand (Fmt ("set plane %d %d",
					pl_nr (ptr), price), PRINT);
				if (price > 0)
				{
					set_pl_sell (ptr);
					total += price;
				}
				else
					clr_pl_sell (ptr);
			}
		}

	if (n == 0)
		Message ("No planes affected");
	else if (total == 0)
		Message (Fmt ("%d planes removed from trade", n));
	else
		Message (Fmt ("%d plane set, will give $%d ($%d)",
			n, total, (int) (0.95 * total)));
}
