/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/plane/RCS/list.c,v 5.1 93/03/14 16:51:09 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:09 $
    $Author: etienne $
    $Id: list.c,v 5.1 93/03/14 16:51:09 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	list.c,v $
 * Revision 5.1  93/03/14  16:51:09  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "plane.h"
#include "sector.h"

#define SORT_NR		0
#define	SORT_SECTOR	1
#define	SORT_TYPE	2
#define	SORT_WING	3

#define SORT_MAX	4

static char * list_planes_how [] = 
{
	"sort by number",
	"sort by sector",
	"sort by plane-type",
	"sort by wing",
	(char *) 0
};

static char * wing_chars =
	"~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

static void AddPlaneToStrings (strings, plane)
Strings strings;
Plane plane;
{
	AddString (strings, Fmt (
	    "%4d %-16.16s %3d,%-3d %c %3d%% %3d %3d %3d  %3d %3d  %3d %5s",
			pl_nr (plane),
			PlaneName (plane),
			pl_xcd (plane),
			pl_ycd (plane),
			pl_wing (plane),
			pl_eff (plane),
			pl_mob (plane),
			pl_att (plane),
			pl_def (plane),
			pl_tech (plane),
			pl_range (plane),
			pl_hard (plane),
			pl_shipnr (plane) >= 0 ?
				Fmt ("%d", pl_shipnr (plane)) : ""));
}

void ListPlanes (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	int i, j;
	int total;
	Sector sct;
	Plane ptr;
	char * ch;
	bool empty_line;

	strings = InitStrings ();
	AddStringsID (strings, list_planes_how, SORT_MAX, 0);
	pager = InitPager (strings, "Listing of planes");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);
	if (i < 0)
	{
		Message ("No listing");
		return;
	}

	strings = InitStrings ();
	Message ("generating list");
	AddString (strings, 
"   #    type           x,y    w  eff  mu att def tech ran hard ship nuke");
	
	total = 0;
	switch (i)
	{

	case SORT_NR:
		for ALL_PLANES (ptr)
		{
			AddPlaneToStrings (strings, ptr);
			total ++;
		}
		break;
	
	case SORT_SECTOR:
		for (x = - MAX_X / 2; x <= MAX_X / 2; x ++)
			for (y = - MAX_Y / 2; y <= MAX_Y / 2; y++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0)
					continue;

				empty_line = False;
				for (ptr = s_fplane (sct); ptr != (Plane) 0;
							ptr = pl_nxtsct (ptr))
				{
					AddPlaneToStrings (strings, ptr);
					total ++;
					empty_line = True;
				}

				if (empty_line)
					AddString (strings, "");
			}
		break;
	
	case SORT_TYPE:
		for (j = 0; planetypes [j]. nam != (char *) 0; j ++)
		{
			empty_line = False;

			for ALL_PLANES (ptr)
			{
				if (pl_type (ptr) == j)
				{
					total ++;
					AddPlaneToStrings (strings, ptr);
					empty_line = True;
				}

			}

			if (empty_line)
				AddString (strings, "");
		}
		break;
	
	case SORT_WING:
		for (ch = wing_chars; * ch != '\0'; ch ++)
		{
			empty_line = False;

			for ALL_PLANES (ptr)
			{
				if (pl_wing (ptr) == * ch)
				{
					total ++;
					AddPlaneToStrings (strings, ptr);
					empty_line = True;
				}
			}

			if (empty_line)
				AddString (strings, "");
		}

		break;
	}

	if (total == 0)
	{
		Message ("You don't have any planes !");
		FreeStrings (strings);
		Bell ();
		return;
	}

	AddString (strings, Fmt ("%d planes", total));
#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "List of planes");
#else /* TERMC_VERSION */
	InitWMPager (strings, "List of all planes");
#endif /* TERMC_VERSION */
}
