/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/plane/RCS/arm.c,v 5.1 93/03/14 16:51:05 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:05 $
    $Author: etienne $
    $Id: arm.c,v 5.1 93/03/14 16:51:05 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	arm.c,v $
 * Revision 5.1  93/03/14  16:51:05  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "nuke.h"

void RedoArm ()
{
	if (last_layout == PLANE_MODE)
	{
		Arm (10, 10, Fmt ("%d", pl_nr (curplane)));
		CensusPlane (curplane);
	}
	else
	{
		Message ("No current plane selected");
		Bell ();
	}
}

Arm (x, y, what)
int x, y;
char * what;
{
	Stockp stockp;
	char * ans, * ptr;
	int quant, type, max, ok;

	UnmarkAllPlanes ();
	MarkPlanes (what);

	stockp = s_stock (cursct);
	type = SelectNuke(x, y, stockp);
	max = sp_nukamt(stockp,type);

	ans = InputAtMessage (Fmt("Number of devices [%d/1]: ",max),
				3, GS_PNUMBER);
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Arm cancelled");
		Bell ();
		return;
	}
	if (* ans == '\0')
		quant = 1;
	else
		quant = atoi (ans);

	if (quant == 0) {
		interrupt = False;
		Message ("Arm cancelled");
		Bell ();
		return;
	}
	if (quant > max)
		quant = max;

	SetAgain (RedoArm);

	FeedEmpire (Fmt ("arm %s \"%s\" %d", what, nt_name(type), quant),
			PRINT);

	ptr = ReadEmpire(PRINT);

	ok = False;

	if (strchr(ptr,'#') != 0)
	{
		sp_nukamt(stockp,type) -= quant;
		add_nuk(cursct,-quant);
		ok = True;
	}
	else
		ptr = ReadEmpire(PRINT);

	ptr = WaitForPrompt (PRINT);

	if (ok == True)
	{
		FScanPlanes(what,DONT_PRINT);
		CensusPlane (curplane);
	}
}
