/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/scan.c,v 5.1 93/03/14 16:50:19 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:19 $
    $Author: etienne $
    $Id: scan.c,v 5.1 93/03/14 16:50:19 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	scan.c,v $
 * Revision 5.1  93/03/14  16:50:19  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nuke.h"

void FScanNukes (fmt, flag)
char * fmt;
int flag;
{
	char * ptr, * line;
	int i, x, y, nr, owner, amount;
	int nuke_type;
	Stockp stockp;
	Sector sct;
	char word [100];
	bool err;

	FeedEmpire (Fmt ("nukes %s", fmt), flag);
	if (flag == PRINT)
		MessageAtEmpire ("scanning nuke info");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			if (flag == PRINT)
			{
				PrintAtEmpire ("");
				PrintAtEmpire (line);
			}
			return;
		}

		if (StrStr (line, "nuk  x, y") != (char *) 0)
			continue;
		
		if (index (line, ',') != (char *) 0)
		{
			if (deity)
				err = (sscanf (line, "%d %d %d,%d",
					& owner, & nr, & x, & y) != 4);
			else
				err = (sscanf (line, "%d %d,%d",
					& nr, & x, & y) != 3);
			
			if (err)
			{
				PrintAtEmpire ("Strange line, skipped");
				PrintAtEmpire (line);
				Bell (); 
				continue;
			}

			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
			{
				stockp = (Stockp) 0;
				continue;
			}

			stockp = s_stock (sct);
			if (stockp == (Stockp) 0)
				stockp = NewStockPile ();
			
			set_sp_x (stockp, x);
			set_sp_y (stockp, y);
			set_sp_nr (stockp, nr);

			if (deity)
				set_sp_owner (stockp, owner);
			
			set_stock (sct, stockp);
			set_nuk (sct, 0);

			/* init amounts for all nuke types */
			for (i = 0; i < nr_nuke_types; i ++)
				set_sp_nukamt (stockp, i, 0);

			continue;
		}

		ptr = line;
		if (ScanWord (& ptr, word))
		{
			amount = atoi (word);
			if (amount < 0)
			{
				PrintAtEmpire ("Strange line, skipping:");
				PrintAtEmpire (line);
				continue;
			}

			SkipBlank (& ptr);

			nuke_type = FindNukeType (ptr);
			if (nuke_type < 0)
			{
				PrintAtEmpire ("Strange line, skipping:");
				PrintAtEmpire (line);
				continue;
			}

			if (sct == (Sector) 0)
				continue;

			stockp = s_stock (sct);
			if (stockp == (Stockp) 0)
			{
				PrintAtEmpire (Fmt ("Sector %d,%d %s",
					s_xcd (sct), s_ycd (sct),
					"should have a stockpile!"));
				EmpireMore ();
				continue;
			}
			else
			{
				set_sp_nukamt (stockp, nuke_type, amount);
				add_nuk (sct, amount);
			}

			continue;
		}
	}
}
