/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/data.c,v 5.1 93/03/14 16:50:16 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:16 $
    $Author: etienne $
    $Id: data.c,v 5.1 93/03/14 16:50:16 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	data.c,v $
 * Revision 5.1  93/03/14  16:50:16  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nuke.h"

#define MAXBUF	200

void SaveNukeShow (fp)
FILE * fp;
{
	int i;

	fprintf (fp, "%d Nuke types.\n", nr_nuke_types);
	for (i = 0; i < nr_nuke_types; i ++)
	{
		fprintf (fp, "%s\n", nt_name (i));
		fprintf (fp, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
			nt_lcm (i), nt_hcm (i), nt_oil (i), nt_rad (i),
			nt_ava (i), nt_tech (i), nt_cost (i), nt_blst (i),
			nt_dam (i), nt_lbs (i), nt_abils (i));
	}
	fprintf (fp, "END OF SHOW NUKE\n");
}

void LoadNukeShow (fp)
FILE * fp;
{
	char buffer [MAXBUF];
	char * name;
	int lcm, hcm, oil, rad, ava, tech, cost, blst, dam, lbs, abil;
	int i;

	if (fgets (buffer, MAXBUF, fp) == (char *) 0)
	{
		PrintAtEmpire ("Corrupted data file");
		return;
	}
	sscanf (buffer, "%d Nuke types.", & nr_nuke_types);

	for (i = 0; i < nr_nuke_types; i ++)
	{
		(void) fgets (buffer, MAXBUF, fp);
		name = doalloc (strlen (buffer));
		(void) strncpy (name, buffer, strlen (buffer) - 1);
		set_nt_name (i, name);

		(void) fgets (buffer, MAXBUF, fp);
		if (sscanf (buffer, "%d %d %d %d %d %d %d %d %d %d %d",
			& lcm, & hcm, & oil, & rad, & ava, & tech,
			& cost, & blst, & dam, & lbs, & abil) != 11)
		{
			PrintAtEmpire ("Corrupted data file");
			return;
		}

		set_nt_lcm (i, lcm);
		set_nt_hcm (i, hcm);
		set_nt_oil (i, oil);
		set_nt_rad (i, rad);
		set_nt_ava (i, ava);
		set_nt_tech (i, tech);
		set_nt_cost (i, cost);
		set_nt_blst (i, blst);
		set_nt_dam (i, dam);
		set_nt_lbs (i, lbs);
		set_nt_abil (i, abil);
	}

	(void) fgets (buffer, MAXBUF, fp);
}
