/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/grind.c,v 5.1 93/03/14 16:44:35 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:44:35 $
    $Author: etienne $
    $Id: grind.c,v 5.1 93/03/14 16:44:35 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	grind.c,v $
 * Revision 5.1  93/03/14  16:44:35  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"

static int last_number;

void RedoGrind ()
{
	(void) DoGrind (CrdStr (cursct), last_number);
}

void BindGrind  (x, y, str)
int x, y;
char * str;
{
	int number;

	if (str == (char *) 0 || sscanf (str, "( %d )", & number) == 0)
		SingleGrind ();
	else
		DoGrind (CrdStr (cursct), number);
}


void DoGrind (realm, quant)
char *realm;
int quant;
{
	char * ptr;
	int conv;
	Sector sct;
	int x, y;
	int sx, sy, ex, ey;
	int newuw;
	int total_grind;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);
	SetAgain (RedoGrind);
	last_number = quant;

	if (command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
	{
		total_grind = 0;
		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("grind %s %d", realm, quant),
					PRINT);

		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);

				if (sct == (Sector) 0 ||
				    ! s_owned (sct) ||
				    s_des (sct) != 'b' ||
				    s_eff (sct) < 60)
					continue;
				
			}

		Message (Fmt ("%d bars grinded", total_grind));
		DrawMapPart (sx, sy, ex, ey);
		return;
	}

	FeedEmpire (Fmt ("grind %s %d", realm, quant), PRINT); 

	for (;;)
	{
		ptr = ReadEmpire (PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			DrawMapPart (sx, sy, ex, ey);
			return;
		}


	}
}

void SingleGrind ()
{
	char * ans;
	int quant;

	ans = InputAtMessage (Fmt("# to grind [%d]: ",max_comm), 4, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	if (*ans == '\0')
		quant = max_comm;
	else
	{
		quant = atoi (ans);
		if (quant <= 0)
		{
			ClearMes ();
			return;
		}
	}

	DoGrind (CrdStr (cursct), quant);
}
		
void MultiGrind (x, y)
int x, y;
{
	MultiCommand (x, y, "Grind how many bars", "grind", max_comm, DoGrind,
									'\0');
}
