/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/convert.c,v 5.1 93/03/14 16:43:23 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:43:23 $
    $Author: etienne $
    $Id: convert.c,v 5.1 93/03/14 16:43:23 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	convert.c,v $
 * Revision 5.1  93/03/14  16:43:23  etienne
 * corrected small bug, shows not right numbers
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"

static int last_number;

void RedoConvert ()
{
	DoConvert (CrdStr (cursct), last_number);
}

	/* ARGSUSED */
void BindConvert  (x, y, str)	/* convert (10) */
int x, y;
char * str;
{
	int number;

	if (str == (char *) 0 || sscanf (str, "( %d )", & number) == 0)
		SingleConvert ();
	else
		DoConvert (CrdStr (cursct), number);
}


void DoConvert (realm, quant)
char * realm;
int quant;
{
	char * ptr;
	int conv;
	Sector sct;
	int x, y;
	int sx, sy, ex, ey;
	int newuw;
	int total_conv;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);
	SetAgain (RedoConvert);
	last_number = quant;

	if (command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
	{
		total_conv = 0;
		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("convert %s %d", realm, quant),
					PRINT);

		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);

				if (sct == (Sector) 0 ||
				    ! s_owned (sct) ||
				    s_occ (sct) != '*' ||
				    s_civ (sct) <= 0 ||
				    s_civ (sct) > s_mil (sct) * 10)
					continue;
				
				newuw = s_civ (sct);
				if (newuw > quant)
					newuw = quant;
				
				if (q_uw (sct) + newuw > max_civ_uw)
					newuw = max_civ_uw - q_uw (sct);

				if (newuw <= 0)
					continue;

				if (newuw > 5 * s_mob (sct))
					newuw = s_mob (sct) * 5;
				
				total_conv += newuw;
				set_civ (sct, s_civ (sct) - newuw);
				set_q_uw (sct, q_uw (sct) + newuw);
				set_mob (sct, s_mob (sct) -
					roundavg (newuw / 5.0));
				
				if (s_civ (sct) == 0)	
				{
					set_occ (sct, '.');
					Warning (Fmt (
						"%s is now completly yours.",
						CrdStr (sct)));
				}
			}

		Message (Fmt ("%d converted", total_conv));
		DrawMapPart (sx, sy, ex, ey);
		return;
	}

	FeedEmpire (Fmt ("convert %s %d", realm, quant), PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			DrawMapPart (sx, sy, ex, ey);
			return;
		}

		if (StrEQ (ptr, "No room for new uw in"))
		{
			Message (ptr);
			Bell ();
			continue;
		}


		if (sscanf (ptr, "%d,%d is now completely y", & x, & y) == 2)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
				continue;

			Message (ptr);
			set_occ (sct, '.');
			continue;
		}

		if (sscanf (ptr, "%d conquered civilians converted in %d,%d",
			& conv, & x, & y) == 3)
		{
			Message (ptr);
			sct = World (x, y, S_EXIST);

			if (sct == (Sector) 0)
				continue;

			set_civ (sct, s_civ (sct) - conv);
			set_q_uw (sct, q_uw (sct) + conv);
			continue;
		}
	}
}

void SingleConvert ()
{
	char * ans;
	int quant;

	ans = InputAtMessage (Fmt("# to convert [%d]: ",max_civ_uw), 4, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	if (*ans == '\0')
		quant = max_civ_uw;
	else
	{
		quant = atoi (ans);
		if (quant <= 0)
		{
			ClearMes ();
			return;
		}
	}

	DoConvert (CrdStr (cursct), quant);
}
		
void MultiConvert (x, y)
int x, y;
{
	MultiCommand (x, y, "Convert how many civs", "convert", max_civ_uw, DoConvert,
									'\0');
}
