/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/census/RCS/wing.c,v 5.1 93/03/14 16:42:14 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:42:14 $
    $Author: etienne $
    $Id: wing.c,v 5.1 93/03/14 16:42:14 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	wing.c,v $
 * Revision 5.1  93/03/14  16:42:14  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "plane.h"
#include "census.h"
#include "sector.h"

extern struct s_funcbutton plane_functions [];

static bool wing_censenable [PCM_MAX];
static int nr_atscreen;
static bool cens_more;
static Plane cens_planes [WL_MAX_PLANES + 1];

static void HandleCensusButtonForWing (button)
int button;
{
	if (! wing_censenable [button])
		return;

	UnmarkAllPlanes ();

	switch (button)
	{

	case PCM_FLY:
		DoFly (10, 10, WingId (), (char *) 0, (char *) 0,
						(char *) 0);
		break;

	case PCM_BOMB:
		DoBomb (10, 10, cursct, WingId (),
			(char *) 0, (char *) 0, (char *) 0, False);
		break;

	case PCM_TRANSPORT:
		Transport (10, 10, WingId ());
		break;

	case PCM_PARADROP:
		Paradrop (10, 10, WingId ());
		break;

	case PCM_DROP:
		DoDropOff (10, 10, WingId (), (char *) 0, (char *) 0,
			(char *) 0);
		break;

	case PCM_SET:
		SetWing (curwing);
		break;

	case PCM_SCRAP:
		ScrapPlane (WingId ());
		break;
	
	case PCM_HARDEN:
		Harden (Fmt ("%c", curwing));
		break;

	case PCM_RECON:
		Recon (10, 10, WingId ());
		break;

	case PCM_LAUNCH:
		DoLaunchWing (WingId ());
		break;
	
	}

	CensusWing (curwing);
}

static void CensusMergeWings ()
{
	char * ans;
	char buffer [BUFSIZ];
	bool first;
	Plane ptr;

	CenClr (WL_SY_WING);
	ShowFreeWings ();
	CenPuts (0, WL_SY_WING, "Add to wing: ");
	ans = GetString (census_win, 13, WL_SY_WING, 1, "a-zA-Z~");
	
	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		interrupt = False;
		CensusWing (curwing);
		return;
	}
	else if (! WingColocated (curwing))
	{
		buffer [0] = '\0';
		first = True;
		for (ptr = s_fplane (cursct); ptr != (Plane) 0;
						ptr = pl_nxtsct (ptr))
		{
			if (pl_wing (ptr) == curwing)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");
				
				strcat (buffer,
					Fmt ("%d", pl_nr (ptr)));
				
				set_pl_wing (ptr, * ans);
			}
		}

		FeedCommand (Fmt ("wingadd %c %s", * ans, buffer),
					PRINT);
	}
	else
	{
		FeedCommand (Fmt ("wingadd %c %c", * ans, curwing),
					PRINT);
		WingJoin (curwing, * ans);
	}

	curwing = * ans;
	CensusWing (curwing);
}

void CensusLayWing ()
{
	CenLine (WL_SY_WING - 1);
	CenPuts (0, WL_SY_WING, "Wing: ");
	CenPuts (0, WL_SY_POS, "Pos: ");

	CenLine (WL_SY_POS + 1);
	CenPuts (0, WL_SY_HEADER, "Plane          Mob Eff Ran");

	CenLine (WL_SY_BUT - 1);
	CenButton (WL_SX_SECTOR, WL_SY_BUT, "Sector", 6, False);
	CenButton (WL_SX_NEXT,   WL_SY_BUT, "Next", 4, False);
	CenLine (WL_SY_BUT + 1);
}

static void ShowCensusWing (start, wing)
Plane start;
char wing;
{
	int i;
	register Plane plane;

	CenPuts (WL_SX_MORE, WL_SY_BUT, "    ");

	for (i = 0; i < WL_MAX_PLANES; i ++)
		CenClr (WL_SY_PLANES + i);

	nr_atscreen = 0;

	for (plane = start; plane != (Plane) 0; plane = pl_next (plane))
	{
			/* same sector? */
		if ((pl_xcd (plane) != s_xcd (cursct) ||
		     pl_ycd (plane) != s_ycd (cursct)))
			continue;

			/* same wing? */
		if (pl_wing (plane) != wing)
			continue;

			/* need a more? */

		if (nr_atscreen == WL_MAX_PLANES)
		{
			cens_planes [nr_atscreen] = plane;
			cens_more = True;
			CenButton (WL_SX_MORE, WL_SY_BUT, "More", 4, False);
			return;
		}

		CenPutVal (0, WL_SY_PLANES + nr_atscreen,
			Fmt ("%-14.14s %-3d %-3d %-3d",
				PlaneName (plane),
				pl_mob (plane), pl_eff (plane),
				pl_range (plane)));
		
		cens_planes [nr_atscreen ++] = plane;
	}

	cens_more = False;
}

void WingCensus (wing)
char wing;
{
	int i;
	register Plane ptr;
	bool fly, bomb, drop, recon, harden, launch;

	CenClr (WL_SY_WING);
	CenPuts (0, WL_SY_WING, "Wing: ");
	if (! WingColocated (wing) && wing != '~')
		CenPutVal (6, WL_SY_WING, Fmt ("%c (Not colocated)", wing));
	else
		CenPutVal (6, WL_SY_WING, Fmt ("%c", wing));
						
	for (i = 0; i < PCM_MAX; i ++)
		wing_censenable [i] = False;

	CenClr (WL_SY_POS);
	CenPuts (0, WL_SY_POS, "Pos:");
	if (WingEmpty (wing))
	{
		CenPutVal (0, WL_SY_POS, "Empty!");
		FlushWindow (census_win);
		DrawCensusButtons (plane_functions, PCM_MAX, wing_censenable);
		return;
	}

	CenPuts (0, WL_SY_POS, "Pos: ");

	if (! WingColocated (wing) && wing != '~')
		CenPutVal (6, WL_SY_POS, "??,??");
	else
		CenPutVal (6, WL_SY_POS, CrdStr (WingSector (wing)));

	ShowCensusWing (first_plane, wing);
	curwing = wing;

	wing_censenable [PCM_TRANSPORT] = 
		wing_censenable [PCM_SET] = True;

	wing_censenable [PCM_SCRAP] = s_des (cursct) == '*' &&
				       s_eff (cursct) > 59;
	
	harden = launch = fly = bomb = recon = drop = False;

	for (ptr = s_fplane (cursct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) == wing)
		{
			if (pl_mob (ptr) <= 0)
				continue;

			if (! PlaneHas (ptr, P_V) && s_des (cursct) != '.' &&
			    (s_des (cursct) != '*' || s_eff (cursct) < 60))
				continue;

			fly = fly || !(PlaneHas (ptr, P_M) ||
				       PlaneHas (ptr, P_O));

			bomb = bomb || PlaneHas (ptr, P_B) ||
				       PlaneHas (ptr, P_T);

			if (PlaneHas (ptr, P_C)) drop   = True;

/*
 * You can recon with any plane. Spy planes just give more info
 *
 *			recon = recon || PlaneHas (ptr, P_S);
 */
			recon = recon || !(PlaneHas (ptr, P_M) ||
				       PlaneHas (ptr, P_O));

			harden = harden || (PlaneHas (ptr, P_M) &&
					    !PlaneHas (ptr, P_F));

			launch = launch || ((PlaneHas (ptr, P_M) &&
					    !PlaneHas (ptr, P_F)) ||
					    PlaneHas (ptr, P_O));
		}
		

	wing_censenable [PCM_FLY] = fly;
	wing_censenable [PCM_BOMB] = bomb;
	wing_censenable [PCM_DROP] = wing_censenable [PCM_PARADROP] = drop;
	wing_censenable [PCM_RECON] = recon;
	wing_censenable [PCM_HARDEN] = harden;
	wing_censenable [PCM_LAUNCH] = launch;

	DrawCensusButtons (plane_functions, PCM_MAX, wing_censenable);
	FlushWindow (census_win);
	Refresh ();
}

void WingCensusBut (x, y)
int x, y;
{
	char next;
	char * ans;
	int i;

	if (y == WL_SY_BUT)
	{
		if (ButtonPressed (x, y, WL_SX_SECTOR, y, 6))
			CensusSct (cursct);
		else if (ButtonPressed (x, y, WL_SX_MORE, y, 4))
		{
			if (! cens_more)
				return;
			ShowCensusWing (cens_planes [nr_atscreen], curwing);
			FlushWindow (census_win);
		}
		else if (ButtonPressed (x, y, WL_SX_NEXT, y, 4))
		{
			next = NextWingInSct (cursct, curwing);
			if (next == '\0')
				next = FirstWingInSct (cursct);
			curwing = next;
			CensusWing (next);
		}

		return;
	}

		/*
		 *	Census of plane
		 */

	if (y >= WL_SY_PLANES && y < WL_SY_PLANES + nr_atscreen)
	{
		curplane = cens_planes [y - WL_SY_PLANES];
		CensusPlane (curplane);
		return;
	}

		/*
		 *	Wing add
		 */

	if (y == WL_SY_WING)
	{
		CensusMergeWings ();
		CensusWing (curwing);
		return;
	}

	i = WhichCensusButton (plane_functions, PCM_MAX, x, y);
	if (i >= 0)
	{
		HandleCensusButtonForWing (i);
		return;
	}
}
