/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/census/RCS/army.c,v 5.1 93/03/14 16:40:52 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:40:52 $
    $Author: etienne $
    $Id: army.c,v 5.1 93/03/14 16:40:52 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	army.c,v $
 * Revision 5.1  93/03/14  16:40:52  etienne
 * initial rev.
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "land.h"
#include "sector.h"

static int nr_atscreen = 0;
static bool cens_more = False;
static Land cens_lands [AL_MAX_LANDS + 1];

static bool army_censenable [LND_MAX];

extern struct s_funcbutton land_functions [];

static void HandleCensusButtonForArmy (button)
int button;
{
	Neighb neighb;
	Sector nxt;
	char * army;
	int range;
	int i;

	if (! army_censenable [button])
		return;

	army = ArmyId ();

	UnmarkAllLands ();
	MarkLands (army);

	switch (button)
	{

	case LND_RADAR:
		Message ("Scanning radar");
		range = MaxRadarMarked (& i);
		if (range <= 0)
			break;
		FScanLRadar (Fmt (" %i", i));
		DrawMap ();
		break;

	case LND_LOOK:
		Message ("Scanning lookout");
		range = MaxRadarMarked (& i);
		if (range <= 0)
			break;
		DoLLookout (cursct, i, False, PRINT, True);
		DrawMap ();
		break;

	case LND_MARCH:
		March (army);
		break;

	case LND_MINE:
		Mine (Fmt ("%c", army));
		break;

	case LND_FIRE:
		MFireFromArmy (army);
		break;

	case LND_SCRAP:
		ScrapLand (army);
		break;

	case LND_SCUTTLE:
		ScuttleLand (army);
		break;

	case LND_SET:
		Message ("Unable to set a army (yet)");
		Bell ();
		break;
		/* SetArmy (army); */

	case LND_FORT:
		Fortify (army);
		break;

	default:
		break;
	}
}

static void CensusMergeArmys ()
{
	char * army, * ans;
	Land ptr;

	CenClr (AL_SY_ARMY);
	ShowFreeArmys ();
	PrintN (census_win, 0, AL_SY_ARMY, "Add to army: ");
	ans = GetString (census_win, 15, AL_SY_ARMY, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
		interrupt = False;
	else
	{
		army = ArmyId ();
		if (* ans == curarmy)
		{
			Message ("No need to change that");
			Bell ();
			return;
		}

		FeedCommand (Fmt ("army %c %s", * ans, army), PRINT);

		UnmarkAllLands ();
		MarkLands (army);
		for ALL_LANDS (ptr)
			if (ld_marked (ptr))
				set_ld_army (ptr, * ans);
			
		Message (Fmt ("Army %c added to %c", curarmy, * ans));
		curarmy = * ans;
	}

	CensusArmy (curarmy);
}

void CensusLayArmy ()
{
	CenLine (AL_SY_ARMY - 1);
	CenPuts (0, AL_SY_ARMY,  "Army:");
	CenPuts (0, AL_SY_POS,  "Pos:");
	CenPuts (0, AL_SY_MISSION,  "Mis:");
	CenPuts (0, AL_SY_RETREAT,  "Ret:");
	CenLine (AL_SY_RETREAT + 1);
	CenPuts (0, AL_SY_HEADER, "Ld#  Land          Mob Eff");
	CenLine (AL_SY_BUT - 1);
	CenButton (AL_SX_SECTOR,  AL_SY_BUT, "Sector", False);
	CenButton (AL_SX_NEXT,    AL_SY_BUT, "Next",   False);
	CenLine (AL_SY_BUT + 1);
}

static void ShowCensusArmy (start, army)
Land start;
char army;
{
	int i;
	register Land land;

		/* clear more */
	CenPuts (AL_SX_MORE, AL_SY_BUT, "    ");

		/* clear lands */
	for (i = 0; i < AL_MAX_LANDS; i++)
		CenClr (AL_SY_LANDS + i);
	
	nr_atscreen = 0;

	for (land = start; land != (Land) 0; land = ld_next (land))
	{
			/* same sector ? */
		if ((ld_xcd (land) != s_xcd (cursct) ||
		     ld_ycd (land) != s_ycd (cursct)))
			continue;

			/* same army ? */
		if (ld_army (land) != army)
			continue;

			/* need a more? */
		if (nr_atscreen == AL_MAX_LANDS)
		{
			cens_lands [nr_atscreen] = land;
			cens_more = True;
			CenButton (AL_SX_MORE, AL_SY_BUT, "More", False);
			return;
		}

			/* print land */
		CenPutVal (0, AL_SY_LANDS + nr_atscreen,
			Fmt ("%-4d %-13.13s %-3d %-3d",
				ld_nr (land),
				LandName (land),
				ld_mob (land),
				ld_eff (land)));
		
		cens_lands [nr_atscreen ++] = land;
	}

	cens_more = False;
}

void ArmyCensus (army)
char army;
{
	Sector sct;
	int i;

	curarmy = army;

	CenClr (AL_SY_ARMY);
	CenPuts (0, AL_SY_ARMY, "Army: ");
	CenPutVal (7, AL_SY_ARMY, Fmt ("%c%s", army,
		ArmyColocated (army) ? "" : "(not colocated)"));

	CenClr (AL_SY_POS);

	if (ArmyEmpty (army))
	{
		CenPutVal (0, AL_SY_POS, "Army empty!");
		FlushWindow (census_win);
		Refresh ();
		return;
	}

	CenPuts (0, AL_SY_POS, "Pos: ");
	if (ArmyColocated (army))
		CenPutVal (5, AL_SY_POS, CrdStr (ArmySector (army)));

	CenPuts (0, AL_SY_HEADER, "Ld#  Land          Mob Eff");

	ShowCensusArmy (landlist, army);
	FlushWindow (census_win);


		/* army census, should always be owned */

	for (i = 0; i < LND_MAX; i ++)
		army_censenable [i] = False;

	UnmarkAllLands ();
	MarkLands (Fmt ("%c", curarmy));
	army_censenable [LND_SET] = trade;
	army_censenable [LND_RADAR] = MaxRadarMarked ((int *) 0) > 0;
	army_censenable [LND_LOOK] = True;
	army_censenable [LND_MARCH] = MinMobMarkedLands ((Land *) 0) > 0;
	army_censenable [LND_FORT] = MinMobMarkedLands ((Land *) 0) > 0;
	army_censenable [LND_MINE] = ArmyHasEngineer ((Land *) 0) > 0;
	army_censenable [LND_WORK] = ArmyHasEngineer ((Land *) 0) > 0;
	army_censenable [LND_FIRE] = True;
	army_censenable [LND_SCRAP] = True;
	army_censenable [LND_SCUTTLE] = True;

	DrawCensusButtons (land_functions, LND_MAX, army_censenable);
	FlushWindow (census_win);
	Refresh ();
}

void ArmyCensusBut (x, y)
{
	int i;

	if (y == AL_SY_BUT)
	{
		if (ButtonPressed (x, y, AL_SX_SECTOR, AL_SY_BUT, 6))
		{
			curarmy = '\0';
			curland = (Land) 0;
			Census ();
		}
		else if (ButtonPressed (x, y, AL_SX_MORE, AL_SY_BUT, 4))
		{
			if (! cens_more)
				return;

			ShowCensusArmy (cens_lands [nr_atscreen], curarmy);
			FlushWindow (census_win);
			Refresh ();
		}
		else if (ButtonPressed (x, y, AL_SX_NEXT, AL_SY_BUT, 4))
		{
			curarmy = GiveNextArmyInSct (cursct, curarmy);
			CensusArmy (curarmy);
		}

		return;
	}

	if (y == AL_SY_ARMY)
	{
		CensusMergeArmys ();
		return;
	}

	if (y >= AL_SY_LANDS && y < AL_SY_LANDS + nr_atscreen)
	{
		curland = cens_lands [y - AL_SY_LANDS];
		CensusLand (curland);
		return;
	}

	i = WhichCensusButton (land_functions, LND_MAX, x, y);

	if (i != -1)
	{
		HandleCensusButtonForArmy (i);
		return;
	}
}
