/*
    $Header: /usr/local/src/et/work/xemp5.0/include/RCS/ferry.h,v 5.1 93/03/14 16:39:07 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:39:07 $
    $Author: etienne $
    $Id: ferry.h,v 5.1 93/03/14 16:39:07 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	ferry.h,v $
 * Revision 5.1  93/03/14  16:39:07  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:25:20  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:17:12  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#ifndef _FERRY
#define _FERRY

#ifndef _VAR
#include "var.h"
#endif

#define	RET_DONE	0
#define	RET_PREV	1
#define RET_NEXT	2
#define RET_DELE	3

#define	TASK_CARGO	0
#define TASK_GOTO	1
#define	TASK_EXPLORE	2
#define TASK_OIL	3

#define TASK_MAX	2

typedef struct s_ferry * Ferry;

struct s_ferry
{
	int id;
	char fleet;		/* when '\0'-> use shipnr */
	int shipnr;
	int task;
	bool active;
	bool complet;
	bool goto_a;
	char expl_dir;
	int waremob;
	int oil_min;
	short ax, ay, bx, by;
	int dir [V_MAX];
				/* bit 0: A -> B
				 * bit 1: B -> A
				 * bit 2: import
				 */
	int thr_ship [V_MAX];
	int thr_sct [V_MAX];
	int max_ship [V_MAX];
	Ferry next, prev;
};


#define SET_A_TO_B(i)	((i) = (((i) & ~0x03) | 0x01))
#define SET_B_TO_A(i)	((i) = (((i) & ~0x03) | 0x02))
#define SET_NOMOVE(i)	((i) &= ~0x03)
#define SET_IMPORT(i)	((i) |= 0x04)
#define SET_NOIMP(i)	((i) &= ~0x04)
#define IS_A_TO_B(i)	(((i) & 0x01) == 0x01)
#define IS_B_TO_A(i)	(((i) & 0x02) == 0x02)
#define IS_NOMOVE(i)	(((i) & 0x03) == 0x00)
#define IMPORT(i)	(((i) & 0x04) == 0x04)

#ifdef TERMC_VERSION

#define F_MAX_X		70

#define	F_SX_DONE	2
#define F_SX_PREV	16
#define	F_SX_RUN	30
#define	F_SX_NEXT	44
#define	F_SX_DELETE	58

#define	LINE_FLEET	1
#define LINE_SECTA	2
#define LINE_SECTB	3
#define LINE_ACTIVE	4
#define LINE_DIR	5
#define LINE_WAREH	6
#define LINE_HEADER	7
#define LINE_ITEMS	8
#define LINE_LOW	LINE_ITEMS + V_MAX

#else	/* X_VERSION */

#define	F_MAX_X		80

#define	F_SX_DONE	3
#define	F_SX_PREV	20
#define	F_SX_RUN	38
#define	F_SX_NEXT	54
#define	F_SX_DELETE	69

#define	LINE_FLEET	5
#define LINE_SECTA	7
#define LINE_SECTB	8
#define LINE_ACTIVE	9
#define LINE_DIR	10
#define LINE_WAREH	12
#define LINE_HEADER	15
#define LINE_ITEMS	17
#define LINE_LOW	LINE_ITEMS + V_MAX + 3

#endif /* TERMC_VERSION */

#endif _FERRY
