#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "main.h"
#include "xextern.h"
#include "sector.h"
#include "census.h"

extern WinInfo root_win;
extern WinInfo nation_win;
extern WinInfo census_win;
extern WinInfo empire_win;
extern WinInfo map_win;

bool StandardEvent (pevent)
XEvent *pevent;
{
	char buffer [BUFSIZ];
	KeySym keysym;
	XComposeStatus comp_status;

	if (ScrollEvent (pevent))
		return True;

	if (SetInterrupt (pevent))
		return True;

	if (PagerEvent (pevent))
		return True;

	switch ((int) pevent-> xany. type)
	{

	case Expose:
		RefreshEvent (pevent);
		return True;
	
	case KeyPress:
		XLookupString (& (pevent-> xkey),
				    buffer,
				    BUFSIZ - 1,
				    &keysym,
				    &comp_status);

		switch ((int) keysym)
		{
			
		case XK_Up:
			ShiftField (0, -1);
			return True;

		case XK_Down:
			ShiftField (0, 1);
			return True;

		case XK_Right:
			ShiftField (1, 0);
			return True;

		case XK_Left:
			ShiftField (-1, 0);
			return True;

		case XK_F1:
			RaiseAll ();
			break;
		
		case XK_F2:
			LowerAll ();
			break;

		}

		return False;
	}

	return False;
}

void CheckRefreshEvents ()
{
	XEvent event;

	if (! xstarted)
		return;

	while (XCheckTypedEvent (display, Expose, & event) == True)
		RefreshEvent (& event);
}

void HandelWaitingEvents ()
{
	XEvent event;

	if (! xstarted)
		return;

	while (XPending (display) > 0)
	{
		XNextEvent (display, &event);
		(void) StandardEvent (& event);
	}
}
		
static void MapButton (pevent)
XEvent *pevent;
{
	int button;
	Sector sct;
	int x, y;

	extern Sector FindSector ();
	
	button = pevent-> xbutton. button;
	x = pevent-> xbutton. x;
	y = pevent-> xbutton. y;

	if (button == LEFT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		SetCurrent (sct);
		return;
	}
	else if (button == MIDDLE_BUTTON)
	{
		GlobalCommands (PixelToCharX (x), PixelToCharY (y));
		return;
	}
	else if (button == RIGHT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		if (sct != cursct)
			SetCurrent (sct);

		SectorCommands (PixelToCharX (x), PixelToCharY (y));
		return;
	}
}

static void EmpireButton (pevent)
XEvent *pevent;
{
	int button;
	
	button = pevent-> xbutton. button;

	if (button == LEFT_BUTTON)
		InputToEmpire ();

	Census ();
}

void MainLoop ()
{
	XEvent event;
	WinInfo win;

	for (;;)
	{
		FreeFmts ();

		XNextEvent (display, & event);

		/* since interrupt is a standard event nothing will happen
		 * when interrupted at this level
		 */
		if (!StandardEvent (& event))
		{

			win = EventWindow (& event);

			switch (event.type)
			{

			case ButtonPress:

				if (win == map_win)
					MapButton (& event);
				else if (win == empire_win)
					EmpireButton (& event);
				else if (win == census_win)
					CensusButton (
					    PixelToCharX (event. xbutton. x),
					    PixelToCharY (event. xbutton. y));
				break;

			case ConfigureNotify:
				break;

			case KeyPress:
				GlobalKey (& event);
			}
		}

		interrupt = False;
	}
}
