#include "setup.h"

typedef struct s_deplist * DepList;
typedef struct s_depend * Depend;

#define MAX_FILELEN	100
#define MAX_DEPENDS	500

static Depend dep [MAX_DEPENDS];
static int nr_deps = 0;

struct s_deplist
{
	char filename [MAX_FILELEN];
	DepList next;
};

struct s_depend
{
	char filename [MAX_FILELEN];
	DepList list, tail;
};

static char * FindIncludeFile (file, x_file)
char * file;
bool x_file;
{
	char ** dptr;
	char ** includes;

	includes = x_file ? x_incl_dirs : tc_incl_dirs;

	for (dptr = includes; * dptr != (char *) 0; dptr ++)
		if (access (Fmt ("%s/%s", * dptr, file), R_OK) == 0)
			return Fmt ("%s/%s", * dptr, file);
	
	Error ("can't find include file: %s\n", file);
}

static Depend NewDepend (filename)
char * filename;
{
	Depend new;

	new = (Depend) malloc ((unsigned) sizeof (struct s_depend));
	(void) strcpy (new-> filename, filename);
	new-> tail = (DepList) 0;
	new-> list = (DepList) 0;
	dep [nr_deps ++] = new;

	return new;
}

static Depend FindDepend (file)
char * file;
{
	int i;

	for (i = 0; i < nr_deps; i ++)
		if (strcmp (dep [i]-> filename, file) == 0)
			return dep [i];

	return (Depend) 0;
}

static void AddDepList (depend, file)
Depend depend;
char * file;
{
	DepList new;

	new = (DepList) malloc ((unsigned) sizeof (struct s_deplist));
	(void) strcpy (new-> filename, file);
	new-> next = (DepList) 0;

	if (depend-> list == (DepList) 0)
	{
		depend-> list = new;
		depend-> tail = new;
	}
	else
	{
		depend-> tail-> next = new;
		depend-> tail = new;
	}
}

static bool HasDependencies (depend)
Depend depend;
{
	return depend-> list != (DepList) 0;
}

static Depend MakeDepend (file)
char * file;
{
	FILE * grep_fp;
	char buf [BUFSIZ];
	char file_buf [BUFSIZ];
	char file_cop [BUFSIZ];
	Depend depend;

	depend = NewDepend (file);

	grep_fp = popen (Fmt ("egrep '^#include ' %s", file), "r");
	if (grep_fp == (FILE *) 0)
		Error ("can't exec \"egrep '^#include ' %s\"\n", file);

	while (fgets (buf, BUFSIZ, grep_fp) != (char *) 0)
	{
		if (sscanf (buf, "#include \"%[^\"]\"", file_buf) != 1)
			continue;

		if (! depend_proto && strcmp (file_buf, "proto.h") == 0)
			continue;
		
		Verbose ("\t\t%s\n", file_buf);
		strcpy (file_cop, FindIncludeFile (file_buf, 
				strncmp (file, "x/", 2) == 0));
		AddDepList (depend, file_cop);

		if (FindDepend (file_cop) == (Depend) 0)
			MakeDepend (file_cop);
	}

	pclose (grep_fp);
	return depend;
}

static void PrintDependList (fp, depend)
FILE * fp;
Depend depend;
{
	DepList ptr;
	Depend depptr;

	for (ptr = depend-> list; ptr != (DepList) 0; ptr = ptr-> next)
	{
		fprintf (fp, " \\\n\t%s", ptr-> filename);
		depptr = FindDepend (ptr-> filename);
		if (depptr == (Depend) 0)
			Error ("internal error, no deps for %s.\n",
						ptr-> filename);
		PrintDependList (fp, depptr);
	}
}

void PrintDepend (fp, file)
FILE * fp;
char * file;
{
	Depend depend;
	char file_buf [BUFSIZ];

	depend = FindDepend (file);
	if (depend == (Depend) 0)
		depend = MakeDepend (file);
	
	if (HasDependencies (depend))
	{
		strcpy (file_buf, file);
		file_buf [strlen (file) - 1] = 'o';
		fprintf (fp, "%s:", file_buf);
		PrintDependList (fp, depend);
		fprintf (fp, "\n\n");
	}
}
