#include <stdio.h>
#include <varargs.h>
#ifndef R_OK
#include <unistd.h>
#endif

typedef int bool;

#ifndef True
#define		True		1
#define		False		0
#endif /* True */

#ifndef BUFSIZ
#define		BUFSIZ		1024
#endif /* BUFSIZ */

bool verbose = False;
char * progname = "proto";
char * ctags = "ctags";
char * grep = "egrep";

char * Fmt (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];
	
	va_start (args);
	ptr = va_arg (args, char *);

	(void) vsprintf (fmtbuf, ptr, args);
	va_end (args);

	return fmtbuf;
}

void Verbose (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];
	
	if (verbose)
	{
		va_start (args);
		ptr = va_arg (args, char *);

		(void) vsprintf (fmtbuf, ptr, args);
		va_end (args);

		printf (fmtbuf);
	}
}

void Error (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];

	va_start (args);
	ptr = va_arg (args, char *);
	(void) vsprintf (fmtbuf, ptr, args);
	va_end (args);

	fprintf (stderr, "%s: %s", progname, fmtbuf);
	exit (-1);
}

void Usage ()
{
	fprintf (stderr, "usage: %s [options] <files>+\n", progname);
	fprintf (stderr, "options:\n");
	fprintf (stderr, "\t-v               verbose\n");
	fprintf (stderr, "\t-f <file>        output file\n");
	fprintf (stderr, "\t-g <command>     alternative grep command\n");
	fprintf (stderr, "\t-c <command>     alternative ctags command\n");
	exit (-1);
}

bool CharInFormat (ch, format)
char ch, * format;
{
	char * ptr;

	for (ptr = format; * ptr != '\0'; ptr++)
		if (*(ptr + 1) == '-')
			if (ch >= * ptr && ch <= * (ptr + 2))
				return True;
			else
				ptr += 2;
		else
			if (* ptr == ch) 
				return True;
	return False;
}

void Scan (ptr, buf, fmt)
char ** ptr;
char * buf;
char * fmt;
{
	char * bufptr;
	void Skip ();

	if (** ptr == '\0')
		return;

	bufptr = buf;
	while (CharInFormat (** ptr, fmt))
	{
		* buf = ** ptr;
		++ buf;
		++ * ptr;
	}
	
	* buf = '\0';
}

void Skip (ptr, fmt)
char ** ptr;
char * fmt;
{
	char buffer [BUFSIZ];

	Scan (ptr, buffer, fmt);
	Scan (ptr, buffer, " \t");
}

void ScanSkip (ptr, buffer, fmt)
char ** ptr;
char * buffer, * fmt;
{
	Scan (ptr, buffer, fmt);
	Skip (ptr, " \t");
}

void MakeProto (fp, file)
FILE * fp;
char * file;
{
	char buffer [BUFSIZ];
	char * bufptr;
	bool first;
	FILE * pp;
	int len;

	char func [BUFSIZ];
	char word1 [BUFSIZ];
	char word2 [BUFSIZ];
	char ch;

	char * index ();

	Verbose ("file: %s\n", file);

	if (access (file, R_OK) != 0)
		Error ("can't open %s.\n", file);
	
	pp = popen (Fmt ("%s -x %s | %s -v '(static|#if|else if|=)'",
					ctags, file, grep), "r");
	if (pp == (FILE *) 0)
		Error 
		     ("can't exec \"%s -x %s | %s -v '(static|#if|else if|=)'",
							ctags, file, grep);
	
	first = True;
	while (fgets (buffer, BUFSIZ, pp) != (char *) 0)
	{
		bufptr = index (buffer, '#');
		if (bufptr != (char *) 0)
		{
			bufptr ++;
			Skip (& bufptr, " \t");
			if (strncmp (bufptr, "define", 6) == 0)
				continue;
		}

		buffer [strlen (buffer) - 1] = '\0';
		bufptr = buffer;

		ScanSkip (& bufptr, func, "a-zA-Z0-9_.");
		ScanSkip (& bufptr, word2, "/a-zA-Z0-9_.");
		if (strcmp (word2, file) == 0)
		{
			len = strlen (func);
			while (ch = func [len - 1], ch >= '0' && ch <= '9')
				func [-- len] = '\0';
		}
		else
			Skip (& bufptr, "/0-9a-zA-Z_.");
		ScanSkip (& bufptr, word1, "a-zA-Z0-9_.");

		if (strcmp (word1, func) == 0)
			continue;
		
		for (;;)
		{
			if (* bufptr == '*')
			{
				strcat (word1, " ");
				for (; * bufptr == '*'; bufptr ++)
					strcat (word1, "*");
				strcat (word1, " ");
				Skip (& bufptr, " \t");
			}

			ScanSkip (& bufptr, word2, "0-9a-zA-Z_");
			if (strcmp (word2, func) == 0)
				break;
			
			strcat (word1, " ");
			strcat (word1, word2);
		}

		if (first)
		{
			first = False;
			fprintf (fp, "\t/* %s */\n\n", file);
		}

		fprintf (fp, "extern %-25s %s ();\n", word1, func);
	}

	if (! first)
		fprintf (fp, "\n");

	pclose (pp);
}

main (argc, argv)
int argc;
char ** argv;
{
	FILE * fp;
	char * target = "proto.h";

	extern char * optarg;
	extern int optind;
	extern int getopt ();
	int ch;

	while ((ch = getopt (argc, argv, "vf:c:g:")) != -1)
		switch (ch)
		{

		case 'v':
			verbose = True;
			break;
		
		case 'f':
			target = optarg;
			break;
		
		case 'c':
			ctags = optarg;
			break;
		
		case 'g':
			grep = optarg;
			break;

		default:
			Usage ();
		}

	if (optind >= argc)
		Usage ();

	fp = fopen (target, "w");
	if (fp == (FILE *) 0)
		Error ("can't open %s\n", target);
	
	for (; optind < argc; optind ++)
		MakeProto (fp, argv [optind]);
	
	fclose (fp);
	printf ("%s ready\n", target);
	exit (0);
}
