/*
 *	File: scan.c
 *
 *	Recognizes Subject:
 *		ML ADD (<group>, <name>, <address>)
 *		ML DELETE (<group>, <address>)
 *		ML FW (<group>)
 */

#include "list.h"
#include "message.h"
#include <stdio.h>

#ifndef BUFSIZ
#define	BUFSIZ	1024
#endif BUFSIZ

#define	FMT_ADD		"Subject: ML ADD (%[^,], %[^,], %[^)])"
#define	FMT_DEL		"Subject: ML DELETE (%[^,], %[^)])"
#define	FMT_FW		"Subject: ML FW (%[^,], %[^)])"
#define FMT_FROM	"From: %[^;]"
#define	FMT_HELP	"Subject: ML HELP (%[^)])"

#ifndef True

typedef int bool;

#define		True	1
#define		False	0
#endif

void Scan (list)
List list;
{
	char buffer [BUFSIZ];
	char group [BUFSIZ], name [BUFSIZ], address [BUFSIZ];
	char from [BUFSIZ];
	char subject [BUFSIZ];
	Group gr;
	User user;
	int p [2];
	int pid;

	bool forward, from_set;
	bool found, help;

	char * strstr ();

	forward = False;
	help = False;

	address [0] = name [0] = group [0] = from [0] = '\0';

	while (fgets (buffer, BUFSIZ, stdin))
	{
		if (buffer [0] == '\n')
			break;

		if (sscanf (buffer, FMT_FROM, from) == 1)
			continue;

		if (sscanf (buffer, FMT_FW, group, subject) == 2)
		{
			forward = True;
			continue;
		}

		if (sscanf (buffer, FMT_HELP, address) == 1)
		{
			help = True;
			continue;
		}

		if (strstr (buffer, "ML HELP") != (char *) 0)
		{
			help = True;
			continue;
		}

		if (sscanf (buffer, FMT_ADD, group, name, address) == 3)
		{
			if ((gr = GetGroup (list, group)) == (Group) 0)
			{
				Message (MES_UNKNOWN_GROUP,
					 list,
					 group,
					 address,
					 from);
				break;
			}

			AddUser (list, group, name, address);

			Message (MES_ADDED,
				 list,
				 group,
				 name,
				 address,
				 from);

			break;
		}

		if (sscanf (buffer, FMT_DEL, group, address) == 2)
		{
			if ((gr = GetGroup (list, group)) == (Group) 0)
			{
				Message (MES_UNKNOWN_GROUP,
					 list,
					 group,
					 name,
					 address,
					 from);
				break;
			}

			found = False;
			for (user = FirstUser (gr);
			     user != (User) 0;
			     user = NextUser (gr))
			{
				if (strcmp (UserAddress (user), address) == 0)
				{
					DeleteUser (list, group,
							UserName (user));
					Message (MES_DELETED,
						list,
						group,
						name,
						address,
						from);

					found = True;
					break;
				}
			}

			if (! found)
				Message (MES_UNKNOWN_USER,
					list,
					group,
					name,
					address,
					from);
			continue;
		}
	}

	if (help)
	{
		Message (MES_HELP,
			 list,
			 (char *) 0,
			 (char *) 0,
			 address,
			 from);
		return;
	}

	if (! forward)
		return;
	
	if (pipe (p) < 0)
	{
		perror ("pipe");
		exit (1);
	}

	pid = fork ();

	switch (pid)
	{

	case -1:
		fprintf (stderr, "Fork failed.\n");
		perror ("fork");
		return;
	
	case 0:
		close (0);
		dup (p [0]);
		close (p [0]);
		close (p [1]);
		(void) sprintf (buffer, "ML (%s): %s", group, subject);
		execvp ("mail", SendArgs (list, group, buffer));
		perror ("execvp");
		exit (1);
		/* child */
	
	default:
		close (p [0]);
		while (fgets (buffer, BUFSIZ, stdin))
			(void) write (p [1], buffer, strlen (buffer));
		close (p [1]);
		wait ((int *) 0);
		/* parent */
	}
}
