/*
 * symtab.c
 */

#include "Lpars.h"
#include "symtab.h"

/*
 * This table is searched with simple strcmps. Make sure that abbriviations
 * of longer tokens are put after that longer one. E.g. put "=" AFTER "=="
 * in the table.
 */
SYMTAB special_chars_symtab[] = {
/* Expression keywords */
	{ "*",			TIMES,			T_NONE,    MP_NONE },
	{ "+",			PLUS,			T_NONE,    MP_NONE },
	{ "-",			MINUS,			T_NONE,    MP_NONE },
	{ "/",			DIVIDE,			T_NONE,    MP_NONE },
	{ "==",			EQUALS,			T_NONE,    MP_NONE },
	{ "=",			EQUALS,			T_NONE,    MP_NONE },
	{ "<>",			UNEQUALS,		T_NONE,    MP_NONE },
	{ "!=",			UNEQUALS,		T_NONE,    MP_NONE },
	{ "~",			MATCHES,		T_NONE,    MP_NONE },
	{ "<=",			SMALLER_EQ,		T_NONE,    MP_NONE },
	{ ">=",			LARGER_EQ,		T_NONE,    MP_NONE },
	{ "<",			SMALLER,		T_NONE,    MP_NONE },
	{ ">",			LARGER,			T_NONE,    MP_NONE },
	{ "&&",			AND,			T_NONE,    MP_NONE },
	{ "||",			OR,			T_NONE,    MP_NONE },
	{ "!",			NOT,			T_BOOLEAN, MP_NONE },
	{ "(",			BRACKET_OPEN,		T_NONE,    MP_NONE },
	{ ")",			BRACKET_CLOSE,		T_NONE,    MP_NONE },
	{ "[",			SQUARE_BRACKET_OPEN,	T_SECTOR,  MP_NONE },
	{ "]",			SQUARE_BRACKET_CLOSE,	T_NONE,    MP_NONE },
	{ ",",			COMMA,			T_NONE,    MP_NONE },
	{ ":",			COLON,			T_NONE,    MP_NONE },
	{ "@",			CURRENT,		T_SECTOR,  MP_NONE },

/* Program keywords */
	{ "{",			BEGIN,			T_NONE,    MP_NONE },
	{ "}",			END,			T_NONE,    MP_NONE },

	{ (char *) 0,		0,			T_NONE,	   MP_NONE }
};

SYMTAB text_symtab[] = {

/* Expression keywords */
	{ "and",		AND,		T_NONE,    MP_NONE },
	{ "or",			OR,		T_NONE,    MP_NONE },
	{ "not",		NOT,		T_BOOLEAN, MP_NONE },
	{ "true",		TRUE,		T_BOOLEAN, MP_NONE },
	{ "false",		FALSE,		T_BOOLEAN, MP_NONE },
	{ "round",		ROUND_FUNC,	T_NUMERIC, MP_NONE },
	{ "floor",		FLOOR_FUNC,	T_NUMERIC, MP_NONE },
	{ "ceil",		CEIL_FUNC,	T_NUMERIC, MP_NONE },
	{ "threshold",		THRESHOLD_MOD,	T_NONE,    MP_NONE },
	{ "t",			THRESHOLD_MOD,	T_NONE,    MP_NONE },
	{ "resource",		RESOURCE_MOD,	T_NONE,    MP_NONE },
	{ "r",			RESOURCE_MOD,	T_NONE,    MP_NONE },
	{ "sector",		SECTOR_MOD,	T_SECTOR,  MP_NONE },
	{ "ship",		SHIP_MOD,	T_NONE,    MP_NONE },
	{ "plane",		PLANE_MOD,	T_NONE,    MP_NONE },
	{ "nuke",		NUKE_MOD,	T_NONE,    MP_NONE },

/* Commodity and resource keywords */
	{ "uranium",			URANIUM,	T_NUMERIC, MP_RESO },
	{ "ura",			URANIUM,	T_NUMERIC, MP_RESO },
	{ "food",			FOOD,		T_NUMERIC, MP_COMM },
	{ "gold_dust",			DUST,		T_NUMERIC, MP_COMM },
	{ "dust",			DUST,		T_NUMERIC, MP_COMM },
	{ "oil",			OIL,		T_NUMERIC, MP_COMM },
	{ "iron_ore",			IRON,		T_NUMERIC, MP_COMM },
	{ "iron",			IRON,		T_NUMERIC, MP_COMM },
	{ "uncompensated_workers",	UW,		T_NUMERIC, MP_COMM },
	{ "uw",				UW,		T_NUMERIC, MP_COMM },
	{ "guns",			GUNS,		T_NUMERIC, MP_COMM },
	{ "gold_bars",			BARS,		T_NUMERIC, MP_COMM },
	{ "bars",			BARS,		T_NUMERIC, MP_COMM },
	{ "petroleum",			PETROL,		T_NUMERIC, MP_COMM },
	{ "petrol",			PETROL,		T_NUMERIC, MP_COMM },
	{ "lcms",			LCMS,		T_NUMERIC, MP_COMM },
	{ "lcm",			LCMS,		T_NUMERIC, MP_COMM },
	{ "hcms",			HCMS,		T_NUMERIC, MP_COMM },
	{ "hcm",			HCMS,		T_NUMERIC, MP_COMM },
	{ "shells",			SHELLS,		T_NUMERIC, MP_COMM },
	{ "she",			SHELLS,		T_NUMERIC, MP_COMM },
	{ "radioactive",		RADS,		T_NUMERIC, MP_COMM },
	{ "rads",			RADS,		T_NUMERIC, MP_COMM },

/* Program keywords */
	{ "begin",		BEGIN,			T_NONE, MP_NONE },
	{ "end",		END,			T_NONE, MP_NONE },
	{ "repeat",		REPEAT,			T_NONE, MP_NONE },
	{ "until",		UNTIL,			T_NONE, MP_NONE },
	{ "while",		WHILE,			T_NONE, MP_NONE },
	{ "do",			DO,			T_NONE, MP_NONE },
	{ "if",			IF,			T_NONE, MP_NONE },
	{ "then",		THEN,			T_NONE, MP_NONE },
	{ "else",		ELSE,			T_NONE, MP_NONE },
	{ "loop",		LOOP,			T_NONE, MP_NONE },
	{ "move",		MOVE,			T_NONE, MP_NONE },
	{ "from",		FROM,			T_NONE, MP_NONE },
	{ "where",		WHERE,			T_NONE, MP_NONE },
	{ "via",		VIA,			T_NONE, MP_NONE },
	{ "to",			TO,			T_NONE, MP_NONE },
	{ "designate",		SET_DESIGNATION,	T_NONE, MP_NONE },
	{ "demobilize",		DEMOBILIZE,		T_NONE, MP_NONE },
	{ "demob",		DEMOBILIZE,		T_NONE, MP_NONE },
	{ "no_reserve",		NO_RESERVE,		T_NONE, MP_NONE },
	{ "no",			NO_RESERVE,		T_NONE, MP_NONE },
	{ "enlist",		ENLIST,			T_NONE, MP_NONE },
	{ "convert",		CONVERT,		T_NONE, MP_NONE },
	{ "shoot",		SHOOT,			T_NONE, MP_NONE },
	{ "set_distribute",	SET_DISTRIBUTE,		T_NONE, MP_NONE },
	{ "sdis",		SET_DISTRIBUTE,		T_NONE, MP_NONE },
	{ "set_threshold",	SET_THRESHOLD,		T_NONE, MP_NONE },
	{ "st",			SET_THRESHOLD,		T_NONE, MP_NONE },
	{ "set_cutoff",		SET_CUTOFF,		T_NONE, MP_NONE },
	{ "sc",			SET_CUTOFF,		T_NONE, MP_NONE },
	{ "set_deliver",	SET_DELIVER,		T_NONE, MP_NONE },
	{ "sdel",		SET_DELIVER,		T_NONE, MP_NONE },
	{ "on_fail",		ON_FAIL,		T_NONE, MP_NONE },
	{ "break",		BREAK,			T_NONE, MP_NONE },
	{ "continue",		CONTINUE,		T_NONE, MP_NONE },
	{ "abort",		ABORT,			T_NONE, MP_NONE },
	{ "stop",		STOP,			T_NONE, MP_NONE },
	{ "print",		PRINT,			T_NONE, MP_NONE },
	{ "write",		PRINT,			T_NONE, MP_NONE },
	{ "send",		SEND,			T_NONE, MP_NONE },

/* Sector census values */
	{ "current_sector",	CURRENT,	T_SECTOR,    MP_SECT },
	{ "warehouse",		WAREHOUSE,	T_SECTOR,    MP_SECT },
	{ "bad_sector",		BAD_SECTOR,	T_SECTOR,    MP_SECT },
	{ "xloc",		XLOC,		T_NUMERIC,   MP_ALL  },
	{ "yloc",		YLOC,		T_NUMERIC,   MP_ALL  },
	{ "owner",		OWNER,		T_STRING,    MP_SECT |MP_SHIP },
	{ "designation",	DESIGNATION,	T_CHARACTER, MP_SECT },
	{ "des",		DESIGNATION,	T_CHARACTER, MP_SECT },
	{ "newdesignation",	NEW_DESIG,	T_CHARACTER, MP_SECT },
	{ "newdes",		NEW_DESIG,	T_CHARACTER, MP_SECT },
	{ "efficiency",		EFFICIENCY,	T_NUMERIC,   MP_ALLX },
	{ "eff",		EFFICIENCY,	T_NUMERIC,   MP_ALLX },
	{ "work",		WORK,		T_NUMERIC,   MP_SECT },
	{ "available",		AVAILABLE,	T_NUMERIC,   MP_SECT },
	{ "avail",		AVAILABLE,	T_NUMERIC,   MP_SECT },
	{ "mobility",		MOBILITY,	T_NUMERIC,   MP_ALLX },
	{ "mob",		MOBILITY,	T_NUMERIC,   MP_ALLX },
	{ "civilians",		CIVILIANS,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "civs",		CIVILIANS,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "civ",		CIVILIANS,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "militairs",		MILITARY,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "mils",		MILITARY,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "mil",		MILITARY,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "population",		POPULATION,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "pop",		POPULATION,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "planes",		PLANES,		T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "ships",		SHIPS,		T_NUMERIC,   MP_SECT },
	{ "nukes",		NUKES,		T_NUMERIC,   MP_SECT },
	{ "occupied",		OCCUPIED,	T_BOOLEAN,   MP_SECT },
	{ "occ",		OCCUPIED,	T_BOOLEAN,   MP_SECT },
	{ "owned",		OWNED,		T_BOOLEAN,   MP_SECT |MP_SHIP },
	{ "coast",		COAST,		T_BOOLEAN,   MP_SECT },
	{ "food_used",		FOOD_USED,	T_NUMERIC,   MP_SECT |MP_SHIP },
	{ "starvation",		STARVATION,	T_BOOLEAN,   MP_SECT |MP_SHIP },
	{ "mines",		MINES,		T_NUMERIC,   MP_SECT },
	{ "territory",		TERRITORY,	T_NUMERIC,   MP_SECT },
	{ "terr",		TERRITORY,	T_NUMERIC,   MP_SECT },
	{ "has_plan",		HAS_PLAN,	T_BOOLEAN,   MP_SECT },
	{ "is_active",		IS_ACTIVE,	T_BOOLEAN,   MP_SECT },
	{ "plague",		PLAGUE,		T_BOOLEAN,   MP_SECT },
	{ "plague_stage",	PLAGUE_STAGE,	T_PLAGUE,    MP_SECT },
	{ "pstage",		PLAGUE_STAGE,	T_PLAGUE,    MP_SECT },
 	{ "happy",		HAPPY,		T_BOOLEAN,   MP_SECT },
 	{ "happy_state",	HAPPY_STATE,	T_HAPPY,     MP_SECT },
 	{ "hstate",		HAPPY_STATE,	T_HAPPY,     MP_SECT },

/* Happiness types (heinola@malla.ee.tut.fi) */
 	{ "loyal",		HAPPY_LOYAL,	T_HAPPY,     MP_SECT },
 	{ "unrest",		HAPPY_UNREST,	T_HAPPY,     MP_SECT },
 	{ "revolutionaries",	HAPPY_REVOL,	T_HAPPY,     MP_SECT },
 	{ "revol",		HAPPY_REVOL,	T_HAPPY,     MP_SECT },
 	{ "terrorists",		HAPPY_TERROR,	T_HAPPY,     MP_SECT },
 	{ "terror",		HAPPY_TERROR,	T_HAPPY,     MP_SECT },
 	{ "guerrillas",		HAPPY_GUERRE,	T_HAPPY,     MP_SECT },
 	{ "guerre",		HAPPY_GUERRE,	T_HAPPY,     MP_SECT },
  
/* Plague types */
	{ "healthy",	PLAGUE_HEALTHY,		T_PLAGUE, MP_SECT },
	{ "infected",	PLAGUE_INFECTED,	T_PLAGUE, MP_SECT },
	{ "dying",	PLAGUE_DYING,		T_PLAGUE, MP_SECT },

/* Empire constants */
	{ "secs_per_etu",	SPE,		T_NUMERIC, MP_ALL },
	{ "spe",		SPE,		T_NUMERIC, MP_ALL },
	{ "etus_per_update",	EPU,		T_NUMERIC, MP_ALL },
	{ "epu",		EPU,		T_NUMERIC, MP_ALL },
	{ "interest_rate",	IRATE,		T_NUMERIC, MP_ALL },
	{ "irate",		IRATE,		T_NUMERIC, MP_ALL },
	{ "civ_tax_rate",	CTRATE,		T_NUMERIC, MP_ALL },
	{ "ctrate",		CTRATE,		T_NUMERIC, MP_ALL },
	{ "uw_tax_rate",	UTRATE,		T_NUMERIC, MP_ALL },
	{ "utrate",		UTRATE,		T_NUMERIC, MP_ALL },
	{ "active_mil_cost",	AMCRATE,	T_NUMERIC, MP_ALL },
	{ "amcrate",		AMCRATE,	T_NUMERIC, MP_ALL },
	{ "reserve_mil_cost",	RMCRATE,	T_NUMERIC, MP_ALL },
	{ "rmcrate",		RMCRATE,	T_NUMERIC, MP_ALL },
	{ "fertility_rate",	FRATE,		T_NUMERIC, MP_ALL },
	{ "frate",		FRATE,		T_NUMERIC, MP_ALL },
	{ "harvest_rate",	HRATE,		T_NUMERIC, MP_ALL },
	{ "hrate",		HRATE,		T_NUMERIC, MP_ALL },
	{ "civ_birth_rate",	CBRATE,		T_NUMERIC, MP_ALL },
	{ "cbrate",		CBRATE,		T_NUMERIC, MP_ALL },
	{ "uw_birth_rate",	UBRATE,		T_NUMERIC, MP_ALL },
	{ "ubrate",		UBRATE,		T_NUMERIC, MP_ALL },
	{ "eat_rate",		ERATE,		T_NUMERIC, MP_ALL },
	{ "erate",		ERATE,		T_NUMERIC, MP_ALL },
	{ "baby_eat_rate",	BERATE,		T_NUMERIC, MP_ALL },
	{ "berate",		BERATE,		T_NUMERIC, MP_ALL },

/* Ship types */
	{ "name",	NAME,	T_STRING,    MP_SHIP | MP_PLANE | MP_NUKE },
	{ "type",	TYPE,	T_NUMERIC,   MP_SHIP | MP_PLANE | MP_NUKE },
	{ "technology",	TECH,	T_NUMERIC,   MP_SHIP | MP_PLANE 	  },
	{ "tech",	TECH,	T_NUMERIC,   MP_SHIP | MP_PLANE 	  },
	{ "number",	NUMBER,	T_NUMERIC,   MP_SHIP | MP_PLANE		  },
	{ "fleet",	FLEET,	T_CHARACTER, MP_SHIP           	          },
	{ "radar",	RADAR,	T_NUMERIC,   MP_SHIP			  },
	{ "sonar",	SONAR,	T_NUMERIC,   MP_SHIP			  },
	{ "moves",	MOVES,	T_NUMERIC,   MP_SHIP			  },

/* Plane types */
	{ "wing",	WING,		T_CHARACTER, MP_PLANE   },
	{ "range",	RANGE,		T_NUMERIC,   MP_PLANE   },
	{ "maxrange",	MAXRANGE,	T_NUMERIC,   MP_PLANE   },
	{ "max_range",	MAXRANGE,	T_NUMERIC,   MP_PLANE   },
	{ "attack",	DEFENSE,	T_NUMERIC,   MP_PLANE   },
	{ "defense",	ATTACK,		T_NUMERIC,   MP_PLANE   },
	{ "harden",	HARDEN,		T_NUMERIC,   MP_PLANE   },
	{ "load",	LOAD,		T_NUMERIC,   MP_PLANE   },

/* Nuke types */
	{ "stockpile",	STOCKPILE,	T_NUMERIC,	MP_NUKE	},

	{ (char *) 0,	0,	T_NONE,      MP_NONE }
};
