#include "type.h"
#include "main.h"
#include <sys/file.h>
#include <errno.h>

struct s_str_ent {
	char *str;
	int id;
	bool flag;
	struct s_str_ent *next;
};

typedef struct s_str_ent *StrEnt;

struct s_strings {
	StrEnt *index;
	int nelems;
	int lastid;
	StrEnt head, tail, current;
};

Strings InitStrings ()
{
	Strings new;

	new = (Strings) doalloc ((unsigned) sizeof (struct s_strings));

	new-> nelems = 0;
	new-> current = new-> head = new-> tail = (StrEnt) 0;
	new-> lastid = 0;
	new-> index = (StrEnt *) 0;
	return new;
}

Strings EditStrings (width, height)
int width, height;
{
	Strings strings;
	char *ptr;

	strings = InitStrings ();
	ptr = Fmt ("%*s", width, "");

	while ((height --) > 0)
		AddString (strings, ptr);

	return strings;
}

int StringsSize (strings)
Strings strings;
{
	return strings-> nelems;
}

void JoinStrings (str1, str2)
Strings str1, str2;
{
	StrEnt ptr;

	for (ptr = str2-> head; ptr != (StrEnt) 0; ptr = ptr-> next)
		AddString (str1, ptr-> str);
}

void MarkAllStrings (strings)
Strings strings;
{
	StrEnt ptr;

	for (ptr = strings-> head; ptr != (StrEnt) 0; ptr = ptr-> next)
		ptr-> flag = True;
}

void TmpAddStringID (strings, str, id, sortit)
Strings strings;
char *str;
int id;
bool sortit;
{
	StrEnt ent, ptr, prev;

	if (strings == (Strings) 0)
		return;
	
	if (strings-> index != (StrEnt *) 0)
		FreeStringIndex (strings);

	ent = (StrEnt) doalloc ((unsigned) sizeof (struct s_str_ent));
	ent-> id = id;
	ent-> str = Str (str == (char *) 0 ? "" : str);
	ent-> flag = False;
	ent-> next = (StrEnt) 0;

	strings-> lastid = id;
	strings-> nelems ++;

	if (strings-> head == (StrEnt) 0)
	{
		strings-> head = strings-> tail = ent;
		return;
	}

	if (sortit)
	{
		prev = (StrEnt) 0;
		for (ptr = strings-> head; ptr != (StrEnt) 0 &&
					strcmp (ptr-> str, str) < 0;
					ptr = ptr-> next)
			prev = ptr;
	
		if (prev == (StrEnt) 0) {
			ent->next = strings->head;
			strings->head = ent;
		}
		else
		{
			prev->next = ent;
			ent->next = ptr;
			if (ptr == (StrEnt) 0)
				strings-> tail = ent;
		}
	}
	else
	{
		strings-> tail-> next = ent;
		strings-> tail = ent;
	}
}

void AddStringID (strings, str, id)
Strings strings;
char * str;
int id;
{
	TmpAddStringID (strings, str, id, False);
}

void AddSortStringID (strings, str, id)
Strings strings;
char * str;
int id;
{
	TmpAddStringID (strings, str, id, True);
}

void AddString (strings, str)
Strings strings;
char *str;
{
	AddStringID (strings, str, strings-> lastid + 1);
}

void AddStringsID (strings, strs, n, i)
Strings strings;
char **strs;
int n, i;
{
	int j;

	for (j = 0; j < n; j++)
		AddStringID (strings, strs [j] , j + i);
}

void AddStrings (strings, strs, n)
Strings strings;
char *strs [];
{
	int i;

	for (i = 0; i < n; i++)
		AddString (strings, strs [i]);
}

void FreeStrings (strings)
Strings strings;
{
	StrEnt ent, prv;

	ent = strings-> head;

	while (ent != (StrEnt) 0) {
		free ((char *) ent-> str);
		prv = ent;
		ent = ent-> next;
		free ((char *) prv);
	}

	if (strings-> index != (StrEnt *) 0)
		free ((char *) strings-> index);

	free ((char *) strings);
}

static StrEnt FindStrId (strings, id, prv)
Strings strings;
int id;
StrEnt *prv;
{
	StrEnt ptr, prvptr;

	prvptr = (StrEnt) 0;
	for (ptr = strings-> head; ptr != (StrEnt) 0; ptr = ptr-> next)
	{ 
		if (ptr-> id == id)
		{
			if (prv != (StrEnt *) 0)
				*prv = prvptr;

			return ptr;
		}

		prvptr = ptr;
	}

	if (prv != (StrEnt *) 0)
		*prv = (StrEnt) 0;

	return (StrEnt) 0;
}

void ChangeString (strings, id, newstr)
Strings strings;
int id;
char *newstr;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);
	if (ent != (StrEnt) 0)
	{
		free ((char *) ent-> str);
		ent-> str = Str (newstr);
	}
}

void SetStringFlag (strings, id, flag)
Strings strings;
int id;
bool flag;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);
	if (ent != (StrEnt) 0)
		ent-> flag = flag;
}

bool GiveStringFlag (strings, id)
Strings strings;
int id;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);
	if (ent != (StrEnt) 0)
		return ent-> flag;
	return False;
}

void ToggleStringFlag (strings, id)
Strings strings;
int id;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);
	if (ent != (StrEnt) 0)
		ent-> flag = ! ent-> flag;
}

	
char *GiveIdString (strings, id)
Strings strings;
int id;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);

	if (ent != (StrEnt) 0)
		return ent-> str;
	else
		return (char *) 0;
}
	
bool GiveIdFlag (strings, id)
Strings strings;
int id;
{
	StrEnt ent;

	ent = FindStrId (strings, id, (StrEnt *) 0);

	return (ent != (StrEnt) 0) && ent-> flag;
}
	
char * GetFirstString (strings)
Strings strings;
{
	if (strings-> head == (StrEnt) 0)
		return (char *) 0;
	
	return strings-> head-> str;
}

void DeleteFirstString (strings)
Strings strings;
{
	StrEnt ptr;

	ptr = strings-> head;
	if (ptr == (StrEnt) 0)
		return;
	
	free (ptr-> str);
	if (strings-> tail == ptr)
	{
		strings-> head = strings-> tail = (StrEnt) 0;
		if (strings-> nelems != 1)
			Panic ("DeleteFirstString", "strings.c",
				"strings not empty !!");

		strings-> nelems = 0;
		free ((char *) ptr);
		return;
	}

	strings-> head = ptr-> next;
	strings-> nelems --;
	free ((char *) ptr);
}
	
void DeleteString (strings, id)
Strings strings;
int id;
{
	StrEnt ent, prv;

	if (strings-> index != (StrEnt *) 0)
		FreeStringIndex (strings);

	ent = FindStrId (strings, id, & prv);

	if (ent != (StrEnt) 0) {

		free ((char *) ent-> str);

		strings-> nelems --;

		if (ent == strings-> tail)
			strings-> tail = prv;

		if (prv == (StrEnt) 0)
			strings-> head = ent-> next;
		else
			prv-> next = ent-> next;

		free ((char *) ent);
	}
	else
		Panic ("DeleteString", "strings.c",
					"string to delete not found");
}

void InitStringList (strings)
Strings strings;
{
	strings-> current = strings-> head;
}

char *GetNextString (strings)
Strings strings;
{
	char *ptr;

	if (strings-> current == (StrEnt) 0)
		return (char *) 0;

	ptr = strings-> current-> str;
	strings-> current = strings-> current-> next;

	return ptr;
}

char * GetNextStringID (strings, id)
Strings strings;
int * id;
{
	if (strings-> current == (StrEnt) 0)
		return (char *) 0;

	* id = strings-> current-> id;

	return GetNextString (strings);
}

char *GetNextStringFlag (strings, flag)
Strings strings;
bool *flag;
{
	char *ptr;

	if (strings-> current == (StrEnt) 0)
		return (char *) 0;

	ptr = strings-> current-> str;
	*flag = strings-> current-> flag;
	strings-> current = strings-> current-> next;

	return ptr;
}

char *GetNextSelectedString (strings)
Strings strings;
{
	char *ptr;

	while (strings-> current != (StrEnt) 0 &&
				       ! strings-> current-> flag)
		strings-> current = strings-> current-> next;
	
	if (strings-> current == (StrEnt) 0)
		return (char *) 0;
	
	ptr = strings-> current-> str;
	strings-> current = strings-> current-> next;

	return ptr;
}

int GetNextSelectedId (strings)
Strings strings;
{
	int ret;

	while (strings-> current != (StrEnt) 0 &&
				       ! strings-> current-> flag)
		strings-> current = strings-> current-> next;
	
	if (strings-> current == (StrEnt) 0)
		return -1;
	
	ret = strings-> current-> id;
	strings-> current = strings-> current-> next;

	return ret;
}

	/*
	 *	WriteStrings (strings, file)
	 *
	 *	Writes strings into the file "file". When it succeeds
	 *	it returnes True, else False.
	 */

bool WriteStrings (strings, file)
Strings strings;
char *file;
{
	FILE *fp;
	char *ptr;
	bool append, force;
	extern char *sys_errlist[];

	append = force = False;
	SkipBlank (&file);
	if (*file == '>')
	{
		append = True;
		file++;
	}
	else if (*file == '!')
	{
		force = True;
		file++;
	}
		
	file = FileStr (file);

	if (access (file, W_OK) < 0) {
		if (errno != ENOENT || append)
		{
			Error (Fmt ("Can't open file %s for writing : %s", file,
				sys_errlist [errno]));
			return False;
		}
	}
	else if (! force && ! append)
	{
		Error (Fmt ("file %s exists", file));
		return False;
	}
	fp = fopen (file, append ? "a" : "w");

	if (fp == (FILE *) 0)
	{
		Error (Fmt ("Can't open file %s for writing : %s", file,
			sys_errlist [errno]));
		return False;
	}

	InitStringList (strings);

	while ((ptr = GetNextString (strings)) != (char *) 0)
		fprintf (fp, "%s\n", ptr);

	fclose (fp);

	return True;
}

bool LoadStrings (strings, file)
Strings strings;
char * file;
{
	FILE * fp;
	char buffer[BUFSIZ];
	extern char *sys_errlist[];

	file = FileStr (file);

	if (access (file, R_OK) < 0)
	{
		Error (Fmt ("Can't open file %s for reading : %s", file,
			sys_errlist [errno]));
		return False;
	}

	fp = fopen (file, "r");

	if (fp == (FILE *) 0)
	{
		Error (Fmt ("Can't open file %s for reading : %s", file,
			sys_errlist [errno]));
		return False;
	}

/* 
 * 	if (strings-> index != (StrEnt *) 0)
 * 		FreeStringIndex (strings);
 * 
 * 	MakeStringIndex (strings);
 * 	
 */
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0) {
		NoNl (buffer);
		AddString (strings, buffer);
	}
/* 
 * 		p = buffer;
 * 		if ((end = index (buffer, '\n')) == 0)
 * 			end = buffer + BUFSIZ - 1;
 * 
 * 		*end = '\0';
 * 		while (p < end) {
 * 			old = GiveIthString (strings, nr);
 * 			len = strlen (old);
 * 			sprintf (old, "%-*.*s", len, len , p);
 * 			p += len;
 * 			if (++nr == strings-> nelems) {
 * 				fclose (fp);
 * 				return True;
 * 			}
 * 				
 * 		}
 * 	}
 * 
 */
	fclose (fp);

	return True;
}

int MaxStringLen (strings)
Strings strings;
{
	register char *ptr;
	register int max;

	max = 0;

	InitStringList (strings);

	while ((ptr = GetNextString (strings)) != (char *) 0)
		if (strlen (ptr) > max)
			max = strlen (ptr);

	return max;
}

void FreeStringIndex (strings)
Strings strings;
{
	if (strings-> index != (StrEnt *) 0)
	{
		free ((char *) strings-> index);
		strings-> index = (StrEnt *) 0;
	}
}

void MakeStringIndex (strings)
Strings strings;
{
	int i;
	StrEnt sptr;

	if (strings-> index != (StrEnt *) 0)
		return;
/* 
 * 		FreeStringIndex (strings);
 */

	strings-> index = (StrEnt *) doalloc ((unsigned) strings-> nelems *
						  sizeof (char *));

	for (sptr = strings-> head, i = 0; sptr != (StrEnt) 0;
				sptr = sptr-> next, i++)
		strings-> index [i] = sptr;
}

char *GiveIthString (strings, i)
Strings strings;
int i;
{
	return strings-> index [i]-> str;
}

int GiveIthID (strings, i)
Strings strings;
int i;
{
	return strings-> index [i]-> id;
}

bool GiveIthFlag (strings, i)
Strings strings;
int i;
{
	return strings-> index [i]-> flag;
}

void SetIthFlag (strings, i, flag)
Strings strings;
int i;
bool flag;
{
	strings-> index [i]-> flag = flag;
}

Strings ReadStrings (fp)
FILE *fp;
{
	Strings strings;
	char buffer [BUFSIZ];

	strings = InitStrings ();
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		buffer [strlen (buffer) - 1] = '\0';
		AddString (strings, buffer);
	}
	
	return strings;
}

void DumpStrings (strings)
Strings strings;
{
	char *ptr;

	InitStringList (strings);

	while ((ptr = GetNextString (strings)) != (char *) 0)
		printf ("%s\n", ptr);
}

bool LoadEditStrings (strings, file)
Strings strings;
char *file;
{
	FILE *fp;
	char buffer[BUFSIZ];
	int i;
	extern char *sys_errlist[];

	file = FileStr (file);

	if (access (file, R_OK) < 0)
	{
		Error (Fmt ("Can't open file %s for reading : %s", file,
			sys_errlist [errno]));
		return False;
	}

	fp = fopen (file, "r");

	if (fp == (FILE *) 0)
	{
		Error (Fmt ("Can't open file %s for reading : %s", file,
			sys_errlist [errno]));
		return False;
	}

	while (StringsSize (strings) > 0)
		DeleteFirstString (strings);

	i = 0;
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0) 
	{
		NoNl (buffer);
		i ++;
		AddString (strings, Fmt ("%-80.80s", DelTabs (buffer)));
	}

	while (i < 24)
	{
		AddString (strings, Fmt ("%-80.80s", ""));
		i ++;
	}

	fclose (fp);

	return True;
}

Strings StripStrings (strings)
Strings strings;
{
	StrEnt last_ent, next;
	Strings res;
	char *ptr, *ptr2;

	res = InitStrings ();
	InitStringList (strings);
	last_ent = (StrEnt) 0;
	while ((ptr = GetNextString (strings)) != (char *) 0)
	{
		ptr = Str (ptr);
		ptr2 = ptr + strlen (ptr) - 1;
		while ((* ptr2 == ' ') && (ptr2 > ptr))
			* (ptr2 --) = '\0';

		if (* ptr2 == ' ')		/* first char */
			* ptr2 = '\0';

		AddString (res, ptr);
		if (* ptr != '\0')
			last_ent = res-> tail;
		free (ptr);
	}

	if (last_ent == (StrEnt) 0)
		return res;
	
	next = last_ent-> next;
	res-> tail = last_ent;
	last_ent-> next = (StrEnt) 0;
	last_ent = next;

	while (last_ent != (StrEnt) 0)
	{
		res-> nelems --;
		next = last_ent-> next;
		free (last_ent);
		last_ent = next;
	}

	return res;
}

Strings PopenStrings (command)
char * command;
{
	FILE * pp;
	Strings strings;
	char buf [300];
	int id;

	id = 0;
	strings = InitStrings ();
	pp = popen (command, "r");
	if (pp == (FILE *) 0)
		return strings;
	
	while (fgets (buf, 300, pp) != (char *) 0)
	{
		NoNl (buf);
		AddStringID (strings, buf, id ++);
	}
	
	pclose (pp);

	return strings;
}
