#ifndef _CENSUS
#define _CENSUS

#ifdef TERMC_VERSION

	/*
	 *	Normal Layout
	 */

#define NL_SY_SCT	0
#define	NL_SY_CENSUS	3
#define	NL_SY_RESOUR	5
#define	NL_SY_CRAFTS	7

#define NL_SY_DISTR	9
#define	NL_SY_COMM	10

#define	NL_SY_BUT	23
#define	NL_SX_SHIP	1
#define	NL_SX_INFO	7
#define NL_SX_NUKE	13
#define	NL_SX_PLANE	20

	/*
	 *	Additional layout
	 */

#define	NL_SY_ADDIT	10

#define AL_SY_BUT	23
#define	AL_SX_SECTOR	11

#define NL_ADDIT_LINES	6

	/*
	 *	Ship layout
	 */

#define SL_SY_TYPE	6
#define SL_SY_NAME	7
#define	SL_SY_FERRY	8
#define	SL_SY_OWNER	9

#define SL_SY_STATS	10
#define	SL_SY_COM	14

#define SL_SY_BUT	19
#define	SL_SX_SECTOR	1
#define	SL_SX_FLEET	11
#define	SL_SX_NEXT	19

#define SL_SY_FUNCBUT	21



	/*
	 *	Fleet layout
	 */

#define FL_MAX_SHIPS	5

#define FL_SY_FLEET	6
#define FL_SY_POS	7
#define	FL_SY_FERRY	8

#define	FL_SY_HEADER	10
#define FL_SY_SHIPS	12

#define FL_SY_BUT	18

#define FL_SX_SECTOR	1
#define FL_SX_MORE	10
#define FL_SX_NEXT	19

	/*
	 *	Plane layout
	 */

#define PL_SY_NAME	7
#define	PL_SY_POS	8
#define	PL_SY_WING	9
#define PL_SY_NUMBER	10

#define	PL_SY_STATS	12

#define	PL_SY_BUT	18
#define	PL_SX_SECTOR	1
#define	PL_SX_WING	10
#define	PL_SX_NEXT	19

#define	PL_SY_FUNCBUT	20
	
	/*
	 *	Wing layout
	 */

#define WL_MAX_PLANES	6

#define WL_SY_WING	6
#define	WL_SY_POS	7
#define	WL_SY_HEADER	9
#define WL_SY_PLANES	11

#define WL_SY_BUT	18
#define WL_SX_SECTOR	1
#define	WL_SX_MORE	10
#define WL_SX_NEXT	19

	/*
	 *	Nuke layout
	 */

#define NKL_SY_NR	6
#define NKL_SY_NUKES	8

#define	NKL_SY_BUT	20
#define	NKL_SX_SHIP	1
#define NKL_SX_SECTOR	10
#define	NKL_SX_PLANE	20

#define NKL_SY_FUNCBUT	22

#define NKL_MAX_NUKES	7

	/*
	 *	Plan Layout
	 */

#define	SL_PLAN_START	7
#define	SL_PLAN_CIVS	12
#define	SL_PLAN_THRESH	17

#else
	/*
	 *	X version
	 *
	 *	Normal layout
	 */

#define NL_SY_SCT	1
#define	NL_SY_CENSUS	3
#define	NL_SY_RESOUR	6
#define	NL_SY_CRAFTS	9

#define NL_SY_DISTR	11
#define	NL_SY_COMM	13

#define	NL_SY_BUT	27
#define	NL_SX_SHIP	2
#define NL_SX_NUKE	10
#define	NL_SX_PLANE	19

#define	NL_SY_ADDIT	29
#define NL_ADDIT_LINES	6

	/*
	 *	Ships layout
	 */

#define SL_SY_TYPE	15
#define SL_SY_NAME	16
#define	SL_SY_OWNER	17
#define	SL_SY_FERRY	21

#define SL_SY_STATS	18
#define	SL_SY_COM	23

#define SL_SY_BUT	28

#define	SL_SX_SECTOR	1
#define	SL_SX_FLEET	11
#define	SL_SX_NEXT	20

#define	SL_SY_FUNCBUT	(CENSUS_HEIGHT - 4)

	/*
	 *	Fleet layout
	 */

#define FL_MAX_SHIPS	(CENSUS_HEIGHT - 28)

#define FL_SY_FLEET	16
#define FL_SY_POS	17
#define	FL_SY_FERRY	18

#define	FL_SY_HEADER	20
#define FL_SY_SHIPS	21

#define FL_SY_BUT	(CENSUS_HEIGHT - 6)
#define FL_SX_SECTOR	2
#define FL_SX_MORE	10
#define FL_SX_NEXT	20

	/*
	 *	Plane layout
	 */
	
#define PL_SY_NAME	16
#define	PL_SY_POS	17
#define	PL_SY_WING	18
#define PL_SY_NUMBER	19

#define	PL_SY_STATS	21

#define	PL_SY_BUT	26
#define	PL_SX_SECTOR	1
#define	PL_SX_WING	11
#define	PL_SX_NEXT	20

#define	PL_SY_FUNCBUT	(CENSUS_HEIGHT - 4)

	/*
	 *	Wing layout
	 */

#define WL_MAX_PLANES	(CENSUS_HEIGHT - 27)

#define WL_SY_WING	16
#define	WL_SY_POS	17
#define	WL_SY_HEADER	19
#define WL_SY_PLANES	20

#define WL_SY_BUT	(CENSUS_HEIGHT - 6)

#define WL_SX_SECTOR	1
#define	WL_SX_MORE	10
#define WL_SX_NEXT	19

	/*
	 *	Nuke layout
	 */

#define NKL_SY_NR	16
#define NKL_SY_NUKES	18

#define	NKL_SY_BUT	27
#define	NKL_SX_SHIP	2
#define NKL_SX_SECTOR	10
#define	NKL_SX_PLANE	19

#define NKL_SY_FUNCBUT	29

#define NKL_MAX_NUKES	8

	/*
	 *	Plan Layout
	 */

#define	SL_PLAN_START	16
#define	SL_PLAN_CIVS	21
#define	SL_PLAN_THRESH	26

#endif /* VERSION */

struct s_funcbutton
{
	int id;
	char * name;
	int x, y;
	int len;
};

#endif /* _CENSUS */
