#include "type.h"
#include "var.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

struct  dchrstr dchr[SCT_MAXDEF+2]  =
{
/*    mnem pr.   mcst  fl.  pkg ostr dstr value nam.  */
	'.', 0,        0, NAVOK,  NPKG,  0,   0,   0, "sea",
	'^', 0,      127, 0,      NPKG,  2,  16,   5, "mountain",
	's', 0,        0, 0,      NPKG,  0,  99, 127, "sanctuary",
	'\\',0,        0, 0,      NPKG,  0,  99,   0, "wasteland",
	'-', 0,        4, 0,      NPKG,  2,   2,   1, "wilderness",
	'c', 0,        2, 0,      NPKG,  2,   4,  30, "capital",
	'u', P_URAN,   2, 0,      NPKG,  2,   3,  15, "uranium mine",
	'p', P_HLEV,   2, 0,      NPKG,  2,   2,   5, "park",
	'd', P_GUN,    2, 0,      NPKG,  2,   2,   7, "defense plant",
	'i', P_SHELL,  2, 0,      NPKG,  2,   2,   6, "shell industry",
	'm', P_IRON,   2, 0,      NPKG,  2,   3,   5, "mine",
	'g', P_DUST,   2, 0,      NPKG,  2,   3,   8, "gold mine",
	'h', 0,        2, NAV_02, NPKG,  2,   2,  12, "harbor",
	'w', 0,        2, 0,      WPKG,  2,   2,   7, "warehouse",
	'*', 0,        2, 0,      NPKG,  2,   1,  12, "airfield",
	'a', P_FOOD,   2, 0,      NPKG,  2,   2,   2, "agribusiness",
	'o', P_OIL,    2, 0,      NPKG,  2,   2,   5, "oil field",
	'j', P_LCM,    2, 0,      NPKG,  2,   2,   3, "light manufacturing",
	'k', P_HCM,    2, 0,      NPKG,  2,   2,   4, "heavy manufacturing",
	'f', 0,        2, 0,      NPKG,  4,   8,  10, "fortress",
	't', P_TLEV,   2, 0,      NPKG,  2,   2,  10, "technical center",
	'r', P_RLEV,   2, 0,      NPKG,  2,   2,   9, "research lab",
	'n', 0,        2, 0,      NPKG,  2,   3,  10, "nuclear plant",
	'l', P_ELEV,   2, 0,      NPKG,  2,   2,   4, "library/school",
	'+', 0,        1, 0,      NPKG,  1,   1,   3, "highway",
	')', 0,        2, 0,      NPKG,  2,   2,   4, "radar installation",
	'!', 0,        2, 0,      NPKG,  2,   2,   1, "weather stn (useless)",
	'#', 0,        2, 0,      NPKG,  2,   2,   4, "bridge head",
	'=', P_FOOD,   1, NAV_60, NPKG,  1,   1,   5, "bridge span",
	'b', P_BAR,    2, 0,      BPKG,  2,   3,  10, "bank",
	'%', P_PETROL, 2, 0,      NPKG,  2,   2,   2, "refinery",
	'e', 0,        2, 0,      NPKG,  2,   3,   7, "enlistment center",
	'?', 0,      500, 0,      0,     0,   0,   0, "unknown",
	0,   0,        0, 0,      0,     0,   0,   0, 0,
};

char *DesignName (mnem)
char mnem;
{
	register struct dchrstr *ptr;

	for (ptr = dchr; ptr-> d_mnem != '\0'; ptr ++)
		if (ptr-> d_mnem == mnem)
			return ptr-> d_name;
	
	return (char *) 0;
}

#define	MIN(x,y)		((x) > (y) ? (y) : (x))

char CharOfDesigName (desig)
char *desig;
{
	register struct dchrstr *ptr;
	int len;

	len = strlen (desig);
	for (ptr = dchr; ptr-> d_mnem != '\0'; ptr ++)
		if (strncmp (ptr-> d_name, desig,
					MIN (len, strlen (ptr-> d_name))) == 0)
			return ptr-> d_mnem;

	return '\0';
}

bool AllowNavigate (sct)
Sector sct;
{
	register struct dchrstr *ptr;
	register char mnem;

	mnem = s_des (sct);
	for (ptr = dchr; ptr-> d_mnem != '\0'; ptr ++)
		if (ptr-> d_mnem == mnem)
			switch (ptr-> d_flg)
			{

			case NAVOK:
				return True;

			case NAV_60:
				return s_eff (sct) >= 60;

			case NAV_02:
				return s_eff (sct) >= 2;

			default:
				return False;
			}

	return False;
}

double MoveCost (des, eff)
char des;
int eff;
{
	register struct dchrstr *ptr;

	for (ptr = dchr; ptr-> d_mnem != '\0'; ptr ++)
		if (ptr-> d_mnem == des)
			return (double) (ptr-> d_mcst * 100 - eff) / 500.0;

	return (double) 1000.0;
}

double EffPathCost (sct, path)
Sector sct;
char *path;
{
	double res;

	res = 0.0;
	if (path == (char *) 0)
		return -1.0;

	while (*path != 'h' && *path != '_' && *path != '\0')
	{
		sct = MoveInDirection (sct, *path, S_EXIST);
		if (sct == (Sector)0 || ! s_owned (sct))
			return -1.0;
		res += MoveCost (s_nds (sct), 100);
		path ++;
	}
	return res;
}

double RealPathCost (sct, path)
Sector sct;
char *path;
{
	double res;

	res = 0.0;
	if (path == (char *) 0)
		return -1.0;

	while (*path != 'h' && *path != '_' && *path != '\0')
	{
		sct = MoveInDirection (sct, *path, S_EXIST);
		if (sct == (Sector) 0 || ! s_owned (sct))
			return -1.0;
		res += MoveCost (s_des (sct), s_eff (sct));
		path ++;
	}
	return res;
}

static char last_design;

	/* ARGSUSED */
 /*
void MultiDesignate (x, y)
int x, y;
{
}
*/
void RedoDesignate ()
{
	if (last_design == 'h' || last_design == '#')
	{
		if (! IsCoast (cursct))
		{
			Message (Fmt ("%ss must be build near water !",
					DesignName (last_design)));
			Bell ();
			return;
		}
	}

	DoDesignate (CrdStr (cursct), last_design);
	DrawSector (cursct);
	Message (Fmt ("%s is now a %c", CrdStr (cursct), last_design));
}

void DoDesignate (realm, des)
char * realm;
char des;
{
	int sx, sy, ex, ey;
	register int x, y;
	register Sector sct;
	int nr;

	if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
	{	
		Panic ("DoDesignate", "commands/design.c",
			"Illegal realm");
		return;
	}

	last_design = des;
	SetAgain (RedoDesignate);

	nr = 0;
	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x++)
		{
			sct = World (x, y, S_EXIST);

			if (sct == (Sector) 0) {

			 /* we are editing map */
			  if ((x + y) % 2 == 0)
			    {
			      sct = World (x, y, S_DESIG);
			      set_owner (sct, UNKNOWN_CNUM);
			      set_des (sct, des);
			      sct->inf=DES; /* should make macro */
				continue;
			    }
			    else
			      {
				continue;
			      }
			}
			if (NO_INFO(sct))
			  {
			    sct->inf=DES; /* should make macro */
			    set_des (sct, SCT_UNKNOW);
			  }
			if (! s_owned (sct) && ! deity) {
			  set_des (sct, des);
			  continue;
			  } 
			if (s_nds (sct) == des)
				continue;
			nr ++;
			set_nds (sct, des);

			if (s_eff (sct) < 5 || deity)
			{
				set_des (sct, des);
				set_eff (sct, 0);
			}
	
			if (AtScreen (x, y))
				DrawSector (sct);
		}

	if (nr == 0)
		Message ("No affected sectors");
	else
	{
		if (nr > 1)
			Message (Fmt ("%d sectors redesignated", nr));
		FeedCommand (Fmt ("designate %s %c", realm, des), PRINT);
	}
}

void BindDesignate (x, y, str)
int x, y;
char * str;
{
	char design [40];
	char des;

	if (str == (char *) 0 || sscanf (str, " ( %[^)]", design) == 0)
		Design (cursct, x, y);
	
	while (str [strlen (design) - 1] == ' ')
		str [strlen (design) - 1] = '\0';
	
	if (strlen (design) == 1)
	{
		if (DesignName (design [0]) == (char *) 0)
		{
			Message (
			"Illegal designation in binding: 'designate (mnem)'");
			Bell ();
			return;
		}
		des = * design;
	}
	else
	{
		if ((des = CharOfDesigName (design)) == '\0')
		{
			Message (
			"Illegal designation in binding: 'designate (name)'");
			Bell ();
			return;
		}
	}

	if (! IsCoast (cursct) && (des == 'h' || des == '#'))
	{
		Message (Fmt ("%ss must be build near water",
							DesignName (des)));
		Bell ();
		return;
	}

	if ((cursct-> des == '#') && 
	    ! Confirm( "Redesignate bridge head?", False)) {
	   Message (Fmt ("Bridge head not redesignated."));
	   return;
	}

	DoDesignate (CrdStr (cursct), des);
	Message (Fmt ("%s is now a %s", CrdStr (cursct), DesignName (des)));
	DrawSector (cursct);
}

void HelpDesignate (x, y, i)
int x, y, i;
{
	Help (x, y, Fmt ("des %c", dchr [i]. d_mnem));
}

void Design (sct, x, y)
Sector sct;
int x, y;
{
	Strings strings;
	Pager pager;
	int r;

	extern bool deity;
	extern WinInfo map_win;

	extern bool IsCoast (), NearSeaOrHarbor ();	/* sector.c */

	strings = InitStrings ();

	/* we are expressing external info here */ 
	/*
	if  (!deity && (s_des (sct) == '.' || s_des (sct) == '^' ||
			s_des (sct) == 's' || s_des (sct) == '\\'))
	{
		Error (Fmt ("Cannot redesignate %s", DesignName (s_des (sct))));
		return;
	}
	*/

	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AIRPT]. d_mnem,
				dchr [SCT_AIRPT]. d_name), SCT_AIRPT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AGRI]. d_mnem,
				dchr [SCT_AGRI]. d_name), SCT_AGRI);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_BANK]. d_mnem,
				dchr [SCT_BANK]. d_name), SCT_BANK);

	if (IsCoast (sct) || !s_owned (sct))
	  
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_BHEAD]. d_mnem,
					dchr [SCT_BHEAD]. d_name), SCT_BHEAD);


	if (deity || !s_owned (sct))
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_BSPAN]. d_mnem,
					dchr [SCT_BSPAN]. d_name), SCT_BSPAN);

	AddStringID (strings, Fmt ("%c %s", dchr [SCT_CAPIT]. d_mnem,
				dchr [SCT_CAPIT]. d_name), SCT_CAPIT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_ARMSF]. d_mnem,
				dchr [SCT_ARMSF]. d_name), SCT_ARMSF);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_ENLIST]. d_mnem,
				dchr [SCT_ENLIST]. d_name), SCT_ENLIST);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_FORTR]. d_mnem,
				dchr [SCT_FORTR]. d_name), SCT_FORTR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_GMINE]. d_mnem,
				dchr [SCT_GMINE]. d_name), SCT_GMINE);

	if (IsCoast (sct) || !s_owned (sct))
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_HARBR]. d_mnem,
					dchr [SCT_HARBR]. d_name), SCT_HARBR);

	AddStringID (strings, Fmt ("%c %s", dchr [SCT_HEAVY]. d_mnem,
				dchr [SCT_HEAVY]. d_name), SCT_HEAVY);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_HIWAY]. d_mnem,
				dchr [SCT_HIWAY]. d_name), SCT_HIWAY);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_LIBR]. d_mnem,
				dchr [SCT_LIBR]. d_name), SCT_LIBR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_LIGHT]. d_mnem,
				dchr [SCT_LIGHT]. d_name), SCT_LIGHT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_MINE]. d_mnem,
				dchr [SCT_MINE]. d_name), SCT_MINE);
	if (deity || !s_owned (sct))
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_MOUNT]. d_mnem,
					dchr [SCT_MOUNT]. d_name), SCT_MOUNT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_NUKE]. d_mnem,
				dchr [SCT_NUKE]. d_name), SCT_NUKE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_OIL]. d_mnem,
				dchr [SCT_OIL]. d_name), SCT_OIL);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_PARK]. d_mnem, 
				dchr [SCT_PARK]. d_name), SCT_PARK);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RADAR]. d_mnem, 
				dchr [SCT_RADAR]. d_name), SCT_RADAR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_REFINE]. d_mnem, 
				dchr [SCT_REFINE]. d_name), SCT_REFINE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RSRCH]. d_mnem, 
				dchr [SCT_RSRCH]. d_name), SCT_RSRCH);
	if (deity || !s_owned (sct))
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_SANCT]. d_mnem, 
					dchr [SCT_SANCT]. d_name), SCT_SANCT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AMMOF]. d_mnem, 
				dchr [SCT_AMMOF]. d_name), SCT_AMMOF);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_TECH]. d_mnem, 
				dchr [SCT_TECH]. d_name), SCT_TECH);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_URAN]. d_mnem, 
				dchr [SCT_URAN]. d_name), SCT_URAN);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_WAREH]. d_mnem, 
				dchr [SCT_WAREH]. d_name), SCT_WAREH);

	if (deity || !s_owned (sct))
	{
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_WASTE]. d_mnem, 
					dchr [SCT_WASTE]. d_name), SCT_WASTE);
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_WATER]. d_mnem, 
					dchr [SCT_WATER]. d_name), SCT_WATER);
		AddStringID (strings, Fmt ("%c %s", dchr [SCT_UNKNOW]. d_mnem, 
					dchr [SCT_UNKNOW]. d_name), SCT_UNKNOW);
	}

	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RURAL]. d_mnem, 
				dchr [SCT_RURAL]. d_name), SCT_RURAL);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_MAXDEF+1]. d_mnem, 
				dchr [SCT_MAXDEF+1]. d_name), SCT_MAXDEF+1);

	pager = InitPager (strings, "New designation ?");
	SetInfoOnPager (pager, HelpDesignate);
	MapPagerFromTop (pager, map_win, x, y);

	r = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (r < 0)
	{
		Message ("Designate cancelled");
		return;
	}

	if ((sct-> des == '#') && 
	    ! Confirm( "Redesignate bridge head?", False)) {
	   Message (Fmt ("Bridge head not redesignated."));
	   return;
	}

	if (dchr [r]. d_mnem == 0)
	{
		if (!Confirm ("Remove all sector info", False))
		{
			Message ("Sector info not removed.");
			return;
		}
		else
		{
			FreeSector (sct);
			sct = World (0, 0, S_EXIST);
			cursct = sct;
		}
	}
	else
	{
		DoDesignate (CrdStr (sct), dchr [r]. d_mnem);
		Message (Fmt ("%d,%d is now a %s", s_xcd (sct),
			s_ycd (sct), dchr [r]. d_name));
	}

	DrawSector (sct);
	Census ();
}
	/* returns the packing of the sector */

int SectorPacking (des)
char des;
{
	struct dchrstr *ptr;

	for (ptr = dchr; ptr-> d_mnem != '\0'; ptr ++)
		if (ptr-> d_mnem == des)
			return ptr-> d_pkg;
	
	return NPKG;
}


/* Fast hack. - heinola 9/11/91. */
void MultiDesignate (x, y)
int x, y;    
{
        char *realm;
        Strings strings;
	Pager pager;
	int r;
	extern bool deity;
	extern WinInfo map_win;
	extern bool IsCoast (), NearSeaOrHarbor ();	/* sector.c */

	Message ("Select realm to designate");
	if ((realm = MySelRealm ()) == (char *) 0) 
	  {
	    return;	
	  }
	
	strings = InitStrings ();

	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AIRPT]. d_mnem,
				dchr [SCT_AIRPT]. d_name), SCT_AIRPT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AGRI]. d_mnem,
				dchr [SCT_AGRI]. d_name), SCT_AGRI);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_BANK]. d_mnem,
				dchr [SCT_BANK]. d_name), SCT_BANK);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_BHEAD]. d_mnem,
					dchr [SCT_BHEAD]. d_name), SCT_BHEAD);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_BSPAN]. d_mnem,
					dchr [SCT_BSPAN]. d_name), SCT_BSPAN);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_CAPIT]. d_mnem,
				dchr [SCT_CAPIT]. d_name), SCT_CAPIT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_ARMSF]. d_mnem,
				dchr [SCT_ARMSF]. d_name), SCT_ARMSF);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_ENLIST]. d_mnem,
				dchr [SCT_ENLIST]. d_name), SCT_ENLIST);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_FORTR]. d_mnem,
				dchr [SCT_FORTR]. d_name), SCT_FORTR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_GMINE]. d_mnem,
				dchr [SCT_GMINE]. d_name), SCT_GMINE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_HARBR]. d_mnem,
					dchr [SCT_HARBR]. d_name), SCT_HARBR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_HEAVY]. d_mnem,
				dchr [SCT_HEAVY]. d_name), SCT_HEAVY);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_HIWAY]. d_mnem,
				dchr [SCT_HIWAY]. d_name), SCT_HIWAY);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_LIBR]. d_mnem,
				dchr [SCT_LIBR]. d_name), SCT_LIBR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_LIGHT]. d_mnem,
				dchr [SCT_LIGHT]. d_name), SCT_LIGHT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_MINE]. d_mnem,
				dchr [SCT_MINE]. d_name), SCT_MINE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_MOUNT]. d_mnem,
					dchr [SCT_MOUNT]. d_name), SCT_MOUNT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_NUKE]. d_mnem,
				dchr [SCT_NUKE]. d_name), SCT_NUKE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_OIL]. d_mnem,
				dchr [SCT_OIL]. d_name), SCT_OIL);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_PARK]. d_mnem, 
				dchr [SCT_PARK]. d_name), SCT_PARK);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RADAR]. d_mnem, 
				dchr [SCT_RADAR]. d_name), SCT_RADAR);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_REFINE]. d_mnem, 
				dchr [SCT_REFINE]. d_name), SCT_REFINE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RSRCH]. d_mnem, 
				dchr [SCT_RSRCH]. d_name), SCT_RSRCH);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_SANCT]. d_mnem, 
					dchr [SCT_SANCT]. d_name), SCT_SANCT);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_AMMOF]. d_mnem, 
				dchr [SCT_AMMOF]. d_name), SCT_AMMOF);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_TECH]. d_mnem, 
				dchr [SCT_TECH]. d_name), SCT_TECH);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_URAN]. d_mnem, 
				dchr [SCT_URAN]. d_name), SCT_URAN);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_WAREH]. d_mnem, 
				dchr [SCT_WAREH]. d_name), SCT_WAREH);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_WASTE]. d_mnem, 
				   dchr [SCT_WASTE]. d_name), SCT_WASTE);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_WATER]. d_mnem, 
					dchr [SCT_WATER]. d_name), SCT_WATER);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_UNKNOW]. d_mnem, 
					dchr [SCT_UNKNOW]. d_name), SCT_UNKNOW);
	AddStringID (strings, Fmt ("%c %s", dchr [SCT_RURAL]. d_mnem, 
				dchr [SCT_RURAL]. d_name), SCT_RURAL);

	pager = InitPager (strings, "New designation ?");
	SetInfoOnPager (pager, HelpDesignate);
	MapPagerFromTop (pager, map_win, x, y);

	r = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (r < 0)
	{
		Message ("Designate cancelled");
		return;
	}


	
	DoDesignate (realm, dchr [r]. d_mnem);
	Message (Fmt ("%s is designed to %s", realm, dchr [r]. d_name));

	DrawMap;
	ClearMes ();
	Census ();
}
