/*************************************************************
 *  $Id: print.c,v 1.8 91/06/06 12:52:49 dhay Exp $
 *
 *  print.c
 *
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1989,90,91.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <stdio.h>

/* Prevent ^G from getting out. */
int disable_bell_output = 0;

/* #define FUNNY_HIGH if highlighting doesn't work on your terminal */
/* #define FUNNY_HIGH */

static int curout_isapipe;
static FILE *curout = stdout;
static terminited=0;
static char *Terminal_SO, *Terminal_SE;

static void terminit();

/*******************************************
 * stripprint
 *
 * Strip any EMPIRE hilighting bits from the
 * string, then print it to passed file.
 */
    static void
stripprint(str, out)
    char *str;
    FILE *out;
{
    char *cp=str;

    if (disable_bell_output) {
	while (*cp) {
	    if (*cp == 07) {
		if (!*(cp+1)) {
		    *cp = 0;
		} else
		    *cp = ' ';
	    }
	    *cp++ &= 0x7f;
	}
    } else {
	while (*cp) *cp++ &= 0x7f;
    }
    fprintf(out, "%s", str);
}

/*******************************************
 * hiprint
 *
 * Find any characters in passed string with EMPIRE
 * highlighting bits set, and hilight those characters.
 */
    static void
hiprint(str, out)
    char *str;
    FILE *out;
{
    char *cp;
    int  hav_hi = 0;

    if (!terminited) {
	terminited = 1;
	terminit();
    }

    /* This routine uses "fprintf" instead of "fputs".  Why?
     * Because of an amazing fputs bug in SunOS 4.0.2 on 386i's.
     * And since I'm stuck with it, so are you.
     */
    if (disable_bell_output) {
	for (cp=str; *cp; cp++) {
	    if (*cp & 0x80) hav_hi = 1;
	    if (*cp == 07) {
		if (!*(cp+1)) {
		    *cp = 0;
		} else
		    *cp = ' ';
	    }
	}
    } else {
	for (cp=str; *cp; cp++) {
	    if (*cp & 0x80) hav_hi = 1;
	}
    }
    if (!hav_hi || !Terminal_SO || !Terminal_SE || !*Terminal_SO
			|| !*Terminal_SE) {
	if (hav_hi)
	    for (cp=str; *cp; cp++) *cp &= 0x7f;
	fprintf(out, "%s", str);
    } else {
	for (cp=str; *cp;) {
	    if (*cp & 0x80) {
		fprintf(out, "%s", Terminal_SO);
		for ( ; (*cp & 0x80 && putc((*cp & 0x7f), out)); cp++);
		fprintf(out, "%s", Terminal_SE);
	    } else
		putc(*cp++, out);
	}
    }
}

/*******************************************
 * prt
 *
 * A printf equivalent.
 * Used to control printout levels, and
 * to copy output to files if necessary.
 */

/*VARARGS1*/
    void
prt(str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10)
    char *str;
    int *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10;
{
    char buf[300];
    char *sprintf();

    (void) sprintf(buf, str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
    if ((curout == stdout) || (curout == stderr)) {
	hiprint(buf, curout);
    } else if (curout) {
	stripprint(buf, curout);
    }
}

/*******************************************
 * put
 *
 * Print a single character to current output.
 */
    void
put(c)
    char c;
{
    if (curout)
	putc(c, curout);
}

/*******************************************
 * myfputs
 *
 * Put string to a file.
 */
    void
myfputs(str, fp)
    char *str;
    FILE *fp;
{
    if ((fp == stdout) || (fp == stderr)) {
	hiprint(str, fp);
    } else
	stripprint(str, fp);
}

/*******************************************
 * eprt
 *
 * Print string to stderr.
 * Echo to current output if not to the display.
 */
/*VARARGS1*/
    void
eprt(str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10)
    char *str;
    int *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10;
{
    char buf[300];
    char *sprintf();

    (void) sprintf(buf, str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
    hiprint(buf, stderr);
    if ((curout != stdout) && (curout != stderr) && curout)
	stripprint(buf, curout);
}

/*******************************************
 * notstdio_prt
 *
 * Print if current output is not to terminal.
 */
/*VARARGS1*/
    void
notstdio_prt(str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10)
    char *str;
    int *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10;
{
    char buf[300];
    char *sprintf();

    (void) sprintf(buf, str, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
    if ((curout != stdout) && (curout != stderr) && curout)
	stripprint(buf, curout);
}

/*******************************************
 * output_curout
 *
 * Return the current output file, so it can
 * be used for something.
 */
    FILE *
output_curout()
{
    return(curout);
}

/*******************************************
 * output_file
 *
 * Close current output if not display, and
 * make passed file current output.
 *
 * Used to recover after a redirection.
 */
    void
output_file(fp, ispipe)
    FILE *fp;
    int ispipe;
{
    if (fp && (fp == curout)) return;

    if (curout && (curout != stdout) && (curout != stderr)) {
	if (curout_isapipe) {
	    pclose(curout);
	} else
	    fclose(curout);
    }

    curout = fp;
    curout_isapipe = ispipe;
}

/*******************************************
 * output_to
 *
 * Open file with given access, and make it current
 * output.
 * Return current output so that it may be recovered
 * when done with new file.
 */
    FILE *
output_to(name, access, oldispipe)
    char *name;
    int access;
    int *oldispipe;
{
    FILE *fp, *fp2;
    char *acc="a";

    if (!access) {
	if (fp=fopen(name, "r")) {
	    fclose(fp);
	    return((FILE *) -1);
	}
    } else if (0 > access) {
	acc = "w";
    }

    if (!strcmp(name, "-")) {
	fp2 = curout;
	curout = stdout;
	*oldispipe = curout_isapipe;
	curout_isapipe = 0;
	return(fp2);
    } else if ((fp=fopen(name, acc))) {
	fp2 = curout;
	curout = fp;
	*oldispipe = curout_isapipe;
	curout_isapipe = 0;
	return(fp2);
    }
    return((FILE *) 0);
}

/*******************************************
 * output_topipe
 *
 * Open a pipe to given command, and make it current
 * output.
 * Return current output so that it may be recovered
 * when done with new file.
 */
    FILE *
output_topipe(cmd, oldispipe)
    char *cmd;
    int *oldispipe;
{
    FILE *fp, *fp2;

    if ((fp=popen(cmd, "w"))) {
	fp2 = curout;
	curout = fp;
	*oldispipe = curout_isapipe;
	curout_isapipe = 1;
	return(fp2);
    }
    return((FILE *) 0);
}

/*******************************************
 * output_turnoff
 *
 * Disable any output.
 * Return current output so that it may be recovered
 * when done with new file.
 */
    FILE *
output_turnoff(oldispipe)
    int *oldispipe;
{
    FILE *fp2;

    fp2 = curout;
    curout = (FILE *) 0;
    *oldispipe = curout_isapipe;
    curout_isapipe = 0;
    return(fp2);
}


/*******************************************
 * terminit
 *
 * Go find the highlighting strings for the terminal.
 */

    static void
terminit()
{
    char *getenv(), *tgetstr();
    char *cp, *term;
    static char nullstring[2];
    static char termbuf[1024];
    static char data[1024];
    static char *area;

    area = data;
    Terminal_SO = Terminal_SE = nullstring;

    term = getenv("TERM");
    if (!term) {
	fprintf(stderr, "Unable to get TERM environment variable.\n");
	return;
    }

    if (tgetent(termbuf, term) == -1) {
	fprintf(stderr, "terminit tgetent failed\n");
	return;
    }

    cp = area;
    if (tgetstr("so", &area) == NULL) {
#if 0
	fprintf(stderr, "terminit, no so\n");
#endif
    } else
	Terminal_SO = cp;

    cp = area;
    if (tgetstr("se", &area) == NULL) {
#if 0
	fprintf(stderr, "terminit, no se\n");
#endif
    } else
	Terminal_SE = cp;
#ifdef FUNNY_HIGH
    ++Terminal_SO;
    ++Terminal_SE;
#endif
}
