/*******************************************************
 * $Id: sock.c,v 1.6 91/05/17 12:02:48 dhay Exp $
 *
 * sock.c
 *
 * Send and receive information to/from emp_player.
 *
 * Doug Hay.
 *
 * Heavily modified from source by:
 *    Jon Sari, 1990
 */

#include <errno.h>
#include <stdio.h>
#include <strings.h>
#include <sys/time.h>
#include <sys/types.h>
#include "proto.h"

void writesock();
static char *grab_line();
char *index();

/* If this is set, we had an interrupt */
extern int Interrupt;
/* This set if a pipe interrupt */
extern int Pipe_Interrupt;

/* This can be fprintf(stderr, ...) */
void eprt();
/* This can be printf() */
void prt();
/* This can be fputs() */
void myfputs();

/* Parsed from prompts coming back. */
extern int game_time, game_btus;

static char sockbuf[2048];

/*****************************************
 * readsock
 *
 *
 * Returns:
 *  -1 - when lost the connection.
 *   0 - not dreadable, data timeout?
 *   1 - a main prompt is sent.
 *   2 - when a flush is sent.
 */
    int
readsock(sock, fp, timeout, prompt, prsize)
    int sock;	/* Descriptor to read from */
    FILE *fp;	/* Pointer to write to */
    int timeout; /* Max time in seconds to wait for read */
    char *prompt;
    int prsize;
{
    int sentabort=0;	/* Whether we sent an abort or not. */
    static char *ptr=sockbuf;	/* Current place in the display buffer */
    int the_ret=0;	/* Possible return value */
    char *cp;
    int cc;
    int count;
    int expected;
    char display[512];

    /* If there was an interrupt, let us try to abort. */
    if (Interrupt) {
	eprt("Sending abort\n");
	writesock(sock, "\naborted");
	Interrupt = 0;
	sentabort = 1;
    }
    ptr = 0;
    expected = 0;

    /* While there is data to read, within the timeout we are
     * to wait, read data.
     */
    while (dreadable(sock, timeout)) {
	if (ptr && *ptr) {
	    /* We have an incomplete line left in the buffer. */
	    count = strlen(ptr);
	    strcpy(sockbuf, ptr);
	} else
	    count = 0;

	ptr = sockbuf + count;

	/* Get more data from emp_player */
	if ((cc = read(sock, ptr, sizeof(sockbuf)-count)) < 0) {
	    perror("socket read");
	    return(-1);
	}
	if (cc == 0) {
	    eprt("Server EOF\n");
	    return(-1);
	}

	/* Make sure it is ended with a null */
	sockbuf[cc+count] = '\0';
	ptr = sockbuf;

	/* While there are complete lines left, look at them */
	while (index(ptr, '\n')) {
	    /* Parse the line. */
	    ptr = grab_line(ptr, &expected, display);

	    if (-1 != the_ret)
		the_ret = 0;
	    switch (expected) {
		case C_PROMPT:
		    (void) sscanf(display, "%d %d", &game_time, &game_btus);
		    if (-1 != the_ret)
			the_ret = 1;
		    sentabort = 0;
		break;

		case C_DATA:
		    /* XXXX We need to check for inverse characters. */
		    if (fp && !Pipe_Interrupt)
			myfputs(display, fp);
		break;

		case C_EXIT:
		    /* Well, says he wants to quit. */
		    /* Game over, man. */
		    if (fp)
			fprintf(fp, "%s\n", display);
		    the_ret = -1;
		break;

		case C_FLUSH:
		    /* A prompt, but not a command-line one. */
		    if ((cp=index(display, '\n'))) *cp = '\0';
		    if (prompt) {
			strncpy(prompt, display, prsize-1);
		    } else
			printf("%s", display);
		    if ((-1 != the_ret) && !sentabort)
			the_ret = 2;
		break;

		case C_CMDERR:
		case C_BADCMD:
		    eprt("Error; %s\n", display);
		break;

		case C_PIPE:              /* Should not occur */
		case C_REDIR:             /* Should not occur */
		    eprt("Damn, let a redirection command through.\n");
		break;

		case C_EXECUTE:           /* Should not occur */
		    eprt("Damn, let an exec command through.\n");
		break;

		case C_CMDOK:
		case C_INIT:
		case C_NOECHO:
		case C_ABORT:
		    eprt("Unexpected protocol, %d\n", expected);
		break;

		default:
		    eprt("Unknown protocol code, %d\n", expected);
		break;
	    }
	}
	if (!*ptr) {
	    ptr = sockbuf;
	    *ptr = '\0';
	}
	if (Interrupt) {
	    eprt("Sending abort\n");
	    Interrupt = 0;
	    writesock(sock, "\naborted");
	    sentabort = 1;
	}
	if (fp && !Pipe_Interrupt)
	    fflush(fp);
	if (the_ret) {
	    /* If we had a return set  (a prompt of some form)
	     * and there is no more data to read,
	     * then return the prompt type.
	     */
	    if (!dreadable(sock, 0) && !*ptr)
		return(the_ret);
	}
    }
    return(0);
}

/*
 * A neat-o routine to tell whether a descriptor has any data available.
 *
 * Jon "Rob McKenna was a rain god . . . " Sari, 1990
 */
/* Returns:
 *   1 - if 's' has data ready to be read.
 *   0 - if 's' has no data ready to be read.
 *  -1 - if a problem occured.  Maybe an Interrupt.
 *
 *  'wait' is the time, in seconds, to wait for data.
 *  If 'wait' is zero, then this is a check to see if data is available.
 */

    int
dreadable(s, wait)
    int s, wait;
{
    struct fd_set               read_fd;
    struct timeval              timeout;
    int rval;

    extern int errno;

    timeout.tv_sec = wait;
    timeout.tv_usec = 0;

    FD_ZERO(&read_fd);
    FD_SET(s, &read_fd);

    rval = select(s+1, &read_fd, (fd_set *)0, (fd_set *)0, &timeout);
    if (rval<0 && errno==EINTR)
	Interrupt++;

    return rval;
}

/*
 * A routine to write a string to a socket.
 * Actually, pretty dull.
 *
 * Jon "Fwuh!" Sari, 1990
 */

    void
writesock(s, cmd)
    int  s;
    char *cmd;
{
    register int i = 0;

    while (*cmd)
	sockbuf[i++] = *cmd++;
    sockbuf[i++] = '\n';
    sockbuf[i] = 0;
    if (write(s, sockbuf, i) < i)
	perror("socket write");
}

/*
 * A routine to replace sscanf("%x%*c%[^\n]", &no, line) which strips
 * off signed character data.  (It's faster, anyhow.)
 *
 * Jon "Heh heh heh" Sari, 1990
 */

    static char *
grab_line(p, no, line)
	char    *p;
	int     *no;
	char    *line;
{
    *no = (*p <= '9') ? *p - '0' : ((*p < 'G') ? *p -'A'+10 : *p -'a'+10);
    p += 2;
    while (*p && *p != '\n')
	*line++ = *p++;
    if ('\n' == *p) {
	*line++ = *p++;
    } else
	*line++ = '\n';
    *line = '\0';
    return(p);
}
