/*
** Header for baseemp.c as base for empire client development in C
*/

/* A bunch for unix include files.  If you are porting to a different OS this
** stuff has surely moved.
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

/* These are the output prefixes from the server.
*/
#define C_CMDOK 	'0'		/* A successful 'pre-play' command */
#define C_DATA 		'1'		/* Standard data */
#define C_INIT 		'2'		/* You get this on connect and after play */
#define C_EXIT 		'3'		/* When you leave the server (bye) */
#define C_FLUSH 	'4'		/* This is a subcommand prompt (nav) */
#define C_NOECHO 	'5'		/* I don't even know if this is used */
#define C_PROMPT 	'6'		/* Standard prompt (connect time btu) */
#define C_ABORT 	'7'		/* Never seen this one before either */
#define C_REDIR 	'8'		/* Passed at the head of a > file command */
#define C_PIPE 		'9'		/* Passed at the head of a | stage command */
#define C_CMDERR 	'a'		/* Error in 'pre-play' command */
#define C_BADCMD 	'b'		/* Error in 'pre-play' command */
#define C_EXECUTE 	'c'		/* Passed at the head of exec block */

/*
 * Structures
 */

struct ioelem {				/* linked list of input */
  char data[1024];
  struct ioelem *next, *prev;
};

/*
 * prototypes
 */
void session_loop(int s);		/* Main loop */
void procio(int s);			/* Handle io from user */
void server_io(int s);			/* Handle io from server */
void client_io();			/* Put keyboard input into io queue */
void close_session(int s);		/* shut down the empire session */
int getline(int s, char *data);		/* Get one line of data from the server */
void push(char *data);			/* push something onto the bottom of the queue */
void pull(char *data);			/* pull something off of the head of the queue */
void pullword(char *line, char *word1, char *rest);	/* split the first word off of a string */

/*
 * globals
 */
int waiting=0, redirecting=0, count=0;	/* some counters */
char CODE;				/* Holds the last output code */
char PROMPT[512];			/* Holds the last prompt string */

struct ioelem *iotail, *iohead;		/* GLOBAL head and tail of io queue */
