
# awk script to read telegrams and keep track of plague
# must have a file with the folowing format:
#
# plague
# -
# -
#  sect          (each line must be 17 chars, NO TABS )
# END-OF-PLAGUE 

BEGIN	{
	inp = 1
	inb = 0
	HP["foobar"] = 0
	OB["foobar"] = 0
}

inb == 1 && $2 == "battling" && $3 == "PLAGUE" && NF == 3 {
	if (OB[$1] == 1) OB[$1] = 0
	HP[$1] = 1
}

inb == 1 && $3 == "died" && $5 == "PLAGUE" && NF == 7 {
	HP[substr($NF,1,length($NF)-1)] = 1
}

inb == 1 && $1 == "Outbreak" && NF == 5 {
	OB[substr($NF,1,length($NF)-1)] = 1
}

inb == 1 && $1 == "Telegram" {
	inb = 0
	inp = 0
}

inb == 1 && /^$/ {
	inb = 0
}

inp == 1 && $NF == "OUTBREAK" {
	OB[$1] = 1
}

inp == 1 && /END-OF-PLAGUE/ {
	inp = 0
}

$1 == "BULLETIN!" {
	inb = 1
	inp = 0
}

END	{
	print "plague"
	print "-"
	print "-"
	print " sect   (each line must 17 chars, NO TABS )"
	for (i in HP) {
		if (HP[i] == 1) print i"                            BATTLE"
	}
	for (i in OB) {
		if (OB[i] == 1) print i"                            OUTBREAK"
	}
	print "END-OF-PLAGUE"
}

