static char *RCSid = "$Header: redir.c,v 1.9 88/04/01 04:40:40 muir Locked $";

/*
 * $Log:	redir.c,v $
 * Revision 1.9  88/04/01  04:40:40  muir
 * rcsid now at top
 * 
 */

/*
 * redir.c
 *
 * do output redirection.  no pipes.
 *
 * Dave Pare, 1986
 *
 * pipes.  Julian Onion 1987
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <setjmp.h>
#include <sys/file.h>
#include <signal.h>
#include <errno.h>
#include "defs.h"
#include "sailio.h"
#ifdef hpux
#include <fcntl.h>
#endif

extern	int pipeout;
extern	int	(*pipsig)();

FILE *
redir(buf)
	char	*buf;
{
	FILE	*redir_open();
	FILE	*pipedir ();
	FILE	*fp;
	char	**argv;
	int	argc;
	int	mode;
	char	*p;
	int	i;

	pipeout = 0;
	argc = scan(buf, &argv, " \t");
	if (argc == 0)
		return 0;
	for (i=0; i<argc; i++) {
		if (*argv[i] == '>')
			break;
		if (*argv[i] == '|')
			break;
	}
	if (i == argc)
		return 0;
	if (*argv[i] == '|') {
		fp = pipedir(argv, argc, i, buf);
		if (fp) {
			fprintf (fp, "%s\n", buf);
			pipeout = 1;
		}
		printf("command: %s\n", buf);
		return fp;
	}
	p = argv[i] + 1;
	mode = O_CREAT|O_EXCL;
	if (*p == '>') {
		p++;
		mode = O_APPEND;
	}
	if (*p == '!') {
		mode &= ~O_EXCL;
		if (mode == O_CREAT)
			mode |= O_TRUNC;
		else
			mode |= O_CREAT;
		p++;
	}
	/*
	 * means separate arguments for > and filename
	 */
	if (*p == 0) {
		p = argv[i+1];
		argc--;
	}
	/*
	 * rebuild the command, deleting the redirection muck.
	 */
	*buf = 0;
	argc--;
	for (i=0; i<argc; i++) {
		strcat(buf, argv[i]);
		if (i < argc-1)
			strcat(buf, " ");
	}
	printf("command is \"%s\"\n", buf);
	fp = redir_open(p, mode);
	if (fp)
		fprintf (fp, "%s\n", buf);	/* for ve! */
	return fp;
}

FILE *
redir_open(name, mode)
	char	*name;
	int	mode;
{
	int	fd;
	FILE	*fp;

	mode |= O_RDWR;
	fd = open(name, mode, 0666);
	if (fd < 0) {
		perror(name);
		return 0;
	}
	fp = fdopen(fd, "w");
	return fp;
}

FILE	*pipedir (argv, argc, indx, line)
char	**argv, *line;
int	argc, indx;
{
	char	*p;
	int	i;
	char	buffer[128];

	*line = 0;
	for (i = 0; i < indx; i++) {
		strcat (line, argv[i]);
		if (i < indx - 1)
			strcat (line, " ");
	}

	buffer[0] = 0;
	for (i = indx; i < argc; i++) {
		strcat (buffer, argv[i]);
		if (i < argc-1)
			strcat (buffer, " ");
	}
	pipsig = signal(SIGPIPE, SIG_IGN);
	return popen(buffer + 1, "w");
}
