#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/update/RCS/sect.c,v 1.11 89/09/18 00:55:24 mr-frog Exp $";
#endif

/*
 * prepare.c
 *
 * perform preliminary updates of the sect
 * does pop growth/starvation, and mil payment,
 * reserve payment, and cap payments
 *
 * Does this for all countries at once
 * 
 * Modified from code
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 *
 * by Thomas Ruschak, 1992
 */

#include <math.h>
#include "misc.h"
#ifdef BUDGET
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#ifdef	FALLOUT
#include "path.h"
#endif	FALLOUT

extern	float levels[MAXNOC][4];

prepare_sects(etu)
	int	etu;
{
	extern	int pops[];
	register struct sctstr *sp;
	struct	natstr *np;
	int	n;
	int	vec[I_MAX+1];
	int	changed;

	bzero((s_char *)levels, sizeof(levels));

	for (n=0; sp = getsectid(n); n++) {
		sp->sct_updated = 0;
#ifdef	FALLOUT
	        do_fallout(sp,etu);
#endif	FALLOUT
		if (sp->sct_type == SCT_WATER)
			continue;
		np = getnatp(sp->sct_own);
		guerrilla(sp);
		prep_update(sp, etu, np, &pops[sp->sct_own]);
	}
}

/*
 * update the individual sector
 *
 */
prep_update(sp, etus, np, pop)
	register struct sctstr *sp;
	register int etus;
	register struct natstr *np;
	long	*pop;
{
	extern	double populace();
	extern	double eatrate;
	extern	double bankint;
	int	vec[I_MAX+1];
	int	cvec[I_MAX+1];
	int	people;
	int	work;
	int	n;
	int	starved;

	if (getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR) <= 0)
		return;
	if (getvec(VT_COND, cvec, (s_char *)sp, EF_SECTOR) <= 0)
		bzero(cvec,sizeof(cvec));

	/* If everybody is dead, the sector reverts to unowned. 
	 * This is also checked at the end of the production in
	 * they all starved or were plagued off.
	 */
	if (vec[I_CIVIL] == 0 && vec[I_MILIT] == 0) {
		sp->sct_own = 0;
		sp->sct_oldown = 0;
		return;
	}
	/* grow people & stuff */
	work = roundavg((etus * populace(np, sp, vec, etus)) / 100.0);

	people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
	if (sp->sct_type != SCT_SANCT) {
#ifndef	NOFOOD
		if (vec[I_FOOD] < 1 + etus * people * eatrate) {
			/* need to grow "emergency rations" */ 
			work -= growfood(sp, vec, work, etus);
		}
#endif	NOFOOD
		starved = feed_people(vec, etus);
		if (starved > 0 && sp->sct_own) {
			/* don't report POGO starvation */
			wu(0, sp->sct_own, fmt("%d starved in %s.\n", starved,
				xyas(sp->sct_x, sp->sct_y, sp->sct_own)));
			if (starved > 25)
				nreport(sp->sct_own, N_DIE_FAMINE, 0, 1);
		}
		if (starved > 0)
			starvation(sp);
		else {
			if (sp->sct_work < 100)
				sp->sct_work += 8 + (random() % 15);
			if (sp->sct_work > 100)
				sp->sct_work = 100;
			grow_people(vec, etus);
		}
	} else
		sp->sct_work = 100;
	if (cvec[C_PSTAGE] == 0) {
		cvec[C_PSTAGE] = infect_people(np, vec, sp->sct_effic,
			(int)sp->sct_mobil);
		cvec[C_PTIME] = 0;
	} else {
		n = plague_people(np, vec, cvec, etus);
		switch (n) {
		case PLG_DYING:
			wu(0, sp->sct_own,
				fmt("PLAGUE deaths reported in %s.\n",
				ownxy(sp)));
			nreport(sp->sct_own, N_DIE_PLAGUE, 0, 1);
			break;
		case PLG_INFECT:
			wu(0, sp->sct_own, fmt("%s battling PLAGUE\n",
				 ownxy(sp)));
			break;
		case PLG_INCUBATE:
			/* plage has moved into "infectious" stage */
			if (n != cvec[C_PSTAGE]) {
				wu(0, sp->sct_own,
					fmt("Outbreak of PLAGUE in %s!\n",
					ownxy(sp)));
				nreport(sp->sct_own, N_OUT_PLAGUE, 0, 1);
			}
			break;
		case PLG_EXPOSED:
		default:
			break;
		}
	}
	if (vec[I_CIVIL] == 0 && vec[I_MILIT] == 0) {
		sp->sct_own = 0;
		sp->sct_oldown = 0;
	}
	/*
	 * only non-captured civs add to census for nation
	 */
	if (sp->sct_oldown == sp->sct_own)
		*pop += vec[I_CIVIL];

	if (sp->sct_effic > 60)
		if (sp->sct_type == SCT_BANK)
			np->nat_money += vec[I_BAR] * etus * bankint;
	else if (sp->sct_type == SCT_CAPIT)
		np->nat_money -= etus;
	
	putvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);
	putvec(VT_COND, cvec, (s_char *)sp, EF_SECTOR);
}
#endif	FALLOUT
