#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/player/commands/RCS/give.c,v 1.1 91/04/08 16:59:55 dhay Exp Locker: dhay $";
#endif /* not lint */

/*
 * give.c
 *
 * David Muir Sharnoff
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "item.h"
#include "deity.h"
#include "file.h"

/*
 * format: give <commod> <sect> <amt>
 */
give()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	amt;
	struct	ichrstr *ip;
	int	m, n;
	s_char	*p;
	struct nstr_sect nstr;

	if (!(ip = whatitem(argp[1], "which commodity? ")))
		return RET_SYN;
	if (!snxtsct(&nstr, argp[2]))
		return RET_SYN;
	while (nxtsct(&nstr, &sect) > 0) {
		if (!(p = getstarg(argp[3], "how much : ")) || (*p  == '\0'))
			return RET_SYN;
		if ((amt = atoi(p)) == 0)
			return RET_SYN;
		n = getvar(ip->i_vtype, (s_char *)&sect, EF_SECTOR);
		if (amt < 0 && -amt > n) {
			m = 0;
		} else if (amt > 0 && amt+n > 9990) {
			m = 9990;
		} else
			m = n + amt;
		if (putvar(ip->i_vtype, m, (s_char *)&sect, EF_SECTOR) < 0) {
			pr(fmt("No room to store %s in %s\n", ip->i_name,
					xyas(sect.sct_x, sect.sct_y, cnum)));
			return RET_FAIL;
		}
		putsect(&sect);
		if (sect.sct_own != 0 && m != n) {
			if (m > n) {
#ifdef GODNEWS
				nreport(cnum, N_GIFT, sect.sct_own, 1);
#endif /* GODNEWS */
				wu(cnum, sect.sct_own, fmt("%s gave you %d %s in %s\n",
					cname(cnum), m-n, ip->i_name, 
					xyas(sect.sct_x, sect.sct_y, sect.sct_own)));
			} else {
#ifdef GODNEWS
				nreport(sect.sct_own, N_TAKE, cnum, 1);
#endif /* GODNEWS */
				wu(cnum, sect.sct_own, fmt("%s stole %d %s from %s\n",
					cname(cnum), n-m, ip->i_name,
					xyas(sect.sct_x, sect.sct_y, sect.sct_own)));
			}
		}
		pr(fmt("%d %s in %s\n", m, ip->i_name,
			xyas(sect.sct_x, sect.sct_y, cnum)));
	}
	return RET_OK;
}
