#ifndef lint
static char *RCSid = "$Header: /SRX/empite/EMP/player/commands/scut.c 1.0 90/03/23 19:47:24 bailey Exp $";
#endif /* not lint */

/*
 * fuel.c
 *
 * Scuttle ships (or land units)
 * Taken from scut.c
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "sect.h"

#ifdef FUEL

union item_u {
	struct shpstr ship;
#ifdef LANDUNITS
	struct landstr land;
#endif /* LANDUNITS */
};

fuel()
{
	extern	s_char *argp[];
	struct	nstr_item ni;
	union	item_u item, item2;
	int	type;
	struct	mchrstr *mp;
	s_char	*p;
	s_char	*ptr;
	int	fueled;
	int	ship_fuel, oil_amt, pet_amt, fuel_amt, tot_fuel, max_amt;
	int	move_amt;
	float	extra;
	struct	sctstr sect;
	struct  natstr *natp;
	int	harbor;
        struct  nstr_item tender;

#ifdef LANDUNITS
	if ((p = getstarg(argp[1], "Ship or land unit? ")) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type != EF_SHIP && type != EF_LAND){
		pr("Ships or land units only!\n" );
		return RET_SYN;
	}
#else
	type = EF_SHIP;
#endif /* LANDUNITS */
#ifdef LANDUNITS
	p = getstarg(argp[3], "Amount: ");
	if (p == 0 || *p == 0)
       		return RET_SYN;
	fuel_amt = atoi(p);
#endif /* LANDUNITS */

#ifdef LANDUNITS
	p = argp[2] = getstarg(argp[2], "%s(s)? ",ef_byname(type));
	if (!snxtitem(&ni, type, argp[2]))
		return RET_SYN;
#else
	p = argp[1] = getstarg(argp[1], "Ship(s)? ");
	if (!snxtitem(&ni, type, argp[1]))
		return RET_SYN;
#endif /* LANDUNITS */

#ifdef  ALLYHARBOR
        ni.flags &= ~(EFF_OWNER);
#endif  ALLYHARBOR

#ifndef LANDUNITS
	p = getstarg(argp[2], "Amount: ");
	if (p == 0 || *p == 0)
       		return RET_SYN;
	fuel_amt = atoi(p);
#endif /* LANDUNITS */
	while (nxtitem(&ni, (s_char *)&item)) {
		fueled = 0;
		if (type == EF_SHIP) {
			if (item.ship.shp_own != cnum){
#ifdef ALLYHARBOR
				int	rel;

#ifdef LANDUNITS
				if ((item.ship.shp_uid != atoi(argp[2]))
					|| (!isdigit(*argp[2])))
#else
				if ((item.ship.shp_uid != atoi(argp[1]))
					|| (!isdigit(*argp[1])))
#endif /* LANDUNITS */
					continue;
				natp=getnatp(cnum);
				rel=getrel(natp,item.ship.shp_own);
				if (rel != ALLIED)
#endif /* ALLYHARBOR */
					continue;
			}
			if (!getsect(item.ship.shp_x, item.ship.shp_y, &sect))
				continue;
#ifdef  ALLYHARBOR
			if (!item.ship.shp_own)
#else
			if (!owner)
#endif  ALLYHARBOR
				continue;

			if ((sect.sct_type != SCT_HARBR)  && (sect.sct_type != SCT_WATER) && (sect.sct_type != SCT_BSPAN)){
				pr(fmt("Sector %s is not a harbor, bridge span, or sea.\n",
					xyas(item.ship.shp_x, item.ship.shp_y,
					item.ship.shp_own)));
				continue;
			}

			mp = &mchr[item.ship.shp_type];

			if (sect.sct_type == SCT_HARBR){
				harbor=1;
				oil_amt = getvar(V_OIL, (s_char *)&sect, EF_SECTOR);
				pet_amt = getvar(V_PETROL, (s_char *)&sect, EF_SECTOR);
				if ((oil_amt+pet_amt) == 0)
					harbor=0;

				if (sect.sct_effic < 2) {
					pr(fmt("The harbor at %s is not 2%% efficient yet.\n",
						xyas(item.ship.shp_x,
							item.ship.shp_y,
							cnum)));
					harbor=0;
				}
				if ((sect.sct_own != cnum) && sect.sct_own)
					harbor=0;
			}
			else{
				if ((sect.sct_own != cnum) && sect.sct_own)
					continue;
				harbor=0;
			}

			if ((mp->m_fuelu == 0) && (item.ship.shp_own == cnum)){
				pr(fmt("%s (#%d) does not use fuel!\n",mchr[item.ship.shp_type].m_name,item.ship.shp_uid));
				continue;
			}

			if (harbor){
				ship_fuel = item.ship.shp_fuel;
				oil_amt = getvar(V_OIL, (s_char *)&sect, EF_SECTOR);
				pet_amt = getvar(V_PETROL, (s_char *)&sect, EF_SECTOR);
				max_amt = mp->m_fuelc-ship_fuel;

				if (max_amt == 0){
					pr(fmt("%s (#%d) already has a full fuel load.\n",mchr[item.ship.shp_type].m_name,item.ship.shp_uid));
					continue;
				}
				tot_fuel = (oil_amt*50 + pet_amt*5);
				if (tot_fuel == 0){
					pr(fmt("No fuel in the harbor at %s!\n",
						xyas(sect.sct_x,sect.sct_y,
							cnum)));
					continue;
				}
				move_amt = min(tot_fuel, fuel_amt);
				move_amt = min(move_amt, max_amt);

				if (move_amt == 0)
					continue;

				item.ship.shp_fuel += move_amt;

				fueled=1;
				if ((pet_amt*5) >= move_amt){
					extra = ((float)move_amt/5.0)-(move_amt/5);
					if (extra > 0.0)
						putvar(V_PETROL,
							max((pet_amt-(move_amt/5))-1,0),
							(s_char *)&sect, EF_SECTOR);
					else
						putvar(V_PETROL,
							max((pet_amt-(move_amt/5)),0),
							(s_char *)&sect, EF_SECTOR);
				}else{
					putvar(V_PETROL, 0, (s_char *)&sect, EF_SECTOR);
					move_amt -= pet_amt*5;
					extra = ((float)move_amt/50.0)-(move_amt/50);
					putvar(V_OIL, max(oil_amt-(move_amt/50), 0),
						(s_char *)&sect, EF_SECTOR);
					if (extra > 0.0)
						putvar(V_OIL,
							max((oil_amt-(move_amt/50))-1,0),
							(s_char *)&sect, EF_SECTOR);
					else
						putvar(V_OIL,
							max((oil_amt-(move_amt/50)),0),
							(s_char *)&sect, EF_SECTOR);
				}

				/* load plague */
				if (getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) ==
					PLG_INFECT && getvar(V_PSTAGE,
					(s_char *)&item.ship, EF_SHIP) == PLG_HEALTHY)
					putvar(V_PSTAGE, PLG_EXPOSED,
						(s_char *)&item.ship, EF_SHIP);

				putsect(&sect);
				putship(item.ship.shp_uid, &item.ship);
			}
			else{	/* not in a harbor */

#ifdef SHIPNAMES
				pr(fmt("%s %s (#%d) is not in a supplied, efficient harbor\n",
				item.ship.shp_name,
#else
				pr(fmt("%s #%d is not in a supplied, efficient harbor\n",
#endif /* SHIPNAMES */
					mchr[item.ship.shp_type].m_name,
					item.ship.shp_uid));
#ifdef LAND_UNITS
        			if (!snxtitem(&tender, EF_SHIP, getstarg(argp[4], "Oiler? ")))
#else
        			if (!snxtitem(&tender, EF_SHIP, getstarg(argp[3], "Oiler? ")))
#endif /* LAND_UNITS */
                			continue;

				if (!nxtitem(&tender, (s_char *)&item2))
                			continue;

				if (!(mchr[item2.ship.shp_type].m_flags & M_OILER)){
					pr(fmt("%s (#%d) is not an oiler!\n",
						mchr[item2.ship.shp_type].m_name,
						item2.ship.shp_uid));
					continue;
				}
				if (item2.ship.shp_own != cnum){
					pr("You don't own that oiler!\n");
					continue;
				}

				if ((item2.ship.shp_x != item.ship.shp_x) ||
					(item2.ship.shp_y != item.ship.shp_y)){
					pr("Not in the same sector!\n");
					continue;
				}
				ship_fuel = item.ship.shp_fuel;
				oil_amt = getvar(V_OIL, (s_char *)&item2.ship, EF_SHIP);
				pet_amt = getvar(V_PETROL, (s_char *)&item2.ship, EF_SHIP);
				max_amt = mp->m_fuelc-ship_fuel;

				if (max_amt == 0){
					pr(fmt("%s (#%d) already has a full fuel load.\n",mchr[item.ship.shp_type].m_name,item.ship.shp_uid));
					continue;
				}
				tot_fuel = oil_amt*50 + pet_amt*5;
				move_amt = min(tot_fuel, fuel_amt);
				move_amt = min(move_amt, max_amt);

				if (move_amt == 0)
					continue;

				item.ship.shp_fuel += move_amt;

				fueled=1;
				if ((pet_amt*5) >= move_amt){
					extra = ((float)move_amt/5.0)-(move_amt/5);
					if (extra > 0.0)
						putvar(V_PETROL,
							max((pet_amt-(move_amt/5))-1,0),
							(s_char *)&item2.ship, EF_SHIP);
					else
						putvar(V_PETROL,
							max((pet_amt-(move_amt/5)),0),
							(s_char *)&item2.ship, EF_SHIP);
				}else{
					putvar(V_PETROL, 0, (s_char *)&item2.ship, EF_SHIP);
					move_amt -= pet_amt*5;
					extra = ((float)move_amt/50.0)-(move_amt/50);
					putvar(V_OIL, max(oil_amt-(move_amt/50), 0),
						(s_char *)&item2.ship, EF_SHIP);
					if (extra > 0.0)
						putvar(V_OIL,
							max((oil_amt-(move_amt/50))-1,0),
							(s_char *)&item2.ship, EF_SHIP);
					else
						putvar(V_OIL,
							max((oil_amt-(move_amt/50)),0),
							(s_char *)&item2.ship, EF_SHIP);
				}

				/* load plague */
				if (getvar(V_PSTAGE, (s_char *)&item2.ship, EF_SHIP) ==
					PLG_INFECT && getvar(V_PSTAGE,
					(s_char *)&item.ship, EF_SHIP) == PLG_HEALTHY)
					putvar(V_PSTAGE, PLG_EXPOSED,
						(s_char *)&item.ship, EF_SHIP);

				putship(item2.ship.shp_uid, &item2.ship);
				putship(item.ship.shp_uid, &item.ship);
				putship(item.ship.shp_uid, (s_char *)&item.ship);
			}
			pr(mp->m_name);
#ifdef	SHIPNAMES
			pr(" ");
			pr(item.ship.shp_name);
#endif	SHIPNAMES
		}
#ifdef LANDUNITS
		else {
		}
#endif /* LANDUNITS */
		if (fueled){
#ifdef	SHIPNAMES
			pr(fmt(" (#%d) takes on %d fuel in %s\n", ni.cur,
#else
			pr(fmt(" #%d takes on %d fuel in %s\n", ni.cur,
#endif	SHIPNAMES
			move_amt,
			xyas(item.ship.shp_x, item.ship.shp_y , cnum)));
			if (cnum != item.ship.shp_own)
#ifdef	SHIPNAMES
				wu(0, item.ship.shp_own,
				fmt("%s (#%d) takes on %d fuel in %s courtesy of %s (#%d)\n",
#else
				wu(0, item.ship.shp_own,
				fmt("%s #%d takes on %d fuel in %s courtesy of %s (#%d)\n",
#endif	SHIPNAMES
				mchr[item.ship.shp_type].m_name,
				ni.cur, move_amt,
				xyas(item.ship.shp_x, item.ship.shp_y , 
					item.ship.shp_own), 
				cname(cnum), cnum));
		}
	}
	return RET_OK;
}

#endif/* FUEL */
