#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/fly.c,v 1.4 89/09/18 00:02:23 mr-frog Exp $";
#endif

/*
 * fly.c
 *
 * uses plane units rather than plane "commodities"
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

fly()
{
	extern	s_char *argp[];
	s_char	*p;
	int	mission_flags;
	int	tech;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	struct	ichrstr *ip;
	s_char	flightpath[256];
	struct	shpstr ship;
	int	cno;
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;
	int	dst_type;
	s_char	*dst_ptr;

	wantflags = 0;
	if (!snxtitem(&ni_bomb, EF_PLANE, argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(argp[3], "assembly point? ")) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if ((p = getpath(argp[4], ax, ay, 0, 0, 0)) == 0 || *p == 0)
		return RET_SYN;
	(void)strcpy(flightpath, p);
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	pr(fmt("Ending sector is %s\n", xyas(tx, ty, cnum)));
	getsect(tx, ty, &target);
	cno = -1;
	ip = whatitem(argp[5], "transport what? ");
	mission_flags = 0;
	if (pln_onewaymission(&target, &cno, &wantflags) < 0)
		return RET_SYN;
	if (cno < 0) {
		dst_ptr = (s_char *) &target;
		dst_type = EF_SECTOR;
	} else {
		getship(cno, &ship);
		dst_ptr = (s_char *) &ship;
		dst_type = EF_SHIP;
	}
	ap_to_target = strlen(flightpath);
	if (*(flightpath+strlen(flightpath)-1) == 'h')
		ap_to_target--;
	pr(fmt("range to target is %d\n", ap_to_target));
	/*
	 * select planes within range
	 */
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		1, wantflags, P_M|P_O);
	wantflags |= P_F;
	wantflags |= P_ESC;
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		1, wantflags, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 * tech is stored in high 16 bits of mission_flags.
	 * yuck.
	 */
	tech=0;
	mission_flags |= P_X;		/* stealth (shhh) */
#ifdef CHOPPER_STEALTH
	mission_flags |= P_H; /* gets turned off if not all choppers */
#endif /* CHOPPER_STEALTH */
	mission_flags = pln_arm(&bomb_list, 't', ip, 0, mission_flags,&tech);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, 't', ip, P_ESC|P_F, mission_flags,&tech);
	ac_encounter(&bomb_list, &esc_list, ax, ay, flightpath, mission_flags,&tech);
	if (QEMPTY(&bomb_list)) {
		pr(fmt("No planes got through fighter defenses\n"));
	} else {
		getsect(tx, ty, &target);
		pln_dropoff(&bomb_list, ip, tx, ty, dst_ptr, dst_type);
		pln_newlanding(&bomb_list, tx, ty, cno);
		pln_newlanding(&esc_list, tx, ty, cno);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}
