static char *RCSid = "$Header: /sequent2/empire/EMP/lib/global/RCS/plane.c,v 1.1 89/09/02 18:30:21 mr-frog Exp $";

/*
 * plane.c
 *
 * plane characteristics
 * flags indicate capabilities of craft...
 * P_T: tactical, P_F: fighter/interceptor, P_B: bomber,
 * P_C: cargo, P_G: glider, P_V: vtol, P_M: (one-shot) missile
 * P_L: light, can land on carriers.
 * P_O: orbits (sat's & anti-sats), P_N: nuke killer (SDI)
 * P_X: stealthy
 * P_E: Extra light
 * P_K: Chopper
 * P_P: Can paratroop
 * P_A: ASW plane, can use 'v' while reconning for sonar, can bomb subs
 * P_R: recon plane, gets some info
 * P_I: Image capability (advanced spying)
 * 
 */

#include "misc.h"
#include "plane.h"

struct plchrstr plchr[] = {

/* 1st generation planes Def=1-3 */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"Zeppelin",          6,  2, 1000,  70, 60, 2,  0,-3,  15,  3,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                P_S|P_V|P_T|P_C,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"f1  fighter 1",     8,  2,  400,  90, 90, 1,  3,2,    7,  1,  1,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_V|P_T|P_F,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"lb1 lt bomber 1",  10,  3,  550, 100, 50, 2,  1,2,    7,  1,  1,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_V|P_T|P_B,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nf1 naval fighter 1",8, 2,  500, 100, 80, 1,  2,2,    7,  1,  1,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_L|P_T|P_F,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"hb1 hvy bomber 1", 20,  6, 1100, 110, 90, 5,  1,3,   15,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_B,

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"as1 anti-sub plane 1",10,3, 550, 110, 90, 2,  1,2,   15,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_A,
#endif /* ASW_PLANES */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"f2  fighter 2",     9,  3,  600, 150, 60, 1,  6,4,    9,  1,  1,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_F,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"es  escort",        9,  3,  700, 150, 60, 1,  4,5,   15,  1,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                      P_ESC|P_T,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nf2 naval fighter 2",9, 3,  600, 150, 60, 1,  4,5,    9,  1,  1,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_L|P_T|P_F,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"lb2 lt bomber 2",  11,  4,  750, 150, 35, 2,  2,3,    9,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"mb1 medium bomber 1",14,5, 1000, 150, 45, 4,  2,4,   15,  3,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B,

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"as2 anti-sub plane 2",14,5,1000, 150, 80, 2,  1,3,   17,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_T|P_A,
#endif /* ASW_PLANES */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"tr1 transport 1",  14,  5, 1000, 150,  0, 4,  0,1,   15,  3,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef PARAFLAG
                                                                        P_C|P_P,
#else
                                                                            P_C,
#endif /* PARAFLAG */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"hb2 hvy bomber 2", 22,  8, 1500, 180, 90, 6,  3,6,   17,  4,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_B,
#ifdef RECON
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"re1 recon 1",      12,  4,  800, 180,  0, 0,  0,8,   15,  2,  2,
#ifdef STEALTHV
                                                                    20, 
#endif STEALTHV
                                                                    P_R,
#endif /* RECON */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"f3  fighter 3",    10,  3,  800, 200, 45, 1,  9,6,   11,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_F|P_L,


/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"mb2 medium bomber 2",15,5, 1200, 200, 40, 5,  3,5,   17,  3,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"tr2 transport 2",  15,  5, 1000, 200,  0, 6,  0,2,   17,  3,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef PARAFLAG
                                                                        P_C|P_P,
#else
                                                                            P_C,
#endif /* PARAFLAG */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"hb3 hvy bomber 3", 24, 10, 1800, 220, 90, 8,  5,6,   21,  5,  5,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_B,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jf1 jet fighter 1",12,  4, 1000, 220, 45, 1, 12,9,    7,  2,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_T|P_F,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"srbm",             20, 20, 1000, 240, 60, 6,  0,6,    9,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_M,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jf2 jet fighter 2",14,  4, 1000, 250, 45, 2, 12,9,   11,  2,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_F|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jl1 jet lt bomber 1",14,4, 1000, 250, 25, 3,  4,8,   11,  2,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"tr3 transport 3",  15,  5, 1200, 250,  0, 8,  0,4,   21,  3,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef PARAFLAG
                                                                        P_C|P_P,
#else
                                                                            P_C,
#endif /* PARAFLAG */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"hb4 hvy bomber 4", 24, 10, 2000, 250, 80,10,  6,10,  25,  5,  5,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_B,

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"np1 naval plane 1",15,  5, 1200, 250, 70, 2,  1,3,   25,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef MINE_PLANES
                                                             P_MINE|P_C|P_T|P_A,
#else
                                                                        P_T|P_A,
#endif /* MINE_PLANES */
#endif /* ASW_PLANES */

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nc1 naval chopper 1",8, 2,  800, 250, 60, 2,  0,2,   11,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef SWEEP_PLANES
#ifdef SHIPCHOPPERS
                                                        P_V|P_SWEEP|P_T|P_A|P_K,
#else
                                                            P_V|P_SWEEP|P_T|P_A,
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
                                                                P_V|P_T|P_A|P_K,
#else
                                                                    P_V|P_T|P_A,
#endif /* SHIPCHOPPERS */
#endif /* SWEEP_PLANES */
#endif /* ASW_PLANES */

#ifdef RECON
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jr1 jet recon 1",  15,  5, 1000, 260,  0, 0,  0,10,  15,  2,  4,
#ifdef STEALTHV
                                                                    40, 
#endif STEALTHV
                                                                    P_R,
#endif /* RECON */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"irbm",             20, 20, 1500, 270, 60, 8,  0,6,   15,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_M,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"mi1 missile 1",     8,  2,  300, 270, 60, 6,  0,0,    7,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_L|P_T|P_M,
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sl1 slbm 1",       20, 20, 1500, 280, 60, 8,  0,6,   23,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_L|P_M,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jf3 jet fighter 3",15,  5, 1100, 280, 45, 2, 17,14,  16,  2,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_F|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jl2 jet lt bomber 2",15,5, 1100, 280, 20, 4,  4,10,  13,  2,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jmb jet med bomber",20,10, 1500, 280, 30, 8,  5,10,  25,  5,  5,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_T|P_B,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jhb jet hvy bomber",26,13, 2200, 280, 80,12,  7,10,  31,  5,  6,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_B,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"tc1 transport chopper 1",8,2,800,280,  0, 4,  0,2,   11,  2,  2,
#ifdef STEALTHV
                                                                     40, 
#endif STEALTHV
#ifdef PARAFLAG
                                                                P_V|P_C|P_P|P_L,
#else
                                                                    P_V|P_C|P_L,
#endif /* PARAFLAG */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ac1 attack chopper 1",8,2,  800, 280,  5, 1,  2,8,   11,  2,  2,
#ifdef STEALTHV
                                                                     40, 
#endif STEALTHV
                                                                        P_V|P_T,

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"np2 naval plane 2",15,  5, 1200, 280, 60, 2,  1,3,   25,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef MINE_PLANES
                                                         P_MINE|P_C|P_T|P_A|P_L,
#else
                                                                    P_T|P_A|P_L,
#endif /* MINE_PLANES */
#endif /* ASW_PLANES */

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nc2 naval chopper 2",8,2,   900, 280, 50, 2,  0,3,   13,  2,  2,
#ifdef STEALTHV
                                                                     5, 
#endif STEALTHV
#ifdef SWEEP_PLANES
#ifdef SHIPCHOPPERS
                                                        P_V|P_SWEEP|P_T|P_A|P_K,
#else
                                                            P_V|P_SWEEP|P_T|P_A,
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
                                                                P_V|P_T|P_A|P_K,
#else
                                                                    P_V|P_T|P_A,
#endif /* SHIPCHOPPERS */
#endif /* SWEEP_PLANES */
#endif /* ASW_PLANES */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jt  jet transport",18,  5, 1500, 280,  0,12,  0,8,   25,  3,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_C,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sm1 sam 1",         3,  1,  200, 280,  0, 0, 17,0,   11,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef XLIGHT
                                                            P_L|P_V|P_F|P_E|P_M,
#else
                                                                P_L|P_V|P_F|P_M,
#endif /* XLIGHT */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sp1 spyplane 1",   15,  5, 2000, 290,  0, 0,  0,10,  23,  2,  5,
#ifdef STEALTHV
                                                                    50, 
#endif STEALTHV
                                                                            P_S,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"landsat",          20, 20, 2000, 290,  0, 0,  0,2,   41,  0,  9,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_O,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jf4 jet fighter 4",15,  5, 1200, 310, 45, 3, 22,18,  20,  2,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                P_T|P_F|P_V|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"jl3 jet lt bomber 3",15,5, 1200, 310, 20, 5,  4,12,  17,  2,  3,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_T|P_B|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ac2 attack chopper 2",8,2, 1000, 310,  5, 2,  3,10,  13,  2,  2,
#ifdef STEALTHV
                                                                     50, 
#endif STEALTHV
                                                                    P_V|P_T|P_L,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"tc2 transport chopper 2",8,2,1000,310, 0, 8,  0,4,   13,  2,  2,
#ifdef STEALTHV
                                                                     50, 
#endif STEALTHV
#ifdef PARAFLAG
#ifdef SHIPCHOPPERS
                                                                P_V|P_C|P_P|P_K,
#else
                                                                    P_V|P_C|P_P,
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
                                                                    P_V|P_C|P_K,
#else
                                                                        P_V|P_C,
#endif /* SHIPCHOPPERS */
#endif /* PARAFLAG */

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nc3 naval chopper 3",8, 2, 1000, 310, 40, 2,  0,4,   13,  2,  2,
#ifdef STEALTHV
                                                                    10, 
#endif STEALTHV
#ifdef SWEEP_PLANES
#ifdef SHIPCHOPPERS
                                                        P_V|P_SWEEP|P_T|P_A|P_K,
#else
                                                            P_V|P_SWEEP|P_T|P_A,
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
                                                                P_V|P_T|P_A|P_K,
#else
                                                                    P_V|P_T|P_A,
#endif /* SHIPCHOPPERS */
#endif /* SWEEP_PLANES */
#endif /* ASW_PLANES */


#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"np3 naval plane 3",15,  5, 1200, 310, 50, 2,  1,3,   31,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef MINE_PLANES
                                                         P_MINE|P_C|P_T|P_A|P_L,
#else
                                                                    P_T|P_A|P_L,
#endif /* MINE_PLANES */
#endif /* ASW_PLANES */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sp2 spyplane 2",   15,  5, 2200, 310,  0, 0,  0,14,  31,  2,  5,
#ifdef STEALTHV
                                                                    70, 
#endif STEALTHV
                                                                            P_S,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sm2 sam 2",         3,  1,  200, 310,  0, 0, 22,0,   17,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef XLIGHT
                                                            P_L|P_V|P_F|P_E|P_M,
#else
                                                                P_L|P_V|P_F|P_M,
#endif /* XLIGHT */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"mi2 missile 2",     8,  2,  300, 310, 50, 8,  0,0,   11,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_L|P_T|P_M,

#ifdef ABM
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ab1 abm 1",        10,  4,  500, 310,  0, 0, 30,0,   17,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_N|P_M,
#endif /* ABM */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ss1 spysat 1",     20, 20, 4000, 330,  0, 0,  0,2,   61,  0,  9,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_O|P_S,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"a-sat 1",          20, 20,  500, 350, 60, 6,  0,6,   13,  0,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_O|P_M,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"icbm",             20, 20, 2000, 350, 60,10,  0,6,   41,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                            P_M,
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sl2 slbm 2",       20, 20, 2000, 350, 60, 8,  0,6,   41,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_L|P_M,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sf  stealth fighter",15,5, 1500, 390, 45, 3, 18,15,  20,  2,  4,
#ifdef STEALTHV
                                                                     80, 
                                                                    P_T|P_F|P_L,
#else
                                                                P_T|P_F|P_X|P_L,
#endif STEALTHV

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sb  stealth bomber",15, 5, 2000, 390, 15, 8,  4,14,  17,  2,  3,
#ifdef STEALTHV
                                                                     80, 
                                                                        P_T|P_B,
#else
                                                                    P_X|P_T|P_B,
#endif STEALTHV


/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"mi3 missile 3",    10,  3,  400, 390, 40,10,  0,0,   17,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_L|P_T|P_M,

#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"nc4 naval chopper 4",   8,    2, 1000, 390, 20, 2,  0,4,   15,  2,  2,
#ifdef STEALTHV
                                                                    10, 
#endif STEALTHV
#ifdef SWEEP_PLANES
#ifdef SHIPCHOPPERS
                                                        P_V|P_SWEEP|P_T|P_A|P_K,
#else
                                                            P_V|P_SWEEP|P_T|P_A,
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
                                                                P_V|P_T|P_A|P_K,
#else
                                                                    P_V|P_T|P_A,
#endif /* SHIPCHOPPERS */
#endif /* SWEEP_PLANES */
#endif /* ASW_PLANES */


#ifdef ASW_PLANES
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"np4 naval plane 4",15,  5, 1200, 390, 40, 2,  1,3,   31,  2,  2,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
#ifdef MINE_PLANES
                                                         P_MINE|P_C|P_T|P_A|P_L,
#else
                                                                    P_T|P_A|P_L,
#endif /* MINE_PLANES */
#endif /* ASW_PLANES */


/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"sm3 sam 3",         3,  1,  200, 390,  0, 0, 25,0,   19,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_V|P_F|P_M,

#ifdef ABM
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ab2 abm 2",        10,  4,  500, 390,  0, 0, 40,0,   17,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_N|P_M,
#endif /* ABM */

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ss2 spysat 2",     20, 20, 3000, 390,  0, 0,  0,2,   81,  0,  9,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                    P_I|P_O|P_S,

/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"a-sat 2",          20, 20,  500, 410, 30, 8,  0,6,   21,  0,  4,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_O|P_M,

#ifdef ABM
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ab3 abm 3",        10,  4,  500, 410,  0, 0, 50,0,   19,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_N|P_M,
#endif /* ABM */

#ifdef ABM
/* name            lcm hcm   $$$  tch acc ld  at/df  ran mil gas stlth  flags */
"ab4 abm 4",        10,  4,  500, 430,  0, 0, 60,0,   21,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                        P_N|P_M,
#endif /* ABM */

"",                  0,  0,    0,   0,  0, 0,  0,0,    0,  0,  0,
#ifdef STEALTHV
                                                                     0, 
#endif STEALTHV
                                                                              0,
};

int	pln_maxno   = (sizeof(plchr) / sizeof(struct plchrstr)) - 1;
