/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 * $Revision: 1.4 $ $Date: 89/06/01 14:18:30 $
 */

#include <ctype.h>
#include <sys/types.h>
#include <ctype.h>

#ifdef hpux
#include <string.h>
#else
#include <strings.h>
#endif

#include "options.h"

#define MAXNOC		100

#define WORLD_X		32
#define WORLD_Y		16

typedef u_char natid;		/* also change NSC_NATID in nsc.h */
#ifndef aix
typedef char s_char;		/* change to signed char for aix */
#else
typedef signed char s_char;
#endif aix
typedef	short coord;		/* also change NSC_COORD in nsc.h */
/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((s_char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#endif

#define minutes(x)	(60*(x))
#define hours(x)	(60*60*(x))
#define days(x)		(60*60*24*(x))

typedef void (*voidfunc)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
extern	long random();

extern	double dmax();
extern	double dmin();

extern	s_char *fmt(/* s_char * */);
extern	s_char *copy();
extern	s_char *numstr();
extern	s_char *esplur();
extern	s_char *splur();
extern	s_char *iesplur();
extern	s_char *plur();
extern	s_char *getstarg();
extern	s_char *getstring();

/*
 * frequently used libc functions
 */

extern	s_char *malloc();
extern	s_char *calloc();

#ifndef aix
extern	s_char *ctime();
extern	s_char *strncpy();
extern	s_char *strcpy();
extern	s_char *index();
extern	s_char *rindex();
#endif /* aix */

extern	time_t time();
extern	double atof();
