/* $Header: /home/hyperion/mu/christos/src/mine/lib/RCS/util.h,v 1.7 1991/02/04 01:07:08 christos Exp $ */
/*
 *
 * util.h : Standard utilities file.
 *
 * Modification history:
 * $Log: util.h,v $
 * Revision 1.7  1991/02/04  01:07:08  christos
 * Align_t is used in aix, so we call our's aligned_t.
 *
 * Revision 1.6  1991/02/01  08:17:23  christos
 * Added Calloc and Debug...() routines
 *
 * Revision 1.5  91/01/09  18:26:13  christos
 * Fixed sprintf declaration, cause gcc 1.38
 * Also cleaned up math decls.
 * 
 * Revision 1.4  90/10/18  19:04:30  christos
 * Fixed some sun incompatibilities.
 * 
 * Revision 1.3  90/07/11  16:21:51  christos
 * Test release.
 * 
 * Revision 1.2  90/07/11  16:21:00  christos
 * Added Realloc()
 *
 * Revision 1.1  90/07/11  16:21:00  christos
 * Initial Revision
 * 
 */
#ifndef _h_util
#define _h_util

#ifndef FILE
#include <stdio.h>
#endif /* FILE */

#ifndef TRUE
# define TRUE 			1
# define FALSE 			0
#endif  /* TRUE */

#define private			static
#define public

#ifdef DEBUG
# define Malloc(a)	DebugMalloc(a, __FILE__, __LINE__)
# define Realloc(a, n)	DebugRealloc(a, n, __FILE__, __LINE__)
# define Calloc(a, n)	DebugCalloc(a, n, __FILE__, __LINE)
# define Free(a)	DebugFree(a, __FILE__, __LINE__)
# define MemPtr(a)	DebugMemPtr(a, __FILE__, __LINE__)
# define MemUsed()	DebugMemUsed()
# define MemChain()	DebugMemChain()
#endif /* DEBUG */

#define NEW(a)			(a *) Malloc(sizeof(a))
#define NEWN(a, n)		(a *) Malloc(sizeof(a) * (unsigned) (n))
#ifdef __STDC__
# define RENEWN(o, a, n)        (a *) Realloc((void *) (o), sizeof(a) * \
					      (unsigned) (n))
# define DISPOSE(a)		Free((void *) (a))
# define SIZEOF(a)		MemPtr((void *) (a))
#else
# define RENEWN(o, a, n)        (a *) Realloc((char *) (o), sizeof(a) * \
					      (unsigned) (n))
# define DISPOSE(a)		Free((char *) (a))
# define SIZEOF(a)		MemPtr((char *) (a))
#endif
#ifndef NIL
# define NIL(a)			((a *) 0)
#endif
#ifndef MIN
# define MIN(a, b) 		((a) > (b) ? (b) : (a))
#endif
#ifndef MAX
# define MAX(a, b) 		((a) < (b) ? (b) : (a))
#endif
#ifndef ABS
# define ABS(a)			((a) < 0 ? -(a) : (a))
#endif
#ifndef SGN
# define SGN(a)			((a) > 0 ? 1 : ((a) < 0 ? -1 : 0))
#endif
#ifndef SQR
# define SQR(a)			((a) * (a))
#endif
#ifndef SWAP
# define SWAP(a,b)		(a ^= b, b ^= a, a ^= b)
#endif
#ifndef MASK
# define MASK(a)		((1 << (a)) - 1)
#endif
#ifndef LOW
# define LOW(x)			((x) & 0xff)
#endif
#ifndef HIGH
# define HIGH(x)		(((x) >> 8) & 0xff)
#endif

/*
 * To give a good debugging message and die
 */
#ifdef DEBUG
#define ASSERT(a, m)		if (!(a)) { \
				    (void) fprintf(stderr, \
					"%s (%s at %d), aborting\n", \
					(m), __FILE__, __LINE__); \
				    (void) abort(); \
				} else ;
#else
#define ASSERT(a, m)		if (!(a)) { \
				    (void) fprintf(stderr, \
					"%s (%s at %d), exiting\n", \
					(m), __FILE__, __LINE__); \
				    (void) exit(-1); \
				} else ;
			
#endif
				
#ifndef BSD
# define PROGNAME(b)  ((((char *) strrchr(*(b), '/')) != NIL(char)) ? \
		        ((char *) (strrchr(*(b), '/') + 1)) : *(b))
#else
# define PROGNAME(b)  ((((char *) rindex(*(b), '/')) != NIL(char)) ? \
		        ((char *) (rindex(*(b), '/') + 1)) : *(b))
#endif
/*
 *	Utilties for setjmp, longjump
 */
#define CHECKPOINT(m, v)	if ( setjmp(v) ) { \
				    (void) fprintf(stdout, "%s\n", (m)); \
				    return; \
				} 
#define ABORT(c, m, v)		if ( !(c) ) { \
				    (void) fprintf(stdout, "%s, ", (m)); \
				    longjmp(v, 1); \
				} 


#define forever()		for(;;)
#define strdup(_s)		strcpy((char *) \
				    Malloc((unsigned) (strlen(_s) + 1)), _s)

/*
 *	Errors
 */
extern int sys_nerr, errno;
extern char *sys_errlist[];
#define PERROR			(errno >= 0 && errno < sys_nerr ? \
					sys_errlist[errno] : "Unknown Error")
/* some useful constants */
#ifndef M_PI		/* hack for 4.2 or 4.3 (4.2 has it 4.3 not) */
# define M_E			2.7182818284590452354
# define M_LOG2E			1.4426950408889634074
# define M_LOG10E		0.43429448190325182765
# define M_LN2			0.69314718055994530942
# define M_LN10			2.30258509299404568402
# define M_PI			3.14159265358979323846
# define M_PI_2			1.57079632679489661923
# define M_PI_4			0.78539816339744830962
# define M_1_PI			0.31830988618379067154
# define M_2_PI			0.63661977236758134308
# define M_2_SQRTPI		1.12837916709551257390
# define M_SQRT2		1.41421356237309504880
# define M_SQRT1_2		0.70710678118654752440
#endif /* M_PI */

#ifndef MAXFLOAT
# define MAXFLOAT		((float)1.701411733192644299e+38)
#endif /* MAXFLOAT */

#ifndef MINFLOAT
# define MINFLOAT		((float)-1.701411733192644299e+38)
#endif /* MINFLOAT */

#ifndef MAXINT
# define MAXINT			0x7fffffff
#endif /* MAXINT */

#ifndef MININT
# define MININT			0x80000000
#endif /* MININT */

#ifdef sun
# ifndef __STDC__
extern char *sprintf();
extern void exit();	/* sunos 4.1+ */
extern long atol();
extern long strtol();
#endif /* __STDC__ */
#endif /* sun */

/*
 *	From alloc.c
 */
#ifdef __STDC__
# ifdef DEBUG
extern void *		DebugMalloc(unsigned n, char *fn, int ln);
extern void *		DebugCalloc(unsigned n, unsigned sz, char *fn, int ln);
extern void *		DebugRealloc(void * ptr, unsigned n, char *fn, int ln);
extern void		DebugFree(void * ptr, char *fn, int ln);
extern unsigned 	DebugMemPtr(void * ptr, char *fn, int ln);
extern unsigned 	DebugMemStat(void);
extern void 		DebugMemChain();
# else
extern void *		Malloc(unsigned n);
extern void *		Calloc(unsigned n, unsigned sz);
extern void *		Realloc(void * ptr, unsigned n);
extern void		Free(void * ptr);
extern unsigned 	MemPtr(void * ptr);
extern unsigned 	MemStat(void);
extern void 		MemChain();
# endif /* DEBUG */
#else
/*
 * Fool lint to believe tha Malloc returns aligned pointers...
 */
# ifdef lint
typedef union aligned_t {
    char a; short b; int c; long d; float e; double f; union aligned_t *g;
} aligned_t;
#else
typedef char aligned_t;
#endif /* lint */

# ifdef DEBUG
extern aligned_t *	DebugMalloc();
extern aligned_t *	DebugRealloc();
extern aligned_t *	DebugCalloc();
extern void 		DebugFree();
extern unsigned 	DebugMemPtr();
extern unsigned 	DebugMemStat();
extern void		DebugMemChain();
# else
extern aligned_t *	Malloc();
extern aligned_t *	Realloc();
extern aligned_t *	Calloc();
extern void 		Free();
extern unsigned 	MemPtr();
extern unsigned 	MemStat();
extern void		MemChain();
# endif /* DEBUG */
#endif /* __STDC__ */

/*
 *	From arrayn.c
 */
#ifdef __STDC__
extern void	*	arrayn(int ndim, ...);
#else
extern aligned_t *	arrayn();
#endif /* __STDC__ */

/*
 *	From egets.c
 */
#ifdef __STDC__
extern char	*	egets(char *buf, int siz, FILE *fp);
#else
extern char	*	egets();
#endif /* __STDC__ */

#endif /* _h_util */
