;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emp-help.el -- Help fcn support for Gnu Emacs Empire Tool (GEET)
;; 
;; Copyright (c) 1990 Lynn Randolph Slater, Jr
;; 
;; Author          : Lynn Slater (lrs@indetech.com)
;; Created On      : Sun Oct 28 14:54:16 1990
;; Last Modified By: Lynn Slater x2048
;; Last Modified On: Thu Feb 14 19:17:00 1991
;; Update Count    : 30
;; Status          : GEET General Release 2d Patch 0
;; 
;; HISTORY
;; PURPOSE
;; 	This file contains code that empire uses but which SHOULD be in help.el
;; Nothing in this file is special to empire.
;; TABLE OF CONTENTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The contents of this file ARE copyrighted but permission to use, modify,
;; and distribute this code is granted as described in the file
;; emp-install.el which should have been distributed with this file. These
;; terms constitute what the Free Software Foundation calls a COPYLEFT.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'emp-help)

(defvar help-character (format "%c" help-char))	; current command string
(defvar help-ch help-char)			; current command character
						; (an integer)

(defmacro make-help-screen (fname help-line help-text helped-map)
  "Constructs function FNAME that when invoked shows HELP-LINE and if a help
character is requested, shows HELP-TEXT. The user is prompted for a character
from the HELPED-MAP.

This operation is the same as used by help-for-help.
This fcn supports the extended help character choices advocated by 
Mark Baushke, Rich Berlin, and Lynn Slater"
  (` (defun (, fname) ()
	   (, help-text)
	   (interactive)
	   (let ((line-prompt
		  (substitute-command-keys (, help-line))))
	     (message line-prompt)
	     (let ((char (read-char)))
	       (if (or (= char ??) (= char help-ch))
		   (save-window-excursion
		     (switch-to-buffer-other-window "*Help*")
		     (erase-buffer)
		     (set-window-hscroll (selected-window) 0)
		     (insert (documentation (quote (, fname))))
		     (goto-char (point-min))
		     (while (memq char (cons help-ch '(?? ?\C-v ?\ ?\177 ?\M-v)))
		       (if (memq char '(?\C-v ?\ ))
			   (scroll-up))
		       (if (memq char '(?\177 ?\M-v))
			   (scroll-down))
		       (message "%s%s: "
				line-prompt
				(if (pos-visible-in-window-p (point-max))
				    "" " or Space to scroll"))
		       (let ((cursor-in-echo-area t))
			 (setq char (read-char))))))
	       (let ((defn (if (vectorp (, helped-map))
			       (aref (, helped-map) char)
			     (cdr (assq char (, helped-map)))
			     )))
		 (if defn
		     (if (keymapp defn)
			 (error "Sorry, this command cannot be run from the help screen.  Start over.")
		       (call-interactively defn))
		   (ding))))))
     ))
