/****************************************************************
*  function:  wee mapmaker
*
*  small version of the sve mapmaker
*  turns a dump output into a data structure Map[][]
*
*  requires the services of the *Sector global
****************************************************************/

#include <stdio.h>
#include "sve.h"

extern struct Secdata *Sector;

struct maptype Map[XWIDTH][YHEIGHT];

weemapmaker(sectorcount)
int sectorcount;
{
  int i,j;
  int x,y;

  for (i=0; i < XWIDTH; i++)	/* initialize Map structures */
    for (j=0; j < YHEIGHT; j++)
      {
	Map[i][j].designation = '.';
	Map[i][j].status = 0;
      }

  for (i=0; i < sectorcount; i++)
    {
      x = Sector[i].Census.X;
      y = Sector[i].Census.Y;

      recoordinate(&x, &y);

      if (Sector[i].Census.Sdes != '_')
	Map[x][y].designation = Sector[i].Census.Sdes;
      else
	Map[x][y].designation = Sector[i].Census.Des;
      Map[x][y].status = 2;
      Map[x][y].secnumber = i;
    }
}
