/**********************************************************/
/*  header file:   sve.h                                  */
/*                                                        */
/*  contains declaration of global data structure for     */
/*  the entire "sve" package of empire tools              */
/*                                                        */
/**********************************************************/ 

#define XWIDTH 128		/* width of world; SET THIS! */
#define YHEIGHT 128		/* height of the world; SET THIS! */
#define SECTORS ((sizeof(*Sector))/(sizeof(struct Secdata)))
				/* macro for how many sectors exist */

struct Cendata {		/* substructure: CENSUS INFORMATION */
  int X;			
  int Y;			
  char Des;			
  char Sdes;			
  int Eff;			
  int Mob;			
  char Occupied;		
  int Work;			
  int Avail;			
  int Terr;			
  int Civ;			
  int Mil;			/* NOTE: uw population is stored as */
};				/* a commodity                      */

struct Resdata {		/* substructure: RESOURCE INFORMATION */
  int Min;			
  int Gold;			
  int Fert;
  int Ocontent;
  int Uran;
};

struct Comdata {		/* substructure: COMMODITY INFORMATION */
  int Comm[12];
  char Deliver[12];		/* stored as arrays of 12 elements */
  int Cut[12];			/* order: u f s g p i d b o l h r  */
};

struct Levdata {		/* substructure: LEVEL INFORMATION */
  char Dist_path[11];		/* <-- stores dist path as an array of char */
  int Dist_x;
  int Dist_y;
  int Dist[12];			/* stores dist thresholds as array of int */
};				/* see commodities for order of array    */

struct Secdata {		/* the whole thing: SECTOR INFORMATION */
  struct Cendata Census;
  struct Resdata Resource;
  struct Comdata Commod;
  struct Levdata Level;
};

static char Direction[6] = {'y', 'u', 'j', 'n', 'b', 'g'}; 

struct maptype {
  char designation;
  int status;
  int secnumber;		/* sector number of this hex in Sector[] */
};
